<?php

class AFFWP_CRYPTO_Wallet {

    //protected $plugin_settings;
    protected $plugin_config;
    public $exchange_rates;

    public function __construct() {

        $affiliate_wp_crypto = affiliate_wp_crypto();
        $this->plugin_config = $affiliate_wp_crypto->plugin_config;
        //$this->plugin_settings = $affiliate_wp_crypto->plugin_settings;

        //$this->exchange_rates = array();

        // ajax call. return array including 'type' => 'success'
        // filter: affwp_crypto_ajax_{$task}
        //add_filter( 'affwp_crypto_ajax_test', array( $this, 'wallet_ajax_testing' ) );
        add_filter('affwp_crypto_ajax_load_wallet_settings_ui', array($this, 'ajax_load_wallet_settings_ui'));
        add_filter('affwp_crypto_ajax_load_sources', array($this, 'ajax_load_sources'));
        add_filter('affwp_crypto_ajax_save_sources', array($this, 'ajax_save_sources'));
        add_filter('affwp_crypto_ajax_load_currencies', array($this, 'ajax_load_currencies'));
        add_filter('affwp_crypto_ajax_save_currency', array($this, 'ajax_save_currency'));
        add_filter('affwp_crypto_ajax_save_currency_token', array($this, 'ajax_save_currency_token'));
        add_filter('affwp_crypto_ajax_remove_source', array($this, 'ajax_remove_source'));
        add_filter('affwp_crypto_ajax_deactivate_currency', array($this, 'ajax_deactivate_currency'));
        add_filter('affwp_crypto_ajax_reactivate_currency', array($this, 'ajax_reactivate_currency'));
        add_filter('affwp_crypto_ajax_remove_currency', array($this, 'ajax_remove_currency'));

        add_shortcode('wallet_testing', array($this, 'wallet_testing'));

    }

    public function wallet_testing() {

        //echo '<pre>';
        //print_r($this->get_active_currencies());
        //echo '</pre>';

        //echo '<pre>';
        //print_r($this->get_currency_config('eth:candy'));
        //print_r($this->update_currency_meta());
        //echo '</pre>';
        //echo $this->is_source_active('cryptoapis');

        //$this->update_currency_meta();
        //echo $this->get_currency_meta('eth:candy', 'logo');

        //$source_key = $this->get_service_source('import_address');
        //echo $this->get_currency_send_field_classes($source_key, 'eth', 'import_address', 'privateKey');

        echo '<pre>';
        print_r($this->get_currency_methods('eth'));
        echo '</pre>';;

    }

    // Array of possible wallet integrations
    public function get_wallet_sources() {

        return affiliate_wp_crypto()->base->integrations->payment_sources;

    }

    public function get_source_config($source, $return = '') {

        $sources = $this->get_wallet_sources();

        if ( !empty($return) ) return $sources[$source][$return];

        return $sources[$source];


    }

    public function get_send_fields($source_key, $service_key, $currency) {

        $source_data = $this->get_source_config($source_key);
        $send_fields = $source_data['send_services'][$service_key]['send_fields'][$currency];

        return $send_fields;

    }

    public function get_no_save_fields($source_key, $service_key, $currency) {

        $source_data = $this->get_source_config($source_key);
        $send_fields = $source_data['send_services'][$service_key]['no_save_fields'][$currency];

        return $send_fields;

    }

    // Returns a list of active sources
    public function get_active_sources() {

        $available_sources = $this->get_wallet_sources();
        $enabled_sources = $this->get_enabled_sources();

        $active_sources = $enabled_sources;

        foreach ($enabled_sources as $key => $args) :

            if ( !array_key_exists($key, $available_sources) ) :

                unset($active_sources[$key]);

            endif;

        endforeach;

        return $active_sources;

    }

    // Returns an array of enabled sources from options
    public function get_enabled_sources() {

        //$sources = get_option('affwp_crypto_activated_sources', array());
        //return $sources;
        return affiliate_wp_crypto()->base->integrations->get_enabled_payment_sources();

        /*return $sources = array(
            'cryptoapis' => array(
                'api_key' => '',
            ),
            'coinbase' => array(
                'api_key' => '',
            ),
            'metamask' => array()
        );*/

    }

    // Checks if a source is active
    public function is_source_active($source) {

        $active_sources = $this->get_active_sources();

        if ( array_key_exists($source, $active_sources) ) return true;

        return false;

    }

    // Get a source's active currencies
    public function get_sources_active_currencies($source_key) {

        $active_currencies = $this->get_active_currencies();
        $deactivated_currencies = $this->get_deactivated_currencies();

        $source_currencies = array();

        if ( !empty($active_currencies) ) :

            foreach ($active_currencies as $c_key => $c_data) :

                if ( isset($c_data['source']) && $c_data['source'] == $source_key ) :

                    if ( !array_key_exists($c_key . '-' . $source_key, $deactivated_currencies) ) :

                        $source_currencies[] = $c_key;

                    endif;

                endif;

            endforeach;

        endif;

        return $source_currencies;
    }

    public function source_has_active_currencies($source_key) {

        $source_currencies = $this->get_sources_active_currencies($source_key);

        return (!empty($source_currencies)) ? true : false;

    }

    // Get a service's source
    public function get_service_source($service) {

        $sources = $this->get_wallet_sources();

        foreach ($sources as $source_key => $source_data) :

            foreach ($source_data['send_services'] as $service_key => $service_data) :

                if ( $service_key == $service ) return $source_key;

            endforeach;

        endforeach;

        return '';
    }

    // Get send services of all active sources
    public function get_active_send_services() {

        $send_services = array();

        //$enabled_sources = $this->get_enabled_sources();
        $wallet_sources = $this->get_wallet_sources();
        //$enabled_sources = $this->get_enabled_sources();

        if ( !empty($wallet_sources) ) :

            foreach ($wallet_sources as $source_key => $source_data) :

                //$source_data = $this->get_source_config($source_key);
                //$services = $source_data['send_services'];
                //print_r($source_data);
                if ( !empty($source_data['send_services']) && $this->is_source_active($source_key) ) :
                    //foreach ($services as $service_key => $service_data) :

                    //$send_services[$source_key] = $source_data['send_services'];
                    $send_services[$source_key] = $source_data;

                    //endforeach;
                endif;

            endforeach;

        endif;

        return $send_services;

    }

    // Saves the active sources in the option
    public function activate_source($source, $data) {

        //$enabled_sources = $this->get_enabled_sources();
        //$enabled_sources[$source] = $data;
        //update_option('affwp_crypto_activated_sources', $enabled_sources);

        affiliate_wp_crypto()->base->integrations->activate_payment_source($source, $data);

    }

    // Removes a source from the option
    public function remove_source($source_key) {

        // Deactivate the source
        affiliate_wp_crypto()->base->integrations->remove_payment_source($source_key);

        // Remove currencies that have no active sources
        $currencies = $this->get_enabled_currencies();
        if ( !empty($currencies) ) :

            foreach ($currencies as $currency_key => $currency_data) :

                $c_config = $this->get_currency_config($currency_key);
                $methods = $this->get_currency_methods($c_config['currency']);

                if ( empty($methods) ) :

                    $this->remove_currency($currency_key);

                endif;

            endforeach;

        endif;

        // Deactivate the source
        //affiliate_wp_crypto()->base->integrations->deactivate_payment_source($source_key);

    }

    // Get address data (maybe cached to prevent excessive api calls, false by default)
    public function get_address_data($args, $cached = false) {
        // pass in currency, address, integration

        $currency_key = $args['currency'];

        $address_data = array();
        if ( $cached ) $address_data = $this->address_data[$currency_key];

        if ( empty($address_data[$currency_key]) ) :

            //'address' => $active_currencies[$key]['address'], 'integration' => $active_currencies[$key]['source']

            // Defaults if none provided
            if ( empty($args['address']) || empty($args['integration']) ) :

                $active_currencies = $this->get_active_currencies();

                if ( empty($args['address']) ) :

                    $args['address'] = $active_currencies[$currency_key]['address'];

                endif;

                if ( empty($args['integration']) ) :

                    $args['integration'] = $active_currencies[$currency_key]['source'];

                endif;

            endif;

            $address_data = affiliate_wp_crypto()->base->integrations->get_address($args);

            if ( isset($address_data['api_response']['status']) && $address_data['api_response']['status'] == 'error' ) :

            else:

                $this->address_data[$currency_key] = $address_data;

            endif;

        endif;

        return $address_data;

    }

    public function get_address_balance($args, $formated = false) {

        //$currency_key = $args['currency'];

        //$active_currencies = $this->get_active_currencies();

        //$address = $active_currencies[$currency_key]['address'];

        $address_data = $this->get_address_data(array('currency' => $args['currency']));
        //update_option('affwp_crypto_bb1_'. $args['currency'], $address_data);

        if ( isset($address_data['balance']) ) :

            $balance = $address_data['balance'];
        //update_option('affwp_crypto_bb2_'. $args['currency'], $balance);
        else:

            $balance = 0;

        endif;

        //$ticker = $this->get_currency_config($args['currency'], 'ticker');
        $c_config = affiliate_wp_crypto()->base->wallet->get_currency_config($args['currency']);
        //$max_fee = ($c_config['type'] == 'token') ? $c_config['token_max_fee'] : $c_config['max_fee'];
        //update_option( 'affwp_crypto_'.$currency_key, $max_fee);
        $decimals = ($c_config['type'] == 'token') ? $c_config['token_decimals'] : $c_config['decimals'];

        // Remove tickers and whitespace is required
        //$r_balance = strtolower($balance);
        //$r_balance = str_replace(strtolower($ticker), '', $r_balance);
        //$r_balance = str_replace(' ', '', $r_balance);

        $r_balance = number_format($balance, $decimals, '.', '');

        if ( $formated == true ) :

            $ticker = $c_config['ticker'];

            $r_balance = $r_balance . ' ' . strtoupper($ticker);

        endif;

        return $r_balance;

        //$address_data = $this->get_address_data(array('currency' => $currency_key, 'address' => $address, 'integration' => $active_currencies[$currency_key]['source']));


    }

    public function get_currency_config($currency_key, $key = '') {

        $currencies = $this->get_currencies();

        // Add custom currencies
        $custom_currencies = $this->get_custom_currencies();
        foreach ($custom_currencies as $c_key => $c_currency) :

            $currencies[$c_key] = $c_currency;

            // Import dependent fields from the parent
            $parent_currency_key = $c_currency['currency'];
            foreach ($currencies[$parent_currency_key] as $p_key => $p_value) :

                $dependencies = $currencies[$parent_currency_key]['token_dependencies'];

                if ( in_array($p_key, $dependencies) ) :
                    $currencies[$c_key][$p_key] = $p_value;
                endif;

            endforeach;

        endforeach;

      $currencies = apply_filters('affwp_crypto_currency_config', $currencies);

      $currency = $currencies[$currency_key];
        if ( empty($key) ) return $currency;

        return $currency[$key];

    }

    // Get all payment methods associated with the currency
    //get_deactivated_currencies()
    public function get_currency_methods($currency_key, $include_manual = true, $source_activated = true) {

        $return_methods = array();

        if ( $include_manual ) :

            $manual_methods = affiliate_wp_crypto()->base->payments->get_currency_manual_methods($currency_key);

            foreach ($manual_methods as $c_key => $c_methods) :

                foreach ($c_methods as $m_key => $m_data) :

                    //$label = $m_data['label'];
                    //$send_services = $m_data['send_services'];

                    $return_methods[$m_key] = $m_data;
                    $return_methods[$m_key]['type'] = 'manual';

                endforeach;

            endforeach;

        endif;


        $adapters = $this->get_wallet_sources();

        foreach ($adapters as $a_key => $a_data) :

            //if ( !$activated || ($activated && $this->is_source_active($a_key) && $this->is_currency_active($currency_key)) ) :
            if ( !$source_activated || ($source_activated && $this->is_source_active($a_key)) ) :

                if ( in_array($currency_key, $a_data['currencies']) && !empty($a_data['send_services']) ) :

                    $return_methods[$a_key] = $a_data;
                    $return_methods[$a_key]['type'] = 'api';

                endif;

            endif;

        endforeach;

        // Filter unnecessary data
        foreach ($return_methods as $m_key => $m_data) :

            $main_keys = array('label', 'send_services', 'type');
            $send_service_keys = array('label');

            foreach ($m_data as $ms_key => $ms_data) :

                if ( !in_array($ms_key, $main_keys) ) unset($return_methods[$m_key][$ms_key]);

                if ( $ms_key == 'send_services' ) :
                    foreach ($ms_data as $ss_key => $ss_data) :

                        foreach ($ss_data as $ssm_key => $ssm_data) :

                            if ( !in_array($ssm_key, $send_service_keys) ) unset($return_methods[$m_key][$ms_key][$ss_key][$ssm_key]);

                        endforeach;

                    endforeach;
                endif;

            endforeach;

        endforeach;

        //echo '<pre>';
        //print_r($return_methods);
        //echo '</pre>';

        return $return_methods;

    }

    // Check is a currency's source is a specific key
    /*public function currency_manual_source_is($currency_key, $source_key) {

        $source = $this->get_currency_settings($currency_key, 'source');

        if ( !empty($source) && $source == $source_key ) :

            return true;

        endif;

        return false;

    }*/

    // Get all active currency methods - wrapper for above but removes deactivated
    public function get_currency_active_methods($currency_key, $include_manual = true) {

        $c_config = $this->get_currency_config($currency_key);

        $return_methods = $this->get_currency_methods($c_config['currency'], $include_manual);

        //$c_config = $this->get_currency_config($currency_key);

        // Remove non-manual methods if not configured for the currency
        // Remove if the currency is not configured for the source
        $c_settings = $this->get_currency_settings($c_config['currency']);
        //update_option('affwp_crypto_check_00_' . $currency_key, $c_settings);
        $source = $c_settings['source'];
        $method = $c_settings['method'];

        $methods = $this->get_currency_methods($c_config['currency'], false);
        //update_option('affwp_crypto_check_0_' . $currency_key, $methods);

        // Remove if not configured
        foreach ($methods as $m_key => $m_data) :

            foreach ($m_data['send_services'] as $s_key => $s_data) :
                // Remove if not configured
                if ( (empty($source) || empty($method)) || ((!empty($source) || !empty($method)) && ($source != $m_key && $method != $s_key)) ) :

                    unset($return_methods[$m_key]);

                endif;

            endforeach;

        endforeach;

        // Remove deactivated methods (may include manual)
        $methods = $this->get_currency_methods($currency_key, $include_manual);
        $deactivated = $this->get_deactivated_currencies();

        foreach ($methods as $m_key => $m_data) :

            if ( array_key_exists($currency_key . '-' . $m_key, $deactivated) ) :

                unset($return_methods[$m_key]);

            endif;

        endforeach;

        //update_option('affwp_crypto_check_1_' . $currency_key, $return_methods);

        return $return_methods;

    }

    public function is_currency_method_active($currency_key, $method_key) {

        $methods = $this->get_currency_active_methods($currency_key);
        if ( array_key_exists($method_key, $methods) ) return true;

        return false;

    }

    // Update all currency meta
    public function update_currency_meta($currencies_string = '') {

        $currencies_1 = $this->get_active_currencies(true, true);
        $currencies_2 = $this->get_available_currencies();
        $currencies = array_merge($currencies_1, $currencies_2);

        if ( empty($currencies_string) ) :

            if ( !empty($currencies) ) :

                $currencies_string = '';
                $count = 1;

                foreach ($currencies as $c_key => $c_data) :

                    if ( $count != 1 ) $currencies_string .= ',';
                    $currencies_string .= $this->get_currency_config($c_key, 'ticker');

                    ++$count;
                endforeach;

                $currencies_string;

            endif;

        endif;


        if ( !empty($currencies_string) ) :

            $meta = affiliate_wp_crypto()->base->integrations->get_meta(array('currencies' => $currencies_string));

        endif;

        if ( !empty($meta) ) :

            $meta_array = get_option('affwp_crypto_currencies_meta', array());

            foreach ($currencies as $c_key => $c_data) :

                $ticker = $this->get_currency_config($c_key, 'ticker');

                if ( isset($meta[$ticker]) ) :
                    $meta_array[$c_key] = $meta[$ticker];
                endif;

            endforeach;

            update_option('affwp_crypto_currencies_meta', $meta_array);

        endif;

    }

    // Get a currencies meta array or individual key
    public function get_currency_meta($currency_key, $key = '') {

        $currencies_meta = get_option('affwp_crypto_currencies_meta', array());
        $ticker = $this->get_currency_config($currency_key, 'ticker');

        if ( empty($currencies_meta) || empty($currencies_meta[$currency_key]) ) :

            $this->update_currency_meta($ticker);
            $currencies_meta = get_option('affwp_crypto_currencies_meta', array());

        endif;

        $currencies_meta = apply_filters('affwp_crypto_currency_meta', $currencies_meta, $currency_key, $ticker);

        if ( !empty($currencies_meta) ) :

            if ( !empty($currencies_meta[$currency_key]) ) :

                //$currencies[$currency_key] = apply_filters('affwp_crypto_currency_meta', $currencies[$currency_key], $currency_key, $ticker);

                if ( !empty($key) ) return $currencies_meta[$currency_key][$key];

                return $currencies_meta[$currency_key];

            endif;

        endif;

        return '';

    }

    // Returns a currency's settings from the active currencies array
    // Custom currencies pull their parent's source settings ( set in get_active_currencies() )
    public function get_currency_settings($currency_key, $key = '') {

        $active_currencies = $this->get_active_currencies();

        if ( !empty($active_currencies[$currency_key]) && !empty($key) ) :

            if ( !empty($active_currencies[$currency_key][$key]) ) :

                return $active_currencies[$currency_key][$key];

            else:

                return '';

            endif;

        endif;

        if ( !empty($active_currencies[$currency_key]) ) :

            return $active_currencies[$currency_key];

        else:

            return array();

        endif;


    }

    // Array of potential currencies available in plugin
    public function get_currencies() {

        $currencies = array(
            'btc' => array(
                'name' => 'Bitcoin',
                'currency' => 'btc',
                'type' => 'currency',
                'ticker' => 'BTC',
                'decimals' => 8,
                'fee' => 0.00023141,
                'max_fee' => '0.00023141',
                'fee_currency' => 'btc',
                'confirmations' => 1,
                'explorer_url' => array('mainnet' => 'https://blockstream.info/tx/#thash#', 'testnet' => 'https://blockstream.info/testnet/tx/#thash#'),
                'mainnet' => 'mainnet',
                'testnet' => 'testnet'
            ),
            'eth' => array(
                'name' => 'Ethereum',
                'currency' => 'eth',
                'type' => 'currency',
                'ticker' => 'ETH',
                'decimals' => 18,
                'gas_price' => 3000000000,
                'gas_limit' => 21000,
                'max_fee' => '0.000063',
                'fee_currency' => 'eth',
                'confirmations' => 10,
                //'explorer_url' => 'https://etherscan.io/tx/#thash#',
                'explorer_url' => array('mainnet' => 'https://etherscan.io/tx/#thash#', 'testnet' => 'https://rinkeby.etherscan.io/tx/#thash#'),
                'mainnet' => 'mainnet',
                'testnet' => 'rinkeby',
                /*'manual_methods' => array('metamask' => 'MetaMask'),*/
                //'display_fields' => array('tokens', 'metamask'), // extra fields on the initial currency activation form (not currently used)
                'allow_tokens' => true,
                'token_gas_price' => 10000000000,
                'token_gas_limit' => 55000,
                'token_max_fee' => '0.00055',
                'token_fee_currency' => 'eth',
                'token_dependencies' => array(
                    'explorer_url',
                    'manual_methods',
                    'token_gas_price',
                    'token_gas_limit',
                    'token_max_fee',
                    'token_fee_currency'
                )
            ),
            'ltc' => array(
                'name' => 'Litecoin',
                'currency' => 'ltc',
                'type' => 'currency',
                'ticker' => 'LTC',
                'decimals' => 8,
                'fee' => 0.00023141,
                'max_fee' => '0.00023141',
                'fee_currency' => 'ltc',
                'confirmations' => 1,
                //'explorer_url' => 'https://live.blockcypher.com/ltc/tx/#thash#',
                'explorer_url' => array('mainnet' => 'https://live.blockcypher.com/ltc/tx/#thash#', 'testnet' => 'https://chain.so/tx/LTCTEST/#thash#'),

                'mainnet' => 'mainnet',
                'testnet' => 'testnet'
            ),
            'bch' => array(
                'name' => 'Bitcoin Cash',
                'currency' => 'bch',
                'type' => 'currency',
                'ticker' => 'BCH',
                'decimals' => 8,
                'fee' => 0.00023141,
                'max_fee' => '0.00023141',
                'fee_currency' => 'bch',
                'confirmations' => 1,
                //'explorer_url' => 'https://explorer.bitcoin.com/bch/tx/#thash#',
                'explorer_url' => array('mainnet' => 'https://explorer.bitcoin.com/bch/tx/#thash#', 'testnet' => 'https://explorer.bitcoin.com/tbch/tx/#thash#'),
                'mainnet' => 'mainnet',
                'testnet' => 'testnet'
            )
        );

        // Add custom currencies.
        // These will get filtered out as they are not in sources but add them here so the get_currency_config method can find them
        /*$custom_currencies = $this->get_custom_currencies();
        foreach ($custom_currencies as $key => $currency) :

            $currencies[$key] = $currency;

        endforeach;*/

        //$currencies = apply_filters( 'affwp_currencies', $currencies);

        return $currencies;
    }

    // Returns an array of currencies available for the admin to enable (must be in the list set above and also available in one of the active sources)
    public function get_available_currencies($remove_active = false) {

        $sources = $this->get_wallet_sources();
        $active_sources = $this->get_active_sources();
        $available_currencies = $this->get_currencies();

        // Filter the list based on activated sources
        $source_currencies = array();
        foreach ($sources as $source => $parameters) :

            // Check is the source is active. If it it, add it's currencies
            if ( array_key_exists($source, $active_sources) ) :

                $source_currencies = array_unique(array_merge($parameters['currencies'], $source_currencies));

            endif;

        endforeach;

        // Filter out any currencies not in available currencies
        foreach ($available_currencies as $key => $currency) :

            if ( !in_array($key, $source_currencies) ) unset($available_currencies[$key]);

        endforeach;

        // Remove active currencies if requested
        if ( $remove_active ) :

            $active_currencies = $this->get_active_currencies(false, true);
            foreach ($active_currencies as $c_key => $c_data) :

                unset($available_currencies[$c_key]);

            endforeach;

        endif;

        /*echo '<pre>';
        print_r($available_currencies);
        echo '</pre>';*/

        return $available_currencies;
    }

    //$this->is_currency_method_active($c_config['currency'], $method_key)

    // Returns a list of enabled currencies set by the admin.
    // Checks they are still available by an active source
    // Adds currencies with manual methods
    public function get_active_currencies($include_manual_methods = false, $include_deactivated = false) {

        $enabled_currencies = $this->get_enabled_currencies();
        $available_currencies = $this->get_available_currencies();

        // Stat with enabled currencies
        $active_currencies = $enabled_currencies;

        // Double check it's still available
        foreach ($enabled_currencies as $key => $args) :

            if ( !array_key_exists($key, $available_currencies) ) :

                unset($active_currencies[$key]);

            endif;

        endforeach;

        // Remove currencies with no configured non-manual methods.
        //update_option( 'affwp_crypto_check123', $active_currencies);
        /*foreach ($active_currencies as $c_key => $c_data) :

            if ( empty($c_data['source']) || empty($c_data['method']) ) :

                unset($active_currencies[$c_key]);

            endif;

        endforeach;*/

        //update_option( 'affwp_crypto_check123', $active_currencies);

        // Add back on currencies with manual methods
        if ( $include_manual_methods ) :

            $manual_methods = affiliate_wp_crypto()->base->payments->get_manual_methods();

            foreach ($this->get_currencies() as $c_key => $c_data) :

                foreach ($manual_methods as $m_key => $m_data) :

                    //if ( affiliate_wp_crypto()->base->payments->has_manual_methods($c_key) ) :

                    if ( in_array($c_key, $m_data['currencies']) ) :

                        if ( !isset($active_currencies[$c_key]) ) :

                            $active_currencies[$c_key] = array('currency' => $c_key);

                        endif;

                    endif;

                    //endif;

                endforeach;

            endforeach;

        endif;

        //update_option( 'affwp_crypto_check124', $active_currencies);

        /*if ( $include_manual_methods ) :

            foreach ($this->get_currencies() as $key => $currency_data) :

                $c_config = affiliate_wp_crypto()->base->wallet->get_currency_config($key);

                if ( !empty($currency_data['manual_methods']) ) :

                    if ( array_key_exists($key, $active_currencies) ) :

                    else:

                        $active_currencies[$key] = array('currency' => $c_config['currency']);

                    endif;

                endif;

            endforeach;

        endif;*/

        // update_option('affwp_crypto_active_manual2', $active_currencies);

        // Add custom currencies
        $custom_currencies = $this->get_custom_currencies();
        if ( !empty($custom_currencies) ) :
            foreach ($custom_currencies as $key => $currency) :

                $active_currencies[$key] = $currency;

                // Import settings from the parent
                $parent_currency_key = $currency['currency'];
                foreach ($active_currencies[$parent_currency_key] as $p_key => $p_value) :

                    $active_currencies[$key][$p_key] = $p_value;

                endforeach;

            endforeach;
        endif;

        // Add the configs to the currency
        /*foreach ($active_currencies as $key => $data) :

            $active_currencies[$key]['config'] = $available_currencies[$key];

        endforeach;*/

        //update_option('affwp_crypto_active_debug', $active_currencies);

        // Remove if all sources are currently deactivated
        if ( $include_deactivated == false ) :

            $deactivated_currencies = $this->get_deactivated_currencies();
            //update_option('affwp_crypto_active_manual3', $deactivated_currencies);
            foreach ($active_currencies as $c_key => $data) :

                $c_activated = false;

                $c_config_currency = $this->get_currency_config($c_key, 'currency');
                $currency_methods = $this->get_currency_methods($c_config_currency, true);

                //update_option('affwp_crypto_active_manual4_' . $c_key, $currency_methods);
                //update_option('affwp_crypto_active_manual5_' . $c_key, $deactivated_currencies);

                foreach ($currency_methods as $method_key => $method_data) :

                    //update_option('affwp_crypto_active_manual4_' . $c_key, $data);
                    //update_option('affwp_crypto_active_manual5_' . $c_key, $method_data);

                    // Only check manual of the active non-manual method
                    if ( ($include_manual_methods && $method_data['type'] == 'manual') || array_key_exists($data['method'], $method_data['send_services']) ) :

                        // could be $this->is_currency_source_deactivated() ?
                        if ( !array_key_exists($c_key . '-' . $method_key, $deactivated_currencies) ):
                            //&& $this->is_currency_method_active($c_key, $method_key)

                            $c_activated = true;
                            break;

                        endif;

                    endif;

                endforeach;

                if ( $c_activated == false ) unset($active_currencies[$c_key]);

            endforeach;

        endif;

        //update_option('affwp_crypto_active_debug_1', $active_currencies);

        //update_option('affwp_crypto_active_currencies_array', $active_currencies);

        $active_currencies = apply_filters('affwp_crypto_active_currencies', $active_currencies);

        //update_option( 'affwp_crypto_check124567', $active_currencies);

        return $active_currencies;

    }

    // Check if a currency is active
    public function is_currency_active($currency_key, $include_manual_methods = false, $include_deactivated = false) {

        $active_currencies = $this->get_active_currencies($include_manual_methods, $include_deactivated);

        if ( array_key_exists($currency_key, $active_currencies) ) return true;

        //if ( $include_manual_methods && $this->has_manual_methods($currency_key) ) return true;

        return false;

    }

    // Returns an array of enabled currencies from admin settings
    // This should never be called directly unless needing to modify the option
    public function get_enabled_currencies() {

        $currencies = get_option('affwp_crypto_activated_currencies_'.affwp_crypto_get_network(), array());

        //unset($currencies['ltc']);
        //unset($currencies['btc']);
        //update_option('affwp_crypto_activated_currencies', $currencies);

        return $currencies;

    }

    // Get deactivated currencies
    public function get_deactivated_currencies() {

        $currencies = get_option('affwp_crypto_deactivated_currencies_'.affwp_crypto_get_network(), array());

        return $currencies;

    }

    // Saves the active currency in the option array
    public function activate_currency($currency_key, $data) {

        $enabled_currencies = $this->get_enabled_currencies();
        //$currency_key = $data['currency'];

        $enabled_currencies[$currency_key] = $data;
        update_option('affwp_crypto_activated_currencies_'.affwp_crypto_get_network(), $enabled_currencies);

        $this->update_currency_meta($this->get_currency_config($currency_key, 'ticker'));

    }

    // Removes a currency from the option array
    public function deactivate_currency_source($currency_key, $source_key) {

        $c_config = $this->get_currency_config($currency_key);
        if ( $c_config['custom'] ) :

            $this->deactivate_custom_currency_source($currency_key, $source_key);

        elseif ( $c_config['type'] == 'currency' ):

            $enabled_currencies = $this->get_enabled_currencies();
            $deactivated_currencies = $this->get_deactivated_currencies();

            // Add currency data to the deactivated array
            $deactivated_currencies[$currency_key . '-' . $source_key]['currency_key'] = $currency_key;
            $deactivated_currencies[$currency_key . '-' . $source_key]['source_key'] = $source_key;
            $deactivated_currencies[$currency_key . '-' . $source_key]['data'] = $enabled_currencies[$currency_key];

            if ( $source_key == $enabled_currencies[$currency_key]['source'] ) :
                $deactivated_currencies[$currency_key . '-' . $source_key]['data'] = $enabled_currencies[$currency_key];
            endif;

            /*foreach ($enabled_currencies[$currency_key] as $key => $value) :

                if ( $key != 'currency' ) unset($enabled_currencies[$currency_key][$key]);

            endforeach;
            update_option('affwp_crypto_activated_currencies', $enabled_currencies);*/

            //endif;

            update_option('affwp_crypto_deactivated_currencies_'.affwp_crypto_get_network(), $deactivated_currencies);

            // Deactivate tokens
            //update_option('affwp_crypto_x', $enabled_currencies);
            foreach ($this->get_custom_currencies() as $c_key => $c_data) :

                $c_config = $this->get_currency_config($c_key);
                if ( $currency_key == $c_config['currency'] ) :
                    $this->deactivate_custom_currency_source($c_key, $source_key);
                endif;

            endforeach;


        endif;

    }

    // Removes a currency from the option array
    public function deactivate_custom_currency_source($currency_key, $source_key) {

        $custom_currencies = $this->get_custom_currencies();
        $deactivated_currencies = $this->get_deactivated_currencies();

        // Add currency data to the deactivated array
        $deactivated_currencies[$currency_key . '-' . $source_key]['currency_key'] = $currency_key;
        $deactivated_currencies[$currency_key . '-' . $source_key]['source_key'] = $source_key;

        if ( $source_key == $custom_currencies[$currency_key]['source'] ) :
            $deactivated_currencies[$currency_key . '-' . $source_key]['data'] = $custom_currencies[$currency_key];
        endif;

        update_option('affwp_crypto_deactivated_currencies_'.affwp_crypto_get_network(), $deactivated_currencies);

        /*foreach ($custom_currencies[$currency_key] as $key => $value) :

            if ( $key != 'currency' ) unset($custom_currencies[$currency_key][$key]);

        endforeach;
        update_option('affwp_crypto_custom_currencies', $custom_currencies);*/


    }

    // Removes a currency from the option array
    public function reactivate_currency_source($currency_key, $source_key) {

        $deactivated_currencies = $this->get_deactivated_currencies();

        $c_config = $this->get_currency_config($currency_key);
        //if ( $c_config['custom'] ) :

        //$this->reactivate_custom_currency_source($currency_key, $source_key);
        //$custom_currencies = $this->get_custom_currencies();
        //$custom_currencies[$currency_key] = $deactivated_currencies[$currency_key.'-'.$source_key]['data'];
        //update_option('affwp_crypto_custom_currencies', $custom_currencies);

        if ( $c_config['type'] == 'currency' ):

            $enabled_currencies = $this->get_enabled_currencies();
            //$deactivated_currencies = $this->get_deactivated_currencies();
            //$enabled_currencies[$currency_key] = $deactivated_currencies[$currency_key . '-' . $source_key]['data'];
            foreach ($deactivated_currencies[$currency_key . '-' . $source_key]['data'] as $key => $value) :

                $enabled_currencies[$currency_key][$key] = $value;

            endforeach;
            update_option('affwp_crypto_activated_currencies_'.affwp_crypto_get_network(), $enabled_currencies);

        //update_option('affwp_crypto_deactivated_currencies', $deactivated_currencies);

        else:

            //$this->reactivate_custom_currency_source($currency_key, $source_key);
            $custom_currencies = $this->get_custom_currencies();
            //$custom_currencies[$currency_key] = $deactivated_currencies[$currency_key . '-' . $source_key]['data'];
            foreach ($deactivated_currencies[$currency_key . '-' . $source_key]['data'] as $key => $value) :

                $custom_currencies[$currency_key][$key] = $value;

            endforeach;
            update_option('affwp_crypto_custom_currencies_'. affwp_crypto_get_network(), $custom_currencies);

        endif;

        //$deactivated_currencies = $this->get_deactivated_currencies();
        unset($deactivated_currencies[$currency_key . '-' . $source_key]);
        update_option('affwp_crypto_deactivated_currencies_'.affwp_crypto_get_network(), $deactivated_currencies);

    }

    // Removes a currency from the option array
    /* public function reactivate_custom_currency_source($currency_key, $source_key) {

         $custom_currencies = $this->get_custom_currencies();
         $deactivated_currencies = $this->get_deactivated_currencies();

         // Add currency data to the deactivated array
         $deactivated_currencies[$currency_key . '-' . $source_key]['currency_key'] = $currency_key;
         $deactivated_currencies[$currency_key . '-' . $source_key]['source_key'] = $source_key;

         if ( $source_key == $custom_currencies[$currency_key]['source'] ) :
             $deactivated_currencies[$currency_key . '-' . $source_key]['data'] = $custom_currencies[$currency_key];
         endif;

         //////// Maybe delete the currency if there are no sources active ////////
         $c_config = $this->get_currency_config($currency_key);
         $methods = $this->get_currency_methods($c_config['currency']);
         if ( empty($methods) ) :

             //$enabled_currencies = $this->get_enabled_currencies();

             if ( isset($custom_currencies[$currency_key]) ) :

                 //unset($custom_currencies[$currency_key]);
                 //update_option('affwp_crypto_custom_currencies', $custom_currencies);
                 $this->remove_currency($currency_key);

             endif;

         endif;

         update_option('affwp_crypto_deactivated_currencies', $deactivated_currencies);

     }*/

    // Remove a currency
    public function remove_currency($currency_key) {

        $c_config = $this->get_currency_config($currency_key);
        //update_option('affwp_crypto_custom_currencies_check0_'.$currency_key, $c_config);
        //$source = $this->get_currency_config($currency_key, 'source');
        //if ( $c_config['custom'] ) :

        if ( $c_config['type'] == 'currency' ):

            $enabled_currencies = $this->get_enabled_currencies();
            // Remove from active array
            unset($enabled_currencies[$currency_key]);
            update_option('affwp_crypto_activated_currencies_'.affwp_crypto_get_network(), $enabled_currencies);

        else:

            $custom_currencies = $this->get_custom_currencies();
            //update_option('affwp_crypto_custom_currencies_check', $custom_currencies);
            // Remove from custom array
            unset($custom_currencies[$currency_key]);
            update_option('affwp_crypto_custom_currencies_' . affwp_crypto_get_network(), $custom_currencies);

        endif;

        // Remove from deactivated currencies/sources
        $deactivated_currencies = $this->get_deactivated_currencies();
        if ( !empty($deactivated_currencies) ) :

            foreach ($deactivated_currencies as $dc_key => $dc_data) :

                if ( $dc_data['currency_key'] == $currency_key ) :

                    unset($deactivated_currencies[$dc_key]);

                endif;

            endforeach;

            update_option('affwp_crypto_deactivated_currencies_'.affwp_crypto_get_network(), $deactivated_currencies);

        endif;

    }

    // Check if a currency/source pair is deactivated (in options array)
    public function is_currency_source_deactivated($currency_key, $source_key) {

        $deactivated_currencies = $this->get_deactivated_currencies();

        if ( isset($deactivated_currencies[$currency_key . '-' . $source_key]) ) :

            return true;

        endif;

        return false;

    }

    // Currency can be deleted
    public function currency_can_be_deleted($currency_key) {

        $c_config = $this->get_currency_config($currency_key);
        $not_manual_methods = $this->get_currency_methods($c_config['currency'], false);
        $manual_methods = affiliate_wp_crypto()->base->payments->get_currency_manual_methods($c_config['currency']);

        //$can_be_deleted = true;

        if ( $c_config['type'] == 'currency' ) :

            if ( !empty($manual_methods) ) :
                //return false;
            endif;

        /*foreach ($not_manual_methods as $method_key => $method_data) :

            if ( !$this->is_currency_source_deactivated($currency_key, $method_key) ) :

                $can_be_deleted = false;
                break;

            endif;

        endforeach;*/

        elseif ( $c_config['custom'] ):
            /*return true;*/
        endif;

        //update_option('affwp_crypto_remove_test', $not_manual_methods);
        foreach ($not_manual_methods as $method_key => $method_data) :

            if ( !$this->is_currency_source_deactivated($currency_key, $method_key) ) :

                return false;
                //break;

            endif;

        endforeach;

        //$this->is_currency_source_deactivated($currency_key, $source_key)

        return true;

    }

    // Returns an array of custom currencies/tokens from admin settings
    // This should never be called directly unless needing to modify the option
    public function get_custom_currencies() {

        $currencies = get_option('affwp_crypto_custom_currencies_' . affwp_crypto_get_network(), array());

        //unset($currencies['eth:candy2']);
        //update_option('affwp_crypto_custom_currencies', $currencies);

        return $currencies;

    }

    // Saves the custom currency in the option array
    public function activate_custom_currency($currency_key, $data) {

        $enabled_currencies = $this->get_custom_currencies();
        //$currency_key = $data['currency'];

        $enabled_currencies[$currency_key] = $data;
        update_option('affwp_crypto_custom_currencies_' . affwp_crypto_get_network(), $enabled_currencies);

        $this->update_currency_meta($this->get_currency_config($currency_key, 'ticker'));

    }

    ///////// AJAX and UI Parts //////////

    // Load the wallet settings UI
    public function ajax_load_wallet_settings_ui() {

        ob_start();
        ?>

        <div class="affwp_crypto_wallet_ui">
            <div class="affwp_crypto_loading loading_indicator lds-dual-ring"></div>
            <!--<h2>Wallet Settings</h2>-->
            <!--<div class="affwp_crypto_ui_section sources">-->
            <!--<div id="affwp_crypto_settings_sources_form_notifications"></div>-->
            <div id="affwp_crypto_settings_sources" class="wallet_section"></div>
            <!--</div>-->
            <!--<div class="affwp_crypto_ui_section currencies">-->
            <!--<div id="affwp_crypto_settings_currencies_form_notifications"></div>-->
            <div id="affwp_crypto_settings_currencies" class="wallet_section"></div>
            <!--</div>-->
        </div>

        <?php echo affwp_crypto_generate_modal(); ?>

        <?php
        $response['type'] = 'success';
        $response['html'] = ob_get_contents();
        ob_end_clean();

        return $response;

    }

    // Load the sources section in the settings UI
    public function ajax_load_sources($response) {

        ob_start();
        ?>

        <!--<table class="affwp_crypto_table">
            <thead>
            <tr>
                <th>Name</th>
                <th>Instrument</th>
            </tr>
            </thead>
            <tbody>
            <tr>
                <td>John Lennon</td>
                <td>Rhythm Guitar</td>
            </tr>
            </tbody>
        </table>-->

        <!--
        <div class="affwp_crypto_ui_section">
            <table class="affwp_crypto_table">
                <thead>
                <tr>
                    <th></th>
                    <th></th>
                </tr>
                </thead>
                <tbody>
                <tr>
                    <td></td>
                    <td></td>
                </tr>
                </tbody>
            </table>
        </div>
        -->
        <div class="affwp_crypto_ui_section">
            <h3>Adapters</h3>
            <div class="affwp_crypto_table_container">
                <table class="affwp_crypto_table settings_adapters">
                    <thead>
                    <tr>
                        <th>Name</th>
                        <th>API Key</th>
                        <th>Actions</th>
                    </tr>
                    </thead>
                    <tbody>
                    <!--<h3>Integrated Adapters</h3>-->


                    <?php
                    $manual_methods = affiliate_wp_crypto()->base->payments->get_manual_methods();
                    foreach ($manual_methods as $m_key => $m_data) :
                        ?>
                        <tr>
                            <td>
                                <?php //echo $m_data['label'];
                                ?>
                                <?php echo affwp_crypto_get_asset_logo($m_key, $m_data['label']); ?>
                            </td>
                            <td></td>
                            <td></td>

                        </tr>
                        <!--<div class="wallet_settings_table_row" id="manual_method_row_<?/*= $m_key; */ ?>">
                        <?php /*//echo $m_data['label']; */ ?>
                        <?php /*//echo affwp_crypto_get_asset_logo($m_key, $m_data['label']); */ ?>
                    </div>-->
                    <?php
                    endforeach;
                    ?>

                    <!--<h3>Activated Adapters / APIs</h3>-->
                    <!--<div class="wallet_settings_table" id="activated_sources">-->
                    <?php
                    $enabled_sources = $this->get_enabled_sources();
                    if ( !empty($enabled_sources) ) :
                        ?>

                        <?php
                        foreach ($enabled_sources as $source_key => $source_data) :
                            echo $this->get_activated_source_row($source_key);
                        endforeach;

                    /*echo '<pre>';
                    print_r($enabled_sources);
                    echo '</pre>';*/

                    else:
                        //echo 'No active Adapters';
                    endif;
                    ?>
                    <!--</div>-->

                    <?php $sources = $this->get_wallet_sources(); ?>
                    <!-- </tbody>
                 </table>
     -->
                    <!--<h3>Add Adapters</h3>-->
                    <!-- <table class="affwp_crypto_table">
                         <tbody>-->

                    <!--<div class="wallet_settings_table">-->

                    <?php
                    foreach ($sources as $key => $source):
                        if ( !$this->is_source_active($key) ) :
                            //$services = $source['send_services'];
                            ?>
                            <tr>
                                <td colspan="3">
                                    <form name="source_settings_<?= $key; ?>" method="post"
                                          id="source_settings_<?= $key; ?>">
                                        <input type="hidden" name="source" value="<?= $key; ?>">

                                        <table class="affwp_crypto_table blind_columns">
                                            <tbody>
                                            <tr>
                                                <!--<div class="wallet_settings_table_row" id="source_row_<?/*= $key; */ ?>">-->

                                                <td>
                                                    <!--<div class="wallet_settings_table_column row_label">-->
                                                    <?php echo affwp_crypto_get_asset_logo($key, $source['label']); ?>
                                                    <!--</div>-->
                                                </td>
                                                <td>
                                                    <!--<div class="wallet_settings_table_column">-->
                                                    <!--<label for="api_key"> API Key:</label>-->
                                                    <input type="text" name="api_key" class="regular-text"
                                                           placeholder="Enter API Key"
                                                           required>
                                                    <!--</div>-->
                                                </td>
                                                <td>
                                                    <!--<div class="wallet_settings_table_column actions">-->
                                                    <input type="submit" name="Submit" data-sourcekey="<?= $key; ?>"
                                                           class="affwp_crypto_ui_button source_submit"
                                                           value="Activate">
                                                    <!--</div>-->
                                                </td>
                                            </tr>
                                            </tbody>
                                        </table>

                                    </form>
                                    <!--</div>-->

                                    <!--<div class="wallet_settings_table_row notifications <?/*= $key; */ ?>"></div>-->
                                </td>
                            </tr>
                        <?php
                        endif;
                    endforeach;
                    ?>

                    <!--</div>-->

                    </tbody>
                </table>
            </div>
        </div>
        <?php
        $response['type'] = 'success';
        $response['html'] = ob_get_contents();
        ob_end_clean();

        return $response;

    }

    // Generate an activated sources row for the settings UI
    public function get_activated_source_row($source_key) {

        $enabled_sources = $this->get_enabled_sources();
        $source_config = $this->get_source_config($source_key);

        $source = $enabled_sources[$source_key];

        if ( !empty($source) ) :

            ob_start();
            ?>
            <tr>
                <td>
                    <?php echo affwp_crypto_get_asset_logo($source_key, $source_config['label']); ?>
                </td>
                <td>
                    <?php echo $source['api_key']; ?>
                </td>
                <td>
                    <span class="affwp_crypto_ui_button wallet_action remove_source <?php echo ($this->source_has_active_currencies($source_key)) ? 'disabled' : 'enabled'; ?>"
                          data-source="<?php echo $source_key; ?>">Remove Adapter</span>
                </td>
            </tr>
            <?php
            $html = ob_get_contents();
            ob_end_clean();
            return $html;

        endif;

    }

    // Process sources form
    public function ajax_save_sources($response) {

        parse_str($_POST['form_data'], $form_data);
        //update_option('affwp_crypto_check_conn_0', $form_data);

        if ( !empty($form_data['api_key']) ) :

            $int_response = affiliate_wp_crypto()->base->integrations->check_connection(array('api_key' => $form_data['api_key'], 'integration' => $form_data['source']));
            //update_option('affwp_crypto_check_conn', $int_response);
            if ( $int_response === true ) :

                //update_option( 'affwp_crypto_check_conn_3', $int_response);

                $data['api_key'] = $form_data['api_key'];
                $this->activate_source($form_data['source'], $data);

                $response['type'] = 'success';

                $messages['Status'] = array(
                    'heading' => 'Activation Successful',
                    'content' => 'Your API key is active'
                );

                $response['notification'] = affwp_crypto_array_to_messages($messages);
                $response['notification_type'] = 'fade';
                $response['notification_style'] = 'success';

            //$response['activated_row'] = $this->get_activated_source_row($form_data['source']);

            elseif ( $int_response['api_response']['status'] == 'error' ):

                /*ob_start();

                echo '<pre>';
                print_r($_POST);
                echo '</pre>';

                echo '<pre>';
                print_r($form_data);
                echo '</pre>';

                echo '<pre>';
                print_r($int_response);
                echo '</pre>';

                $debug = ob_get_contents();
                ob_end_clean();*/

                $response['type'] = 'error';

                $messages['Error'] = array(
                    'heading' => 'Error',
                    'content' => 'Error Code: ' . $int_response['api_response']['code'] . ' -> Message: ' . $int_response['api_response']['message']
                );

                /*$messages['Debug'] = array(
                    'type' => 'debug',
                    'heading' => 'Debug',
                    'content' => $debug
                );*/

                $response['notification'] = affwp_crypto_array_to_messages($messages);
                $response['notification_type'] = 'standard';
                $response['notification_style'] = 'error';

                //$response['errors'] = $formated_messages;

            endif;

        else:

            $messages['Error'] = array(
                'type' => 'error',
                'heading' => 'Error adding Adaptor',
                'content' => 'There was an error adding this adaptor. Please check your API key.',
            );


            $response['type'] = 'error';
            $response['notification'] = affwp_crypto_array_to_messages($messages);
            $response['notification_type'] = 'standard';
            $response['notification_style'] = 'error';

        endif;

        //$response['type'] = 'success';
        return $response;

    }

    public function get_currency_send_field_classes($source_key, $currency_key, $method, $field) {

        $source_data = $this->get_source_config($source_key);
        //echo '<pre>';
        //print_r($source_data);
        //echo '</pre>';

        $fields = $source_data['send_services'][$method]['send_fields'][$currency_key];

        $classes = '';
        if ( in_array($field, $fields) ) :

            $classes .= ' ' . $currency_key;

        endif;

        /*$classes = '';
        foreach ($source_data['send_services'] as $service_key => $service_data) :

            $currency_send_fields = $service_data['send_fields'][$currency_key];
            if ( !empty($currency_send_fields) ) :

                if ( in_array($field, $currency_send_fields) ) :

                    $classes .= ' ' . $currency_key;

                endif;

            endif;

        endforeach;*/

        return $classes;

    }

    // Load the currencies section in the settings UI
    public function ajax_load_currencies($response) {

        $active_currencies = $this->get_active_currencies(true, true);

        ob_start();

        ?>
        <div class="affwp_crypto_ui_section">
            <h3>Wallet Currencies & Tokens</h3>
            <?php if ( affwp_crypto_get_network() != 'mainnet' ) : ?>
                <div style="text-align: center" class="affwp_crypto_network_label">
                    Network: <?php echo ucfirst(affwp_crypto_get_network()); ?></div>
            <?php endif; ?>
            <div class="affwp_crypto_table_container">
                <table class="affwp_crypto_table settings_currencies">
                    <thead>
                    <tr>
                        <th>Currency</th>
                        <th>Adaptors</th>
                        <!--<th>Actions</th>-->
                    </tr>
                    </thead>
                    <tbody>
                    <!--<div class="wallet_settings_table" id="activated_currencies">-->
                    <?php
                    if ( !empty($active_currencies) ) :
                        ?>
                        <?php

                        foreach ($active_currencies as $currency_key => $currency_data) :
                            echo $this->get_activated_currency_row($currency_key);
                        endforeach;

                    /*echo '<pre>';
                    print_r($active_currencies);
                    echo '</pre>';*/

                    else:
                        echo 'No Currencies activated yet';
                    endif;
                    ?>
                    <!--</div>-->
                    </tbody>
                </table>
            </div>
        </div>

        <?php
        $currencies = $this->get_available_currencies(true);
        $wallet_send_services = $this->get_active_send_services();
        ?>

        <!--<div class="wallet_settings_table" id="add_currencies">-->
        <div class="affwp_crypto_ui_section">
            <h3>Add Wallet Currencies/Methods</h3>
            <?php if ( !empty($currencies) && !empty($wallet_send_services) ) : ?>

                <div class="affwp_crypto_table_container">
                    <table class="affwp_crypto_table settings_add_currencies">
                        <thead>
                        <tr>
                            <th>Currency</th>
                            <th>Adaptor / Method</th>
                            <th>Values</th>
                            <th>Actions</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php
                        //if ( !empty($currencies) && !empty($wallet_send_services) ) :

                        foreach ($currencies as $key => $currency):

                            if ( !$this->is_currency_active($key, false, true) ) :
                                ?>
                                <tr class="wallet_settings_table_row">
                                    <!--<div class="wallet_settings_table_row" id="currency_row_<?/*= $key; */ ?>">-->

                                    <td colspan="4">
                                        <form name="currency_settings_<?= $key; ?>" method="post"
                                              id="currency_settings_<?= $key; ?>">
                                            <input type="hidden" name="currency" value="<?= $key; ?>">
                                            <!--<div class="wallet_settings_table_column row_label">-->
                                            <?//= $currency['ticker'];
                                            ?>
                                            <!--</div>-->
                                            <table class="affwp_crypto_table blind_columns">
                                                <tbody>
                                                <tr>
                                                    <td>

                                                        <?php if ( $logo_src = affwp_crypto_get_currency_meta($key, 'logo') ) : ?>
                                                            <img class="affwp_crypto_currency_icon med"
                                                                 title="<?php echo $currency['ticker']; ?>"
                                                                 src="<?php echo $logo_src; ?>">
                                                        <?php
                                                        else:
                                                            echo $currency['ticker'];
                                                        endif;
                                                        ?>
                                                    </td>

                                                    <td>


                                                        <!--<div class="wallet_settings_table_column options1">-->
                                                        <select class="currency_source_method"
                                                                name="currency_source_method">
                                                            <option value="">Select Method</option>
                                                            <?php foreach ($wallet_send_services as $source_key => $source_data) : ?>

                                                                <?php
                                                                //$source_data = $this->get_source_config($source_key);
                                                                foreach ($source_data['send_services'] as $service_key => $service_data) :

                                                                    if ( empty($service_data['limit_currencies']) || !empty($service_data['limit_currencies']) && in_array($currency['ticker'], $service_data['limit_currencies']) ) :
                                                                      $sd_display_fields = (!empty($service_data['display_fields'])) ? implode(" ", $service_data['display_fields']).' ' : '';
                                                                      $c_display_fields = (!empty($currency['display_fields'])) ? implode(" ", $currency['display_fields']) : '';
                                                                      ?>
                                                                        <option data-displayfields="<?= $sd_display_fields . $c_display_fields; ?>"
                                                                                data-sourcekey="<?= $source_key; ?>"
                                                                                data-servicekey="<?= $service_key; ?>"
                                                                                data-currencykey="<?= $key; ?>"
                                                                                value="<?= $source_key . '-' . $service_key; ?>"><?= $source_data['label'] . ' - ' . $service_data['label']; ?></option>
                                                                    <?php
                                                                    endif;

                                                                endforeach;
                                                                ?>

                                                            <?php endforeach; ?>
                                                        </select>
                                                    </td>
                                                    <td>

                                                        <!--</div>-->

                                                        <!--<div class="wallet_settings_table_column options2">-->
                                                        <input type="text" name="address"
                                                               class="regular-text import_address"
                                                               placeholder="Public Address" required>
                                                        <input type="text" name="private_key"
                                                               placeholder="Private Key (optional )"
                                                               class="regular-text import_address currency_specific<?php echo ($source_key = $this->get_service_source('import_address')) ? $this->get_currency_send_field_classes($source_key, $key, 'import_address', 'private_key') : ''; ?>">
                                                        <input type="text" name="wif" placeholder="Wif (optional)"
                                                               class="regular-text import_address currency_specific<?php echo ($source_key = $this->get_service_source('import_address')) ? $this->get_currency_send_field_classes($source_key, $key, 'import_address', 'wif') : ''; ?>">
                                                        <!--<span class="import_address">Optional Fields are required for automatic payments
                                                            only
                                                        </span>-->
                                                        <span class="generate_address generate_account import_address">
                                            <input type="checkbox" name="save_keys" value="1">Save Keys</span>
                                                        <!--</div>-->
                                                    </td>
                                                    <td>
                                                        <!--<div class="wallet_settings_table_column actions">-->
                                                        <input type="submit" name="Submit"
                                                               data-currencykey="<?= $key; ?>"
                                                               class="affwp_crypto_ui_button currency_submit generate_account generate_address import_address tokens metamask">
                                                        <!--</div>-->
                                                    </td>
                                                </tbody>
                                            </table>
                                        </form>
                                    </td>

                                    <!--<div class="wallet_settings_table_row2">
                                    <div class="wallet_settings_table_column">
                                        <input type="text" name="<?/*= $key; */
                                    ?>_tokens" class="regular-text tokens">
                                    </div>
                                    <div class="wallet_settings_table_column">
                                        <input type="checkbox" class="metamask" name="<?/*= $key; */
                                    ?>_metamask"
                                               value="1"><label for="<?/*= $key; */
                                    ?>_metamask" class="metamask">Enable
                                            Metamask</label>
                                    </div>
                                </div>-->

                                </tr>


                                <!--</div>-->

                                <!--<div class="wallet_settings_table_row notifications <?/*= $key; */ ?>"></div>-->

                            <?php
                            endif;

                        endforeach;


                        /*if ( $this->get_active_currencies() ) :
                            echo '</br><pre>';
                            print_r($this->get_active_currencies());
                            echo '</pre>';
                        endif;*/

                        //else:
                        ?>
                        <!--<tr>
                            <td colspan="4">
                                <div>Please configure an adapter with available payment methods to load additional currencies
                                </div>
                            </td>
                        </tr>-->
                        <?php
                        //endif;
                        ?>
                        </tbody>
                    </table>
                </div>

            <?php
            else:
                //if ( !empty($currencies) && !empty($wallet_send_services) ) :
                ?>
                <div>No currencies currently available.</div>
            <?php
            endif;
            ?>

        </div>

        <?php
        $active_with_manual = $this->get_active_currencies(true);
        /* echo '<pre>';
         print_r($active_with_manual);
         echo '</pre>';*/

        foreach ($active_with_manual as $c_key => $c_data) :

            $c_config = $this->get_currency_config($c_key);
            if ( isset($c_config['allow_tokens']) && !$c_config['allow_tokens'] ) :

                unset($active_with_manual[$c_key]);

            endif;

            //echo '<pre>'; print_r(get_currency_active_methods($c_key, $include_manual = true)); echo '</pre>';

        endforeach;

        //if ( !empty($active_with_manual) ) :
        ?>
        <div class="affwp_crypto_ui_section">
            <h3>Add Wallet Tokens</h3>

            <?php if ( !empty($active_with_manual) ) : ?>
                <div class="affwp_crypto_table_container">
                    <table class="affwp_crypto_table settings_add_tokens">
                        <thead>
                        <tr>
                            <th>Currency</th>
                            <th>Values</th>
                            <th>Actions</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php
                        foreach ($active_with_manual as $key => $data):

                            $c_config = $this->get_currency_config($key);

                            //if ( $c_config['allow_tokens'] ) :
                            ?>

                            <tr>
                                <td colspan="3">
                                    <form name="currency_tokens_<?= $key; ?>" method="post"
                                          id="currency_tokens_<?= $key; ?>">
                                        <input type="hidden" name="currency" value="<?= $key; ?>">
                                        <table class="affwp_crypto_table blind_columns">
                                            <tbody>
                                            <tr>
                                                <!--<div class="wallet_settings_table_row" id="currency_row_<?/*= $key; */ ?>">-->
                                                <td>
                                                    <!--<div class="wallet_settings_table_column row_label">-->
                                                    <?php if ( $logo_src = affwp_crypto_get_currency_meta($key, 'logo') ) : ?>
                                                        <img class="affwp_crypto_currency_icon med"
                                                             title="<?php echo (isset($c_config['name'])) ? $c_config['name'] : ''; ?>"
                                                             src="<?php echo $logo_src; ?>">
                                                    <?php endif; ?>
                                                    <?php //echo $c_config['name'];
                                                    ?>
                                                    <!--</div>-->
                                                </td>
                                                <td>
                                                    <!--<div class="wallet_settings_table_column">-->
                                                    <input type="text" name="ticker" class=""
                                                           placeholder="Token Ticker"
                                                           required>
                                                    <input type="text" name="decimals" class=""
                                                           placeholder="Decimals"
                                                           required>
                                                    <!--</div>-->
                                                    <!--</td>
                                                    <td>-->
                                                    <!--<div class="wallet_settings_table_column">-->
                                                    <input type="text" name="contract_address"
                                                           class="regular-text"
                                                           placeholder="Contract Address" required>
                                                    <!--</div>-->
                                                </td>
                                                <td>
                                                    <!--<div class="wallet_settings_table_column actions">-->
                                                    <input type="submit" name="Submit"
                                                           class="affwp_crypto_ui_button token_submit"
                                                           data-currencykey="<?= $key; ?>"
                                                           class="token_submit">
                                                    <!--</div>-->
                                                </td>
                                            </tr>
                                            </tbody>
                                        </table>

                                    </form>
                                    <!--</div>-->
                                </td>
                            </tr>
                        <?php
                            //endif;

                        endforeach;
                        ?>
                        </tbody>
                    </table>
                </div>
            <?php
            else:
                //if ( !empty($currencies) && !empty($wallet_send_services) ) :
                ?>
                <div>No active currencies available that allow tokens.</div>
            <?php
            endif;
            ?>

        </div>

        <?php
        //endif;
        ?>

        <!--</div>-->

        <?php
        $response['type'] = 'success';
        $response['html'] = ob_get_contents();
        ob_end_clean();

        return $response;

    }

    // Generate an activated currency row for the settings UI
    public function get_activated_currency_row($currency_key) {

        //$active_currencies = $this->get_active_currencies();
        //$currency = $active_currencies[$currency_key];
        $currency_config = $this->get_currency_config($currency_key);
        //$currency = $currency_config['currency'];
        $c_settings = $this->get_currency_settings($currency_key);

        if ( !empty($currency_config) ) :

            $methods = $this->get_currency_methods($currency_config['currency']);

            ob_start();
            //print_r($currency);
            ?>
            <!--<div>-->
            <tr>
                <td>
                    <?php if ( $logo_src = affwp_crypto_get_currency_meta($currency_key, 'logo') ) : ?>
                        <img class="affwp_crypto_currency_icon med" title="<?php echo $currency_config['ticker']; ?>"
                             src="<?php echo $logo_src; ?>">
                    <?php
                    else:
                        echo $currency_config['ticker'];
                    endif;
                    ?>
                    <!--:-->
                    <?php
                    //echo $currency['address'];
                    //echo '<pre>'; print_r($methods); echo '</pre>';
                    ?>
                </td>
                <td>

                    <div class="affwp_crypto_table_container">
                        <table class="affwp_crypto_table sub_table settings_currency_adapters">
                            <thead>
                            <tr>
                                <th>Adaptor</th>
                                <th>Address</th>
                                <th>Balance</th>
                                <th>Actions</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php
                            foreach ($methods

                            //$this->is_currency_source_deactivated($currency_key, $method_key)
                            //get_currency_active_methods($currency_key, $include_manual = true)

                            as $method_key => $method_data) :
                            //if ($this->is_currency_active($currency_config['currency']) || $method_data['type'] == 'manual') :
                            //if ($c_settings['address'] || $method_data['type'] == 'manual') :
                            if (
                            (array_key_exists($method_key, $this->get_currency_active_methods($currency_key)) || $this->is_currency_source_deactivated($currency_key, $method_key))
                            || $method_data['type'] == 'manual') :
                            ?>
                            <tr>
                                <!--<div>-->
                                <td>
                                    <?php echo $method_data['label']; ?>
                                </td>
                                <td>
                                    <?php if ( $method_data['type'] == 'api' ) : ?>
                                        <?php if ( $c_settings['address'] ) echo $c_settings['address']; ?>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php
                                    if ( $method_data['type'] != 'manual' ) :
                                        $balance = affiliate_wp_crypto()->base->payments->get_address_balance(array('currency' => $currency_key), true);
                                        $balance = ($balance > 0) ? $balance : 0;
                                        echo $balance;
                                    endif;
                                    ?>
                                </td>
                                <td>
                                    <?php //foreach ($method_data['send_services'] as $ss_key => $ss_data) :
                                    ?>
                                    <!--<span> --->
                                    <?php //echo $ss_data['label'];
                                    ?>
                                    <!--</span>-->
                                    <?php //if ( $method_data['type'] != 'manual' ) :
                                    ?>
                                    <?php if ( /*$method_data['type'] != 'manual' &&*/ !$this->is_currency_source_deactivated($currency_key, $method_key) ) : ?>
                                        <span class="affwp_crypto_ui_button wallet_action deactivate_currency"
                                              data-currency="<?php echo $currency_key; ?>"
                                              data-methodtype="<?php echo $method_data['type']; ?>"
                                              data-source="<?php echo $method_key; ?>"
                                        >Deactivate</span>
                                    <?php elseif ( /*$method_data['type'] != 'manual' &&*/ $this->is_currency_source_deactivated($currency_key, $method_key) ): ?>
                                        <span class="affwp_crypto_ui_button wallet_action reactivate_currency"
                                              data-currency="<?php echo $currency_key; ?>"
                                              data-methodtype="<?php echo $method_data['type']; ?>"
                                              data-source="<?php echo $method_key; ?>"
                                        >Reactivate</span>
                                    <?php endif; ?>
                                    <?php if ( $this->currency_can_be_deleted($currency_key) && $method_data['type'] != 'manual' ) :
                                        ?>
                                        <span class="affwp_crypto_ui_button wallet_action remove_currency"
                                              data-currency="<?php echo $currency_key; ?>"
                                        <!--data-methodtype="--><?php /*echo $method_data['type']; */ ?>"
                                        <!--data-source="--><?php /*echo $method_key; */ ?>"
                                        >Remove</span>
                                    <?php endif;
                                    ?>
                                    <?php //endif;
                                    ?>
                                    <!--</div>-->
                                </td>
                                <?php
                                endif;
                                endforeach;
                                ?>
                            <tr>
                            </tbody>
                        </table>
                    </div>

                </td>
                <!--<td>-->

                <?php //if ( $this->currency_can_be_deleted($currency_key) ) :
                ?>
                <!--<span class="affwp_crypto_ui_button wallet_action remove_currency"
                              data-currency="<?php /*echo $currency_key; */ ?>"
                        >Remove</span>-->
                <?php //endif;
                ?>

                <?php /*echo $currency_key; */ ?>
                <?php /*echo $currency_config['source']; */ ?>
                <!--</td>-->
            </tr>
            <!--</div>-->

            <?php
            $html = ob_get_contents();
            ob_end_clean();
            return $html;

        endif;

    }

    // Process currencies form
    public function ajax_save_currency($response) {

        parse_str($_POST['form_data'], $form_data);
        $source_method = explode("-", $form_data['currency_source_method']);
        $form_data['source'] = $source_method[0];
        $form_data['method'] = $source_method[1];

        $messages = array();

        // Run activation logic here and then activate is successful
        if ( $form_data['method'] ) :

            if ( ($form_data['method'] == 'generate_address' || $form_data['method'] == 'generate_account' || $form_data['method'] == 'import_address') && $form_data['currency'] ) :

                if ( $form_data['method'] == 'generate_address' ) :

                    $response_data = affiliate_wp_crypto()->base->integrations->generate_address(array('currency' => $form_data['currency'], 'integration' => $form_data['source']));

                elseif ( $form_data['method'] == 'generate_account' ):

                    $response_data = affiliate_wp_crypto()->base->integrations->generate_account(array('currency' => $form_data['currency'], 'integration' => $form_data['source']));

                endif;

                //if ( $response_data['privateKey'] && $response_data['address'] ) :

                // Add another balance check here to confirm it's an address
                if ( $response_data['address'] || $form_data['address'] ) :

                    /*$activate_data = array(
                        'currency' => $form_data['currency'],
                        'source' => $form_data['source'],
                        'method' => $form_data['method'],
                    );*/

                    // Save the form data
                    foreach ($form_data as $key => $value) :

                        if ( $key != 'currency_source_method' && !empty($value) ) :

                            $activate_data[$key] = $value;

                        endif;

                    endforeach;

                    // Save the API response data
                    if ( $response_data['address'] ) :

                        // If the user does not want to save the keys, grab the fields not to save
                        $send_fields = array();
                        if ( $form_data['save_keys'] != 1 ) :

                            $send_fields = $this->get_no_save_fields($form_data['source'], $form_data['method'], $form_data['currency']);
                            //update_option('crypto_generate_debug1', $send_fields);

                        endif;

                        foreach ($response_data as $key => $value) :

                            if ( !in_array($key, $send_fields) ) :
                                $activate_data[$key] = $value;
                            endif;

                        endforeach;

                    endif;

                    // Add the address network
                    $activate_data['network'] = affwp_crypto_get_network();

                    $this->activate_currency($form_data['currency'], $activate_data);

                    $messages['Status'] = array(
                        'type' => 'success',
                        'heading' => 'Activation Successful',
                        'content' => ''
                    );

                    if ( $form_data['method'] == 'generate_address' || $form_data['method'] == 'generate_account' ) :

                        if ( $response_data['address'] ) :

                            $messages['Address'] = array(
                                'type' => 'success',
                                'heading' => 'Your Public Address is: ' . $response_data['address'],
                                'content' => ''
                            );

                        endif;

                        if ( $response_data['publicKey'] ) :

                            $messages['Public Key'] = array(
                                'type' => 'success',
                                'heading' => 'Your Public Key is: ' . $response_data['publicKey'],
                                'content' => ''
                            );

                        endif;

                        if ( $response_data['privateKey'] ) :
                            $messages['Private Key'] = array(
                                'type' => 'success',
                                'heading' => 'Your Private Key is: ' . $response_data['privateKey'],
                                'content' => ''
                            );
                        endif;

                        if ( $response_data['wif'] ) :
                            $messages['Wif'] = array(
                                'type' => 'success',
                                'heading' => 'Your Wif: ' . $response_data['wif'],
                                'content' => ''
                            );
                        endif;

                        if ( $response_data['privateKey'] || $response_data['publicKey'] ) :

                            $messages['Save Keys'] = array(
                                'type' => 'success',
                                'heading' => 'Make sure you make a secure copy of all keys listed above',
                                'content' => ''
                            );

                        endif;

                        if ( $form_data['save_keys'] == 1 ) :
                            $messages['Keys Saved'] = array(
                                'type' => 'success',
                                'heading' => 'Your keys have been saved to allow automatic payments',
                                'content' => ''
                            );
                        endif;

                        $response['notification_type'] = 'prompt';
                        $response['notification_style'] = 'success';
                        $response['prompt_text'] = 'I have made secure copies of my keys';

                    endif;

                    if ( $form_data['method'] == 'generate_account' ) :

                        $messages['Password'] = array(
                            'type' => 'success',
                            'heading' => 'Your Account Password is: ' . $response_data['password'],
                            'content' => ''
                        );
                        $messages['Save Password'] = array(
                            'type' => 'success',
                            'heading' => 'Make sure you make a secure copy of your password',
                            'content' => ''
                        );

                        if ( $form_data['save_keys'] == 1 ) :
                            $messages['Password Saved'] = array(
                                'type' => 'success',
                                'heading' => 'Your Password has been saved to allow automatic payments',
                                'content' => ''
                            );
                        endif;

                        $response['notification_type'] = 'prompt';
                        $response['notification_style'] = 'success';
                        $response['prompt_text'] = 'I have made a secure copy of my Password';

                    endif;

                    if ( $form_data['method'] == 'import_address' ) :

                        /*$messages['Password'] = array(
                            'type' => 'success',
                            'heading' => 'Your Account Password is: ' . $response_data['password'],
                            'content' => 'This password has not been saved. Make sure you make a secure copy'
                        );*/

                        if ( $form_data['save_keys'] == 1 ) :
                            $messages['Keys Saved'] = array(
                                'type' => 'success',
                                'heading' => 'Your keys have been saved to allow automatic payments',
                                'content' => ''
                            );
                        endif;

                        $response['notification_type'] = 'fade';
                        $response['notification_style'] = 'success';

                    endif;

                    //$response['notification_type'] = 'fade';
                    $response['type'] = 'success';
                    $response['notification'] = affwp_crypto_array_to_messages($messages);

                //$response['activated_row'] = $this->get_activated_currency_row($form_data['currency']);

                else:

                    //if ( ($form_data['method'] == 'generate_address' || $form_data['method'] == 'generate_account' || $form_data['method'] == 'import_address') && $form_data['currency'] ) :


                    /*ob_start();

                    echo '<pre>';
                    print_r($_POST);
                    echo '</pre>';

                    echo '<pre>';
                    print_r($form_data);
                    echo '</pre>';

                    $response['type'] = 'error';

                    $response['debug'] = ob_get_contents();

                    ob_end_clean();*/

                    if ( $form_data['method'] == 'generate_address' || $form_data['method'] == 'generate_account' ) :

                        $error_code = $response_data['api_response']['code'];
                        $error_message = $response_data['api_response']['message'];

                        $messages['Error'] = array(
                            'type' => 'error',
                            'heading' => 'Error generating address',
                            'content' => 'There was an error generating your address. Error Code: ' . $error_code . ' -> Message: ' . $error_message

                        );

                    elseif ( $form_data['method'] == 'import_address' ):

                        $messages['Error'] = array(
                            'type' => 'error',
                            'heading' => 'Error generating address',
                            'content' => 'There was an error importing your address. Please try again later.',
                        );

                    endif;

                    $response['type'] = 'error';
                    $response['notification'] = affwp_crypto_array_to_messages($messages);
                    $response['notification_type'] = 'standard';
                    $response['notification_style'] = 'error';

                endif;

            endif;

        endif;

        return $response;

    }

    // Process currencies form
    public function ajax_save_currency_token($response) {

        parse_str($_POST['form_data'], $form_data);

        if ( !empty($form_data['currency']) && !empty($form_data['ticker']) && !empty($form_data['decimals']) && !empty($form_data['contract_address']) ) :

            //$int_response = affiliate_wp_crypto()->base->integrations->check_connection(array('api_key' => $form_data['api_key'], 'integration' => $form_data['source']));
            //$int_response = false;
            //if ( $int_response === true ) :

            // Add another balance or contract check here to confirm it's an address ?

            $token_key = $form_data['currency'] . ':' . strtolower($form_data['ticker']);
            $active_currencies = $this->get_active_currencies();

            $activate_data = array(
                'token' => strtolower($form_data['ticker']),
                'custom' => true,
                'type' => 'token',
                'token_address' => $form_data['contract_address'],
                'token_decimals' => $form_data['decimals'],
                'ticker' => strtoupper($form_data['ticker']),
                'currency' => $form_data['currency'],

            );

            // Import fields from the parent. Now added directly to get methods
            /*$parent_currency = $active_currencies[$form_data['currency']];
            foreach ($parent_currency as $c_key => $c_value) :

                $activate_data[$c_key] = $c_value;

            endforeach;*/


            $this->activate_custom_currency($token_key, $activate_data);

            $response['type'] = 'success';

            $messages['Status'] = array(
                'heading' => 'Token Activation Successful',
                'type' => 'success',
                'content' => 'Your Token is active'
            );

            $response['notification'] = affwp_crypto_array_to_messages($messages);
            $response['notification_type'] = 'fade';
            $response['notification_style'] = 'success';

        //$response['activated_row'] = $this->get_activated_currency_row($token_key);

        //else:

        /*ob_start();

        echo '<pre>';
        print_r($_POST);
        echo '</pre>';

        echo '<pre>';
        print_r($form_data);
        echo '</pre>';

        $response['debug'] = ob_get_contents();
        ob_end_clean();

        $messages['Error'] = array(
            'type' => 'error',
            'heading' => 'Error',
            'content' => $int_response['error_message']
        );
        $formated_messages = $this->array_to_messages($messages);

        $response['errors'] = $formated_messages;
        $response['type'] = 'error';*/


        //endif;

        else:

            $messages['Error'] = array(
                'type' => 'error',
                'heading' => 'Error adding token',
                'content' => 'There was an error importing your address. Please check your field values.',
            );


            $response['type'] = 'error';
            $response['notification'] = affwp_crypto_array_to_messages($messages);
            $response['notification_type'] = 'standard';
            $response['notification_style'] = 'error';

        endif;

        return $response;

    }

    // Remove Source
    public function ajax_remove_source($response) {

        //parse_str($_POST['form_data'], $form_data);

        if ( !empty($_POST['source']) ) :

            $this->remove_source($_POST['source']);

            $response['type'] = 'success';

            $messages['Status'] = array(
                'heading' => 'Adaptor Removed',
                'type' => 'success',
                'content' => ''
            );

            $response['notification'] = affwp_crypto_array_to_messages($messages);
            $response['notification_type'] = 'fade';
            $response['notification_style'] = 'success';

        endif;

        return $response;

    }

    // Deactivate currency
    public function ajax_deactivate_currency($response) {

        //update_option( 'affwp_crypto_cc', $_POST);

        //parse_str($_POST['data'], $form_data);

        if ( !empty($_POST['currency']) ) :

            $this->deactivate_currency_source($_POST['currency'], $_POST['source']);

            $response['type'] = 'success';

            $messages['Status'] = array(
                'heading' => 'Deactivation Successful',
                'type' => 'success',
                'content' => ''
            );

            $response['notification'] = affwp_crypto_array_to_messages($messages);
            $response['notification_type'] = 'fade';
            $response['notification_style'] = 'success';

            //$formated_messages = $this->array_to_messages($messages);
            //$response['activated_row'] = $this->get_activated_currency_row($token_key, $formated_messages);

        endif;

        //$response['type'] = 'error';

        return $response;

    }

    // Reactivate currency
    public function ajax_reactivate_currency($response) {

        //update_option( 'affwp_crypto_cc', $_POST);

        //parse_str($_POST['data'], $form_data);

        if ( !empty($_POST['currency']) ) :

            $this->reactivate_currency_source($_POST['currency'], $_POST['source']);

            $response['type'] = 'success';

            $messages['Status'] = array(
                'heading' => 'Activation Successful',
                'type' => 'success',
                'content' => ''
            );
            $response['notification'] = affwp_crypto_array_to_messages($messages);
            $response['notification_type'] = 'fade';
            $response['notification_style'] = 'success';

            //$formated_messages = $this->array_to_messages($messages);
            //$response['activated_row'] = $this->get_activated_currency_row($token_key, $formated_messages);

        endif;

        //$response['type'] = 'error';

        return $response;

    }

    // Remove currency
    public function ajax_remove_currency($response) {

        if ( !empty($_POST['currency']) ) :

            $this->remove_currency($_POST['currency']);

            $response['type'] = 'success';

            $messages['Status'] = array(
                'heading' => 'Currency Removed',
                'type' => 'success',
                'content' => ''
            );

            $response['notification'] = affwp_crypto_array_to_messages($messages);
            $response['notification_type'] = 'fade';
            $response['notification_style'] = 'success';

        endif;

        //$response['type'] = 'error';

        return $response;

    }


}