<?php
class AFFWP_CRYPTO_Settings {

    protected $plugin_config;
    public $plugin_settings;

    public function __construct() {

        $this->plugin_config = affiliate_wp_crypto()->plugin_config;

        $this->plugin_settings = $this->get_all_settings();

        // Plugin upgrade tasks
        $this->plugin_upgrade_tasks();

        // New settings tab & settings
        add_filter('affwp_settings_tabs', array($this, 'settings_tab'));
        add_filter('affwp_settings', array($this, 'settings'), 10, 1);

        // Custom settings UI
        add_action('admin_init', array($this, 'save_custom_settings'), 1);
        add_action('admin_init', array($this, 'output_custom_settings'));

        if ( $this->check_if_settings_page() ) {
            add_action('admin_init', array($this, 'deactivate_license'), 1);
        }

    }

    // Plugin upgrade tasks
    public function plugin_upgrade_tasks() {

        $previous_version = get_site_option($this->plugin_config['plugin_prefix'] . '_version');
        $new_version = $this->plugin_config['plugin_version'];

        if ( !empty($previous_version) ) {

            // update lps
            /*if ( $previous_version < '0.9.5' )  :
                update_site_option($this->plugin_config['plugin_prefix'] . '_lps', 1);
            endif;*/

            // update db version
            if ( $previous_version != $new_version ) :
                update_site_option($this->plugin_config['plugin_prefix'] . '_version', $this->plugin_config['plugin_version']);
            endif;

        } else {

            update_site_option($this->plugin_config['plugin_prefix'] . '_version', $this->plugin_config['plugin_version']);

        }

    }

    // Check if on the plugins settings page
    public function check_if_settings_page() {
        if ( isset($_GET['tab']) && $_GET['tab'] == $this->plugin_config['plugin_prefix'] ) return TRUE;
    }

    // Create the settings tab
    public function settings_tab($tabs) {
        $tabs[$this->plugin_config['plugin_prefix']] = __($this->plugin_config['plugin_item_sname'], '');
        return $tabs;
    }

    // Get all settings
    public function get_all_settings() {

        $options = affiliate_wp()->settings->get_all();

        $thesettings = array();

        // Add the standard
        $settings = $this->settings(array());
        foreach ($settings[$this->plugin_config['plugin_prefix']] as $key => $value) {

            if ( class_exists('Affiliate_WP') ) {
                if ( !empty($options[$key]) ) {
                    $thesettings[$key] = $options[$key];
                }
            }
        }

        // Add the custom settings
        $custom_settings_list = $this->custom_settings_list();

        if ( class_exists('Affiliate_WP') ) {

            $plugin_prefix = $this->plugin_config['plugin_prefix'];

            foreach ($custom_settings_list as $key => $data) {
                if ( !empty($options[$plugin_prefix . '_' . $key]) ) :
                    $thesettings[$plugin_prefix . '_' . $key] = $options[$plugin_prefix . '_' . $key];
                endif;
            }

        }

        return $thesettings;

    }

    // Get a plugin setting
    public function plugin_setting($key) {

        if ( !empty($this->plugin_settings[$this->plugin_config['plugin_prefix'] . '_' . $key]) ) :
            return $this->plugin_settings[$this->plugin_config['plugin_prefix'] . '_' . $key];
        endif;

    }

    // Set Default Settings

    // Set the default settings
    public function set_default_settings() {}

    // Generate the form settings
    public function settings($settings) {

        if ( is_admin() && $this->check_if_settings_page() ) {
            $license_msg = $this->license_status_msg();
            $license_msg = (!empty($license_msg)) ? $license_msg : '';
        } else {
            $license_msg = '';
        }

        $settings2 = array(
            $this->plugin_config['plugin_prefix'] => apply_filters('affwp_settings_crypto',
                array(
                    $this->plugin_config['plugin_prefix'] . '_section_licensing' => array(
                        'name' => '<strong>' . __('License Settings', 'affiliatewp-crypto') . '</strong>',
                        'desc' => '',
                        'type' => 'header'
                    ),

                    $this->plugin_config['plugin_prefix'] . '_license_key' => array(
                        'name' => __('License Key', 'affiliatewp-crypto'),
                        'desc' => $license_msg,
                        'type' => 'text',
                        'disabled' => $this->is_license_valid()
                    ),
                   /* $this->plugin_config['plugin_prefix'] . '_section_main_settings' => array(
                        'name' => '<strong>' . __('Main Settings', 'affiliatewp-crypto') . '</strong>',
                        'desc' => '',
                        'type' => 'header'
                    ),*/
                    /*$this->plugin_config['plugin_prefix'].'_max_address_verifications' => array(
						'name' => __( 'Max Verifications', '' ),
						'desc' => 'The maximum number of address verifications per account',
						'type' => 'text',
						'disabled' => ''
					),

                    $this->plugin_config['plugin_prefix'].'_min_payout_amount' => array(
						'name' => __( 'Min Payout', '' ),
						'desc' => 'The minimum payout amount for monthly automated payouts',
						'type' => 'text',
						'disabled' => ''
					),*/

                )
            )
        );

        $settings2 = $this->check_integration_settings($settings2);


        // Merge settings
        $settings = array_merge($settings, $settings2);

        return $settings;
    }


    // Remove integration settings when not required
    public function check_integration_settings($settings2) {

        return $settings2;
    }

    ///////////////////////////////// Custom Settings

    // Register the Custom settings as a field
    public function output_custom_settings() {

        add_settings_field(
            $this->plugin_config['plugin_prefix'] . 'AFFWP_CRYPTO_settings_section',
            '',
            array($this, 'output_custom_settings_form'),
            'affwp_settings_' . $this->plugin_config['plugin_prefix'],
            'affwp_settings_' . $this->plugin_config['plugin_prefix']
        );

    }

    // Generate the Custom settings tables
    public function output_custom_settings_form() {

        echo $this->get_custom_settings_table(array('id' => '', 'section_title' => __('Integrations & Wallet Configuration', 'affiliatewp-crypto')));

    }

    // Save the Custom fields
    public function save_custom_settings() {

        if ( isset($_POST[$this->plugin_config['plugin_prefix'] . '_process_custom_settings']) && !empty($_POST[$this->plugin_config['plugin_prefix'] . '_process_custom_settings']) ) {

            $options = array();

            $form_fields = $this->custom_settings_list();

            foreach ($form_fields as $name => $data) {

                if ( isset($_POST[$this->plugin_config['plugin_prefix'] . '_' . $name]) ):

                    $field = $_POST[$this->plugin_config['plugin_prefix'] . '_' . $name];

                    if ( $data['saniitize'] ) {
                        $sanitize_function = 'sanitize_' . $data['type'];
                        $field = $sanitize_function($field);
                    }

                    $options[$this->plugin_config['plugin_prefix'] . '_' . $name] = $field;

                endif;

            }

            affiliate_wp()->settings->set($options, TRUE);

        }

    }

    /*public function get_custom_setting_array($setting_key, $keys) {

        $array = $this->plugin_setting($setting_key);

        //print_r($array);

        $key_count = count($keys);

        if ( $key_count == 2 ) {
            $value = $array[$keys[1]][$keys[2]];
        }

        if ( $key_count == 3 ) {
            $value = $array[$keys[1]][$keys[2]][$keys[3]];
        }

        return $value;

    }*/

    // The raw fancy settings array
    public function custom_settings_list($type = '') {

        $custom_settings_list = array(

            /*'crypto_config' => array(
                'type' => 'text_field',
                'label' => __('Integrations & Wallet Config', 'affiliatewp-crypto'),
                'saniitize' => (bool)FALSE,
            ),*/

        );

        return $custom_settings_list;

    }

    // Generate the settings table
    public function get_custom_settings_table($args = array()) {

        ob_start();
        ?>

        <!--<div>
            <h2>Wallet Settings</h2>
            <h3>Payment Methods</h3>
            <div id="affwp_crypto_settings_sources_form_notifications"></div>
            <div id="affwp_crypto_settings_sources" class="wallet_section">loading.....</div>
            <h3>Currencies</h3>
            <div id="affwp_crypto_settings_currencies" class="wallet_section">loading.....</div>
        </div>-->

        <?php
        $html = ob_get_contents();
        ob_end_clean();

        return $html;
    }


    /////////// Licensing Methods ///////////////

    // Deactive license
    public function deactivate_license() {

        if (
            (isset($_GET[$this->plugin_config['plugin_prefix'] . '_license_change'])) &&
            ($_GET[$this->plugin_config['plugin_prefix'] . '_license_change'] == 'deactivate')
        ) {

            $license = new Click_Studio_Licenses_V1_5($this->plugin_config, $this->plugin_settings);
            if ( $license->deactivate_license() ) {

                // Redirect to settings page
                $location = $_SERVER['HTTP_REFERER'];
                wp_safe_redirect($location);

            }

        }

    }

    // Get the license message actions and messages. Also activate license keys.
    public function license_status_msg() {

        $license = new Click_Studio_Licenses_V1_5($this->plugin_config, $this->plugin_settings);

        if ( isset($_GET['cs_remove_license_data']) && $_GET['cs_remove_license_data'] == true ) {

            $license->remove_license_data();
            $license->remove_affwp_settings();

        } else {

            $license->activate_license();

            $license_message = $license->license_status_msg();
            return $license_message;

        }

    }

    // Check license status
    public function is_license_valid() {

        if ( $this->check_if_settings_page() ) {

            $license = new Click_Studio_Licenses_V1_5($this->plugin_config, $this->plugin_settings);
            $status = $license->get_license_option('license_status');

            if ( !empty($status) && $status == 'valid' ) return true;

        }

        return false;

    }

} // End of class
?>