<?php
class AFFWP_CRYPTO_Settings {

	protected $plugin_config;
	public $plugin_settings;

	public function __construct() {
		
		//$this->plugin_config = unserialize(AFFWP_CRYPTO_PLUGIN_CONFIG);
		//$this->plugin_settings = unserialize(AFFWP_CRYPTO_PLUGIN_SETTINGS);
		$this->plugin_config = affiliate_wp_crypto()->plugin_config;
		
		$this->plugin_settings = $this->get_all_settings();

		// Plugin upgrade tasks
		$this->plugin_upgrade_tasks();
		
		// New settings tab & settings
		add_filter( 'affwp_settings_tabs', array( $this, 'settings_tab' ), 11 );
		add_filter( 'affwp_settings', array( $this, 'settings' ), 10, 1 );
		
		if($this->check_if_settings_page()) {
			add_action('admin_init', array( $this, 'deactivate_license' ), 1);
		}

	}
	
	// Plugin upgrade tasks
	public function plugin_upgrade_tasks() {
		
	  $previous_version = get_site_option( $this->plugin_config['plugin_prefix'].'_version' ); 
	  $new_version = $this->plugin_config['plugin_version'];
	  
	  if( !empty($previous_version) ) {
		  
		  // update db version
		  if( $previous_version != $new_version ) :
	  		  update_site_option( $this->plugin_config['plugin_prefix'].'_version', $this->plugin_config['plugin_version'] );
	  	  endif;
	  
	  }else{
		  
		  update_site_option( $this->plugin_config['plugin_prefix'].'_version', $this->plugin_config['plugin_version'] );
		  
	  }
 
	}
	
	// Check if on the plugins settings page
	public function check_if_settings_page() {
		if( isset($_GET['tab']) && $_GET['tab'] == $this->plugin_config['plugin_prefix'] ) return TRUE;
	}
	
	// Create the settings tab
	public function settings_tab( $tabs ) {
		$tabs[$this->plugin_config['plugin_prefix']] = __( $this->plugin_config['plugin_item_sname'], 'affiliatewp-crypto' );
		return $tabs;
	}
	
	// Get all settings
	public function get_all_settings() {
		
		$options = affiliate_wp()->settings->get_all();
	
		// Add the standard
		$settings = $this->settings(array());
		foreach($settings[$this->plugin_config['plugin_prefix']] as $key => $value) {
			
			if (class_exists( 'Affiliate_WP' ) ) {
				if( !empty($options[$key]) ) {
					$thesettings[$key] = $options[$key];
				}
			}
		}

		return $thesettings;
	
	}
	
	// Get a plugin setting
	public function plugin_setting( $key ) {

		return $this->plugin_settings[$this->plugin_config['plugin_prefix'].'_'.$key ];
		
	}
	
	// Set Default Settings
	
	// Set the default settings
	public function set_default_settings() {
		
		/*$prefix = $this->plugin_config['plugin_prefix'].'_';
		
		// Set the default mla mode to matrix
		$mla_mode = $this->plugin_setting( 'mla_mode' );
		if( empty($mla_mode) ) affiliate_wp()->settings->set( array( $prefix.'mla_mode' => 'matrix'), TRUE );*/
	}
	
	// Generate the form settings
	public function settings( $settings ) {
		
		if( is_admin() && $this->check_if_settings_page() ) {
			$license_msg = $this->license_status_msg();
			$license_msg = ( !empty($license_msg) ) ? $license_msg : '' ;
		} else {
			$license_msg = '';
		}

		$settings2 = array(
			$this->plugin_config['plugin_prefix'] => apply_filters( 'affwp_settings_gs',
				array(
					$this->plugin_config['plugin_prefix'].'_section_licensing' => array(
						'name' => '<strong>' . __( 'License Settings', 'affiliatewp-crypto' ) . '</strong>',
						'desc' => '',
						'type' => 'header'
					),
					
					$this->plugin_config['plugin_prefix'].'_license_key' => array(
						'name' => __( 'License Key', 'affiliatewp-crypto' ),
						'desc' => $license_msg,
						'type' => 'text',
						'disabled' => $this->is_license_valid()
					),
					
					/*$this->plugin_config['plugin_prefix'].'_section_general_settings' => array(
						'name' => '<strong>' . __( 'General Settings', '' ) . '</strong>',
						'desc' => '',
						'type' => 'header'
					),
					$this->plugin_config['plugin_prefix'].'_enable_mla' => array(
						'name' => __( '', '' ),
						'desc' => __( '<strong>Enable MLA</strong><p>Enable or disable all MLA features</p>', '' ),
						'type' => 'checkbox'
					),
					$this->plugin_config['plugin_prefix'].'_mla_mode' => array(
						'name' => __( '', '' ),
						'desc' => __( '<b>Multi Level Mode</b><p>If you are unsure what this is, do not switch from \'Matrix\'.</p>', '' ),
						'type' => 'select',
						'options' => array(
							'matrix' => __( 'Matrix', '' ),
							'binary' => __( 'Binary', '' ),	
						)
					),
					$this->plugin_config['plugin_prefix'].'_section_dashboard_settings' => array(
						'name' => '<strong>' . __( 'Affiliate Dashboard', '' ) . '</strong>',
						'desc' => '',
						'type' => 'header'
					),
					$this->plugin_config['plugin_prefix'].'_dashboard_tab_enable' => array(
						'name' => __( '', '' ),
						'desc' => __( '<b>Add dashboard tab</b>', '' ),
						'type' => 'checkbox'
					),
					$this->plugin_config['plugin_prefix'].'_dashboard_features' => array(
						'name' => __( '', '' ),
						'desc' => __( '<b>Dashboard features - Matrix Mode</b>', '' ),
						'type' => 'multicheck',
						'options' => array(
							'rates' => __( 'Affiliate Commission Rates', '' ),
							'earnings' => __( 'Affiliate Earnings', '' ),
							'network_statistics' => __( 'Network Statistics', '' ),	
							'network_chart' => __( 'Network chart', '' ),
						),
					),
					$this->plugin_config['plugin_prefix'].'_dashboard_features_binary' => array(
						'name' => __( '', '' ),
						'desc' => __( '<b>Dashboard features - Binary Mode</b>', '' ),
						'type' => 'multicheck',
						'options' => array(
							//'rates' => __( 'Affiliate Commission Rates', '' ),
							//'earnings' => __( 'Affiliate Earnings', '' ),
							'affiliate_rank' => __( 'Affiliate Rank', '' ),
							'affiliate_details' => __( 'Affiliate Account Details', '' ),
							'affiliate_report' => __( 'Affiliate Reports', '' ),
							//'network_statistics' => __( 'Network Statistics', '' ),	
							'network_chart' => __( 'Network chart', '' ),
							
						),
					),
					$this->plugin_config['plugin_prefix'].'_buddypress_enable' => array(
						'name' => __( '', '' ),
						'desc' => __( '<b>Add dashboard tab to BuddyPress settings</b>', '' ),
						'type' => 'checkbox'
					),
					$this->plugin_config['plugin_prefix'].'_section_matrix_settings' => array(
						'name' => '<strong>' . __( 'Matrix Settings', '' ) . '</strong>',
						'desc' => '',
						'type' => 'header'
					),*/

					// Temp for testing

					$this->plugin_config['plugin_prefix'].'_max_address_verifications' => array(
						'name' => __( 'Max Verifications', 'affiliatewp-crypto' ),
						'desc' => 'The maximum number of address verifications per account',
						'type' => 'text',
						'disabled' => ''
					),

                    $this->plugin_config['plugin_prefix'].'_min_payout_amount' => array(
						'name' => __( 'Min Payout', 'affiliatewp-crypto' ),
						'desc' => 'The minimum payout amount for monthly automated payouts',
						'type' => 'text',
						'disabled' => ''
					),
					
				)
			)
		);
		
		$settings2 = $this->check_integration_settings( $settings2 );

		
		// Merge settings
		$settings = array_merge( $settings, $settings2 );	
		
		return $settings;
	}
	
	
	// Remove integration settings when not required
	public function check_integration_settings( $settings2 ) {
		
		// AffiliateWP BuddyPress
		/*if ( !class_exists( 'AffiliateWP_BuddyPress' ) ) :
			unset( $settings2[$this->plugin_config['plugin_prefix']][$this->plugin_config['plugin_prefix'].'_buddypress_enable'] );
		endif;*/
		
		return $settings2;
	}

	/////////// Licensing Methods ///////////////
	
	// Deactive license
	public function deactivate_license() {
		
	  if( 
	  (isset($_GET[$this->plugin_config['plugin_prefix'].'_license_change'])) &&
	  ($_GET[$this->plugin_config['plugin_prefix'].'_license_change'] == 'deactivate') 
	  ){
		  
		  $license = new Click_Studio_Licenses_V1_5($this->plugin_config, $this->plugin_settings);
		  if($license->deactivate_license()) {
			  
			  // Redirect to settings page
			  $location = $_SERVER['HTTP_REFERER'];
			  wp_safe_redirect($location);
		  
		  }
	  
	  }
		
	}
	
	// Get the license message actions and messages. Also activate license keys.
	public function license_status_msg() {

		$license = new Click_Studio_Licenses_V1_5($this->plugin_config, $this->plugin_settings);

		if( isset($_GET['cs_remove_license_data']) && $_GET['cs_remove_license_data'] == true ) {
		
			$license->remove_license_data();
			$license->remove_affwp_settings();
		
		}else{
		
		$license->activate_license();
		
		$license_message = $license->license_status_msg();
		return $license_message;
		
		}
	
	}
	
	// Check license status
	public function is_license_valid() {
		
		if( $this->check_if_settings_page() ) {
		
			$license = new Click_Studio_Licenses_V1_5($this->plugin_config, $this->plugin_settings);
			$status = $license->get_license_option( 'license_status' );
			
			if( !empty($status) && $status == 'valid' ) return true;
		
		}
		
		return false;
		
	}
	
} // End of class
?>