<?php

class AFFWP_CRYPTO_Payments {

  //protected $plugin_settings;
  protected $plugin_config;
  public $exchange_rates;

  public function __construct() {

    $affiliate_wp_crypto = affiliate_wp_crypto();
    $this->plugin_config = $affiliate_wp_crypto->plugin_config;
    //$this->plugin_settings = $affiliate_wp_crypto->plugin_settings;

    $this->exchange_rates = array();
    $this->address_balances = array();

    add_filter('affwp_crypto_ajax_payout_single_affiliate', array($this, 'ajax_load_payouts_ui'));
    add_filter('affwp_crypto_ajax_payout_bulk_affiliates', array($this, 'ajax_load_payouts_ui'));
    add_filter('affwp_crypto_ajax_payout_single_referral', array($this, 'ajax_load_payouts_ui'));
    add_filter('affwp_crypto_ajax_payout_bulk_referrals', array($this, 'ajax_load_payouts_ui'));

    //add_filter('affwp_crypto_ajax_approve_payments', array($this, 'ajax_approve_payments'));

    add_filter('affwp_crypto_ajax_pre_checks', array($this, 'ajax_pre_checks'));

    add_filter('affwp_crypto_ajax_pay_payments', array($this, 'ajax_pay_payments'));

    add_filter('affwp_crypto_ajax_complete_web3_payments', array($this, 'ajax_complete_payments'));


    // Cron - Process approved payments (send to blockchain)
    //add_action('affwp_crypto_seconds_15', array($this, 'process_approved_payments'));

    // Check new transactions only
    add_action('affwp_crypto_seconds_15', array($this, 'check_payment_statuses'));

    // Check transactions that are delayed from getting confirmed, maybe reverse the payment after 3 days
    add_action('affwp_crypto_seconds_15', array($this, 'check_payment_statuses_delayed'));


    add_shortcode('crypto_payments_test', array($this, 'crypto_payments_test'));

  }

  public function crypto_payments_test() {

    //$args = array('payment_id' => 552);
    //$args = array('payout_id' => 122);
    //echo '<pre>';
    //print_r($this->get_formatted_payment($args));
    //echo '</pre>';

    $c_config = affiliate_wp_crypto()->base->wallet->get_currency_config('eth:candy');
    echo '<pre>';
    print_r($c_config);
    echo '</pre>';
    //return $this->get_payment_age(2);

  }

  public function get_manual_methods() {

    $manual_methods = array(
      'metamask' => array(
        'label' => 'MetaMask',
        'currencies' => array('eth'),
        'send_services' => array(
          'browser_extension' => array('label' => 'Browser Extension')
        ),
      ),
      /*'wallet_connect' => array(
          'label' => 'WalletConnect',
          'currencies' => array('eth'),
          'send_services' => array(
              'browser_extension' => array('label' => 'WalletConnect Wallets')
          ),
      )*/
    );

    return $manual_methods;

  }

  // Get currency manual methods
  public function get_currency_manual_methods($currency_key) {

    $manual_methods = $this->get_manual_methods();

    $methods = array();
    foreach ($manual_methods as $m_key => $m_data) :

      if ( in_array($currency_key, $m_data['currencies']) ):

        $methods[$currency_key][$m_key] = $manual_methods[$m_key];

      endif;

    endforeach;

    return $methods;
  }

  // Check if a currency has manual methods
  public function has_manual_methods($currency_key, $methods = array()) {

    $manual_methods = $this->get_manual_methods();

    foreach ($manual_methods as $m_key => $m_data) :

      if ( !empty($methods) ) :

        if ( in_array($currency_key, $m_data['currencies']) && in_array($m_key, $methods) ):

          return true;

        endif;

      else:

        if ( in_array($currency_key, $m_data['currencies']) ):

          return true;

        endif;

      endif;

    endforeach;

    return false;

    /*$c_man_methods = $this->get_currency_config($currency_key, 'manual_methods');

    if ( empty($c_man_methods) ) :

        return false;

    else:

        if ( empty($methods) ) :

            return true;

        else:

            foreach ($c_man_methods as $method_key => $method_name) :

                if ( in_array($method_key, $methods) ):

                    return true;

                endif;

            endforeach;

        endif;

    endif;*/

  }

  // Check if a currency is active
  public function is_currency_active($currency_key, $include_manual_methods = false) {

    $active_currencies = $this->get_active_currencies($include_manual_methods);

    if ( array_key_exists($currency_key, $active_currencies) ) return true;

    //if ( $include_manual_methods && $this->has_manual_methods($currency_key) ) return true;

    return false;

  }

  public function convert_currency($base_currency, $from_amount, $payment_currency, $rate = '') {

    if ( empty($rate) ) $rate = $this->get_exchange_rate($base_currency, $payment_currency);

    //update_option('affwp_crypto_convert_debug_0', $rate);

    if ( !empty($rate) ) :

      //$currencies = affiliate_wp_crypto()->base->wallet->get_currencies();
      //$decimals = $currencies[strtolower($payment_currency)]['decimals'];
      $c_config = affiliate_wp_crypto()->base->wallet->get_currency_config($payment_currency);
      $decimals = ($c_config['type'] == 'token') ? $c_config['token_decimals'] : $c_config['decimals'];

      $amount = bcmul($from_amount, $rate, $decimals);

      return $amount;

    endif;

    return '';

  }

  // Get an exchange rate (maybe cached to prevent excessive api calls, true by default)
  public function get_exchange_rate($base_currency, $payment_currency, $cached = true) {

    $ticker = affiliate_wp_crypto()->base->wallet->get_currency_config($payment_currency, 'ticker');
    if ( $ticker == $base_currency ) return 1;

    $exchange_rate = '';
    if ( $cached && isset($this->exchange_rates[$base_currency . ':' . $payment_currency]) ) :
      $exchange_rate = $this->exchange_rates[$base_currency . ':' . $payment_currency];
    endif;

    if ( empty($exchange_rate) ) :

      $exchange_rate = affiliate_wp_crypto()->base->integrations->get_exchange_rate(array('base_currency' => $base_currency, 'payment_currency' => $payment_currency));

      $this->exchange_rates[$base_currency . ':' . $payment_currency] = $exchange_rate;

    endif;

    $exchange_rate = apply_filters('affwp_crypto_exchange_rate', $exchange_rate, $ticker, $base_currency);

    //update_option('affwp_crypto_exchange_rate_' . $payment_currency, $exchange_rate);

    return $exchange_rate;

    // Add filter here for custom currency

  }

  // Gets an address balance (maybe cached to prevent excessive api calls, false by default)
  public function get_address_balance($args, $cached = false) {

    $currency_key = $args['currency'];

    $balance = '';

    if ( $cached && $currency_key && isset($this->address_balances[$currency_key]) ) :
      $balance = $this->address_balances[$currency_key];
    endif;

    if ( empty($balance) ) :

      $balance = affiliate_wp_crypto()->base->wallet->get_address_balance(array('currency' => $args['currency']));

    endif;

    $this->address_balances[$currency_key] = $balance;

    return $balance;

  }

  public function get_base_currency() {

    $base_currency = affiliate_wp()->settings->get('currency', 'USD');

    return $base_currency;
  }

  public function get_affiliates_payment_currency($affiliate_id) {

    $currency = affwp_get_affiliate_meta($affiliate_id, 'crypto_payment_currency', true);

    if ( !empty($currency) ) :

      //$ticker = affiliate_wp_crypto()->base->wallet->get_currency_config($currency, 'ticker');

      return $currency;
      //if( $return == 'ticker' ) return $ticker;

      //$ticker = affiliate_wp_crypto()->base->wallet->get_currency_config($currency, 'ticker');

    endif;

    return '';
  }

  public function get_affiliates_address($affiliate_id, $currency_key) {

    $address = affwp_get_affiliate_meta($affiliate_id, $currency_key . '_address', true);

    $address_network = $this->get_affiliates_address_network($affiliate_id, $currency_key);

    if ( !empty($address) && ($address_network == affwp_crypto_get_network()) ) :

      return $address;

    endif;

    return '';

  }

  public function get_affiliates_address_network($affiliate_id, $currency_key) {

    return $address_network = affwp_get_affiliate_meta($affiliate_id, $currency_key . '_address_network', true);

  }

  // check if affiliate has a currency selected and an address entered
  public function affiliate_has_active_address($affiliate_id) {

    $currency_key = $this->get_affiliates_payment_currency($affiliate_id);
    $address = $this->get_affiliates_address($affiliate_id, $currency_key);

    if ( !empty($currency_key) && !empty($address) ) :

      return true;

    endif;

    return false;

  }

  // Process referrals based on affiliate ID or an array if IDs
  public function generate_payments_from_affiliate_ids($affiliate_ids) {

    if ( !is_array($affiliate_ids) ) :

      if ( is_numeric($affiliate_ids) ) :

        $affiliate_ids = array($affiliate_ids);

      else:

        if ( $affiliate_ids == 'all' ) :

          $all_affiliates = affiliate_wp()->affiliates->get_affiliates(array('number' => 0));
          if ( !empty($all_affiliates) ) :

            $affiliate_ids = array();
            foreach ($all_affiliates as $a) :

              $affiliate_ids[] = $a->affiliate_id;

            endforeach;

          endif;

        else:

          $affiliate_ids = array((int)$affiliate_ids);

        endif;

      endif;

    endif;

    $referrals_array = array();
    foreach ($affiliate_ids as $key => $affiliate_id) :

      $referrals = affiliate_wp()->referrals->get_referrals(array('affiliate_id' => $affiliate_id, 'status' => 'unpaid', 'number' => -1));

      if ( !empty($referrals) ) :

        foreach ($referrals as $referral) :

          array_push($referrals_array, $referral->referral_id);

        endforeach;

      endif;

    endforeach;

    if ( !empty($referrals_array) ) :

      $payments = $this->generate_payments_from_referral_ids($referrals_array);

      return $payments;

    endif;

    return array();

    /* Object Reference
    To access: $referrals->referral_id;
    [referral_id]
    [affiliate_id]
    [visit_id]
    [description]
    [status]
    [amount]
    [currency]
    [custom]
    [context]
    [reference]
    [products]
    [date]
    */
  }

  // Process Conversions. Accepts an array of referral ID's or a single ID
  public function generate_payments_from_referral_ids($referrals) {

    if ( !is_array($referrals) ) {

      if ( is_numeric($referrals) ) {

        $referrals = array($referrals);

      } else {

        $referrals = array((int)$referrals);

      }

    }

    // Generate payouts sorted my affiliate
    $payouts = array();

    foreach ($referrals as $key => $referral_id) :

      $referral = affwp_get_referral($referral_id);

      if ( $referral->status == 'unpaid' ) :

        $affiliate_id = $referral->affiliate_id;
        $user_id = affwp_get_affiliate_user_id($affiliate_id);

        if ( !isset($payouts[$affiliate_id]['base_amount']) ) :
          $payouts[$affiliate_id]['base_amount'] = 0;
        endif;

        if ( !isset($payouts[$affiliate_id]['payment_amount']) ) :
          $payouts[$affiliate_id]['payment_amount'] = 0;
        endif;

        //$referral_amount = $referral->amount;

        $payment_currency = $this->get_affiliates_payment_currency($affiliate_id);
        //$pc_config = affiliate_wp_crypto()->base->wallet->get_currency_config($payment_currency);
        if ( affiliate_wp_crypto()->base->wallet->is_currency_active($payment_currency, true) ) :

          $base_currency = $this->get_base_currency();
          $address = $this->get_affiliates_address($affiliate_id, $payment_currency);
          $base_amount = $referral->amount;

          if ( !empty($base_currency) && !empty($payment_currency) ) :
            $exchange_rate = $this->get_exchange_rate($base_currency, $payment_currency);
          endif;

          if ( !empty($base_currency) && !empty($base_amount) && !empty($payment_currency) && !empty($exchange_rate) ) :
            $crypto_amount = $this->convert_currency($base_currency, $base_amount, $payment_currency, $exchange_rate);
          endif;

          //$debug_array = array($affiliate_id, $user_id, $base_currency, $payment_currency, $address, $base_amount, $crypto_amount, $address);
          //update_option('crypto_payments_debug3', $debug_array);

          //update_option('affwp_crypto_payments_debug_0', $base_currency . ' - ' . $base_amount . ' - ' . $payment_currency . ' - ' . $exchange_rate . ' - ' . $crypto_amount . ' - ' . $address);

          if ( !empty($crypto_amount) && !empty($address) ) :

            $payouts[$affiliate_id]['type'] = 'affiliate_payout';
            $payouts[$affiliate_id]['user_id'] = $user_id;
            $payouts[$affiliate_id]['affiliate_id'] = $affiliate_id;
            $payouts[$affiliate_id]['referrals'][] = $referral_id;
            $payouts[$affiliate_id]['base_amount'] += $base_amount;
            //$payouts[$affiliate_id]['base_amount'] = bcadd($payouts[$affiliate_id]['base_amount'], $base_amount, 20);
            //$payouts[$affiliate_id]['payment_amount'] += $crypto_amount;

            $type = affiliate_wp_crypto()->base->wallet->get_currency_config($payment_currency, 'type');

            //$currencies = affiliate_wp_crypto()->base->wallet->get_currencies();
            //$decimals = $currencies[strtolower($payment_currency)]['decimals'];
            if ( $type && $type == 'token' ) :
              $decimals = affiliate_wp_crypto()->base->wallet->get_currency_config($payment_currency, 'token_decimals');
            else:
              $decimals = affiliate_wp_crypto()->base->wallet->get_currency_config($payment_currency, 'decimals');
            endif;

            $payouts[$affiliate_id]['payment_amount'] = bcadd($payouts[$affiliate_id]['payment_amount'], $crypto_amount, $decimals);

            $payouts[$affiliate_id]['address'] = $address;
            $payouts[$affiliate_id]['base_currency'] = $base_currency;
            $payouts[$affiliate_id]['payment_currency'] = $payment_currency;
            $payouts[$affiliate_id]['exchange_rate'] = $exchange_rate;

            //$type = affiliate_wp_crypto()->base->wallet->get_currency_config($payment_currency, 'type');

            if ( !empty($type) ) :
              if ( $type == 'token' ) :
                $payouts[$affiliate_id]['currency_type'] = $type;
                $payouts[$affiliate_id]['token_decimals'] = $decimals;
                $payouts[$affiliate_id]['token_address'] = affiliate_wp_crypto()->base->wallet->get_currency_config($payment_currency, 'token_address');
              endif;
            endif;

          endif;

        endif;

      endif;

    endforeach;

    if ( !empty($payouts) ) :

      //$min_payout = affwp_crypto_setting('min_payout_amount');
      //if ( empty($min_payout) || (!empty($min_payout) && $min_payout <= $payouts[$affiliate_id]['amount']) ) :

      // The payments array gets passed to the wallet UI. It has individual payments + bulk payment variables
      $payments = array('payments' => array(), 'payment_ids' => array(), 'payments_ui_data' => array());
      // Payments IDs gathered to pass to the processing function (is required)
      //$payment_ids = array();
      // Bulk payment variables

      foreach ($payouts as $affiliate_id => $payout_data) :

        // do not allow payouts of 0
        if ( $payout_data['payment_amount'] > 0 ) :

          $payment_id = $this->create_payment($payout_data);

          if ( $payment_id ) :

            // Add individual payments
            $payments['payments'][$payment_id] = $payout_data;
            $payments['payments'][$payment_id]['payment_id'] = $payment_id;
            $payments['payments'][$payment_id]['affiliate_name'] = affwp_get_affiliate_name($payout_data['affiliate_id']);

            // Add the raw payment IDs
            array_push($payments['payment_ids'], $payment_id);

          endif;

        endif;

      endforeach;

      // Prepare an array of data to be returned to the payments UI
      $payments['payments_ui_data'] = $this->prepare_payments_ui_data($payments);
      $payments['payments_ui_data']['payments'] = $payments['payments'];
      $payments['payments_ui_data']['payment_ids'] = $payments['payment_ids'];

      // TO-DO - Here for testing only
      // Move from here to the wallet processing functions
      //$this->approve_payments($payment_ids);

      //update_option('affwp_crypto_payments_debug_final', $payments);

      return $payments;

      //endif;

    endif;

  }

  // Approve the payment - Ready to be processed and sent to the blockchain via cron. ONly used by auto payments
  public function approve_payments($payment_ids) {

    foreach ($payment_ids as $payment_id) :

      $payments = $this->get_payments("id = {$payment_id}");

      if ( !empty($payments) ) :

        foreach ($payments as $payment) :

          /// Generate the AffiliateWP Payout
          /*$data = array(
              'affiliate_id' => $payment->affiliate_id,
              'referrals' => unserialize($payment->referrals),
              'amount' => $payment->base_amount,
          );
          $payout_id = $this->generate_affiliate_wp_payout($data);*/

          // Update the payment status and add the payout ID
          //$update_data = array('payout_id' => $payout_id, 'status' => 'approved');
          $update_data = array('status' => 'approved');
          $where = array('id' => $payment_id);
          $this->update_payment($update_data, $where);

        endforeach;

      endif;
      ///

    endforeach;

    // Move to cron
    //$this->process_payments($payment_ids);

  }

  // Cron process approved payments
  public function process_approved_payments() {

    $payments = $this->get_payments("status = 'approved' LIMIT 1");

    $payment_ids = array();
    if ( !empty($payments) ) :

      foreach ($payments as $payment) :

        $payment_ids[] = $payment->id;

      endforeach;

    endif;

    if ( !empty($payment_ids) ) :

      //update_option('crypto_approve_process', $payment_ids);

      $this->process_payments($payment_ids);

    endif;

  }

  // Process the actual payments - send to the blockchain integrations (not manual methods)
  public function process_payments($payment_ids) {

    //update_option('crypto_process_payments1', $payment_ids);

    $prepared_array = $this->prepare_payments($payment_ids);

    $active_currencies = affiliate_wp_crypto()->base->wallet->get_active_currencies();

    //update_option('crypto_token_p_args0', $active_currencies);

    // Loops through payments grouped by currency
    foreach ($prepared_array as $currency => $payments) :

      // The payment must have a source
      // This filters out any active currencies with only manual methods such as metamask
      if ( !empty($active_currencies[$currency]['source']) ) :

        $args = array(
          'integration' => $active_currencies[$currency]['source'],
          'currency' => $currency,
          'payments' => $payments,
          'payment_ids' => $payment_ids,
          'currency_args' => $active_currencies[$currency]
        );

        //update_option('crypto_token_p_args1', $args);

        $processed_payments = affiliate_wp_crypto()->base->integrations->send($args);

        //update_option('crypto_process_payments1', $processed_payments);

        if ( !empty($processed_payments) ) :

          $processed_payments = $this->complete_payments($processed_payments);

          return $processed_payments;

        endif;

      endif;

    endforeach;

  }

  public function prepare_payments($payment_ids) {

    $prepared_array = array();

    foreach ($payment_ids as $payment_id) :

      $payment_objects = $this->get_payments("id = {$payment_id}");

      foreach ($payment_objects as $key => $payment_object) :

        $prepared_array[$payment_object->payment_currency][] = array(
          'payment_id' => $payment_object->id,
          'currency' => $payment_object->payment_currency,
          'address' => $payment_object->address,
          'payment_amount' => $payment_object->payment_amount
        );

      endforeach;

    endforeach;

    return $prepared_array;

  }

  public function prepare_payments_ui_data($payments) {

    $payments_ui_data = array();

    foreach ($payments['payments'] as $payment_id => $payment_data) :

      $currency_key = $payment_data['payment_currency'];
      $c_config = affiliate_wp_crypto()->base->wallet->get_currency_config($currency_key);
      //$max_fee = ($c_config['type'] == 'token') ? $c_config['token_max_fee'] : $c_config['max_fee'];
      //update_option( 'affwp_crypto_'.$currency_key, $max_fee);
      $decimals = ($c_config['type'] == 'token') ? $c_config['token_decimals'] : $c_config['decimals'];

      $c_settings = affiliate_wp_crypto()->base->wallet->get_currency_settings($currency_key);

      // Add payment IDs
      $payments_ui_data['currencies'][$currency_key]['payment_ids'][] = $payment_id;

      // Add payments
      $payments_ui_data['currencies'][$currency_key]['payments'][$payment_id] = $payment_data;

      // Add totals
      if ( isset($payments_ui_data['currencies'][$currency_key]['total']) ) :

        $payments_ui_data['currencies'][$currency_key]['total'] = bcadd($payments_ui_data['currencies'][$currency_key]['total'], $payment_data['payment_amount'], $decimals);

      else:

        $payments_ui_data['currencies'][$currency_key]['total'] = $payment_data['payment_amount'];

      endif;

      // Check required send fields
      if ( !isset($payments_ui_data['currencies'][$currency_key]['required_send_fields']) ) $payments_ui_data['currencies'][$currency_key]['required_send_fields'] = array();
      if ( !isset($payments_ui_data['all']['required_send_fields']) ) $payments_ui_data['all']['required_send_fields'] = array();
      if ( !isset($send_fields_added) ) $send_fields_added = array();

      $send_fields = affiliate_wp_crypto()->base->wallet->get_send_fields($c_settings['source'], $c_settings['method'], $c_settings['currency']);

      //$fields_added = array();
      foreach ($send_fields as $send_field_key => $send_field_data) :

        $field_value = $currency_key . '_' . $send_field_key;

        if ( empty($c_settings[$send_field_key]) ) :

          if ( !in_array($field_value, $send_fields_added) ) : /////////////////////////////////////////////////////////////////////////////////////

            $payments_ui_data['currencies'][$currency_key]['required_send_fields'][] = $field_value;
            $payments_ui_data['currencies'][$currency_key]['required_send_field_labels'][$field_value] = $send_field_data['label'];
            $payments_ui_data['all']['required_send_fields'][] = $field_value;

            array_push($send_fields_added, $field_value);

          endif;

        endif;

      endforeach;

    endforeach;

    // Calculate fees
    if ( !empty($payments_ui_data['currencies']) ) :

      foreach ($payments_ui_data['currencies'] as $currency_key => $payment_data) :

        $c_config = affiliate_wp_crypto()->base->wallet->get_currency_config($currency_key);

        $max_fee = ($c_config['type'] == 'token') ? $c_config['token_max_fee'] : $c_config['max_fee'];
        $fee_currency = ($c_config['type'] == 'token') ? $c_config['token_fee_currency'] : $c_config['fee_currency'];
        $decimals = ($c_config['type'] == 'token') ? $c_config['token_decimals'] : $c_config['decimals'];

        $fees = bcmul(count($payment_data['payment_ids']), $max_fee, $decimals);
        //update_option( 'affwp_crypto_fees_'.$currency_key, $fees);
        $payments_ui_data['currencies'][$currency_key]['fees'] = $fees;
        $payments_ui_data['currencies'][$currency_key]['fee_currency'] = $fee_currency;
        //$payments_ui_data['currencies'][$currency_key]['total_inc_fees'] = bcadd($payments_ui_data['currencies'][$currency_key]['total'], $fees, $decimals);

        // Totals including token payouts
        $payments_ui_data['currencies'][$fee_currency]['total_fees'] = (!empty($payments_ui_data['currencies'][$fee_currency]['total_fees'])) ? $payments_ui_data['currencies'][$fee_currency]['total_fees'] : 0;
        $payments_ui_data['currencies'][$fee_currency]['total_fees'] += $fees;


      endforeach;

    endif;

    return $payments_ui_data;

  }

  // Complete a payment. Generate the AffWP payout and mark payment status to sent
  public function complete_payments($processed_payments) {

    foreach ($processed_payments as $key => $payment) :

      $transaction_id = $payment['tx_hash'];
      $payment_id = $payment['payment_id'];

      if ( !empty($transaction_id) && !empty($payment_id) ) :

        $payment_data = $this->get_payment(array('payment_id' => $payment_id));

        // Generate the AffWP Payout with sent status
        $data = array(
          'affiliate_id' => $payment_data['affiliate_id'],
          'referrals' => unserialize($payment_data['referrals']),
          'amount' => $payment_data['base_amount'],
          'status' => 'sent'
        );
        $payout_id = $this->generate_affiliate_wp_payout($data);

        // Change the referrals statuses to sent
        $this->payment_change_referrals_status($payment_id, 'sent');

        // Update the payment status to sent add the payout ID
        $update_data = array('transaction' => $transaction_id, 'transaction_date' => current_time('mysql'), 'payout_id' => $payout_id, 'status' => 'sent');
        $where = array('id' => $payment_id);
        $this->update_payment($update_data, $where);

      endif;

    endforeach;

    //$this->check_payment_statuses();

    return $processed_payments;

  }

  // Complete payments made with manual methods such as metamask
  /*public function complete_manual_payments($payments) {
  }*/

  public function check_payment_statuses_delayed() {

    $args = array('mode' => 'delayed', 'allow_failed' => true);
    $this->check_payment_statuses($args);

  }

  // Check the payments on the blockchain
  // Generate an AffiliateWP Payout
  public function check_payment_statuses($args = array()) {

    $confirm_attempts = (!empty($args['confirm_attempts'])) ? $args['confirm_attempts'] : 100;

    // Must have a minimum attempts
    if ( !empty($args['mode']) && $args['mode'] == 'delayed' ) :

      $payments = $this->get_payments("status = 'sent' AND confirm_attempts > {$confirm_attempts} LIMIT 1");

    //update_option('crypto_check_delayed', 1);
    //update_option('crypto_check_delayed_payments', $payments);

    // Default is zero which is a new payment that has never been checked
    else:

      $payments = $this->get_payments("status = 'sent' AND confirm_attempts <= {$confirm_attempts} LIMIT 1");

      //update_option('crypto_check_standard', 1);
      //update_option('crypto_check_standard_payments', $payments);

    endif;


    if ( !empty($payments) ) :

      foreach ($payments as $payment) :

        // Only check transactions that are older than 10 minutes (600 seconds)
        if ( $this->get_payment_age($payment->id, 'transaction_date') > 600 ) :

          $get_t_args = array(
            'currency' => $payment->payment_currency,
            'txs_hash' => $payment->transaction,
            'network' => $payment->network
          );

          $txs_data = affiliate_wp_crypto()->base->integrations->get_transaction($get_t_args);

          if ( isset($txs_data['api_response']['status']) && $txs_data['api_response']['status'] == 'error' ) :

          else:
            //update_option('crypto_check_txs_data', $txs_data);

            //update_option( 'crypto_txs', $txs_data);

            $this->increase_confirm_attempts($payment->id);

            // If confirmations exist and the status is not 'failed'(ETH)
            if (
            (!empty($txs_data['confirmations']) && (!isset($txs_data['status'])) ||
              (isset($txs_data['status']) && $txs_data['status'] != 'failed'))
            ) :

              $c_config = affiliate_wp_crypto()->base->wallet->get_currency_config($payment->payment_currency);

              if ( $txs_data['confirmations'] >= $c_config['confirmations'] ) :

                // Update the payment status to confirmed
                //$update_data = array('confirmations' => $txs_data['confirmations'], 'status' => 'confirmed');
                $update_data = array('status' => 'confirmed');
                $where = array('id' => $payment->id);
                $this->update_payment($update_data, $where);

                // Change the referral statuses to paid
                $this->payment_change_referrals_status($payment->id, 'paid');

                // Update the payout status to paid
                $this->update_affiliatewp_payout_status($payment->payout_id, 'paid');

              endif;

            // If confirmations don't exists or the status is failed
            elseif (
              (empty($txs_data['confirmations']) && $this->get_payment_age($payment->id, 'transaction_date') > 259200) ||
              (isset($txs_data['status']) && $txs_data['status'] == 'failed')
            ):

              //update_option('crypto_check_delayed2', 1);

              if ( $args['allow_failed'] ) :

                //update_option('crypto_check_delayed3', 1);

                // If older than 1 week
                //if ( $this->get_payment_age($payment->id, 'transaction_date') > 604800 ) :

                // If older than 3 days
                //if ( $this->get_payment_age($payment->id, 'transaction_date') > 259200 ) :

                //update_option('crypto_check_delayed4', 1);

                // Reverse the payout and/or mark as failed

                // Update the payment status to failed
                $update_data = array('status' => 'failed');
                $where = array('id' => $payment->id);
                $this->update_payment($update_data, $where);

                // Change the referral statuses to unpaid
                $this->payment_change_referrals_status($payment->id, 'unpaid');

                // Update the payout status to paid
                $this->update_affiliatewp_payout_status($payment->payout_id, 'failed');

                //endif;

              endif;

            endif;

          endif;

        endif;

      endforeach;

    endif;

  }

  // Complete payment and add payout
  //add_action('affwp_crypto_complete_payouts', 'affwp_crypto_complete_payout');
  public function generate_affiliate_wp_payout($data) {

    $args = array(
      'affiliate_id' => $data['affiliate_id'],
      'referrals' => $data['referrals'],
      'amount' => $data['amount'],
      'payout_method' => __('crypto', 'affiliatewp_crypto'),
      'status' => $data['status'],
      'date' => date("Y-m-d H:i:s"),
    );

    $payout_id = affwp_add_payout($args);

    return $payout_id;

  }

  // Modify all referral statuses for a payment
  public function payment_change_referrals_status($payment_id, $status) {

    $args = array('payment_id' => $payment_id);
    $payment = $this->get_payment($args);
    $referrals = $payment['referrals'];
    $referrals = unserialize($referrals);
    if ( !empty($referrals) ) :
      foreach ($referrals as $referral_id) :

        affwp_set_referral_status($referral_id, $status);

      endforeach;
    endif;

  }

// Database methods

// Create a crypto payment
  public function create_payment($data) {

    global $wpdb;

    $table_name = $wpdb->prefix . 'affiliate_wp_crypto_payments';

    if ( $wpdb->insert(
      $table_name,
      array(
        /*'type' => $data['type'],*/
        'user_id' => $data['user_id'],
        'affiliate_id' => $data['affiliate_id'],
        'referrals' => serialize($data['referrals']),
        'base_amount' => $data['base_amount'],
        'payment_amount' => $data['payment_amount'],
        'network' => affwp_crypto_get_network(),
        'address' => $data['address'],
        'base_currency' => $data['base_currency'],
        'payment_currency' => $data['payment_currency'],
        'exchange_rate' => $data['exchange_rate'],
        'transaction' => (!empty($data['transaction'])) ? $data['transaction'] : '',
        'status' => (!empty($data['status'])) ? $data['status'] : 'pending',
        'generation_date' => current_time('mysql')
      )
    )
    ) return $wpdb->insert_id;

    return false;

  }

  /*Example */
  /*$data = array(
          'type'          => 'affiliate_payment',
          'user_id' =>    => '1'],
          'reference'     => 546,
          'referrals'     => array( '143', '195'), // referral IDs
          'amount'        => 10000,
          'address'       => '0x6391a62573594c34483e5b70d87409a8c2f64090',
          'transaction'   => '0x6391a62573594c34483e5b70d87409a8c2f64090',
          'confirmations' => 2,
      );
  create_crypto_payment($data);*/

// Update crypto Payment
  public function update_payment($data, $where) {
    global $wpdb;

    $table_name = $wpdb->prefix . 'affiliate_wp_crypto_payments';

    $wpdb->update(
      $table_name,
      $data,
      $where
    );
  }

  /*Example*/
  /*$data = array(
      'type' => 'referral_payment',
      'reference' => 5777,
      'referrals'     => array( '143', '195'), // referral IDs
      'amount' => 5000,
      'address' => '0x639',
      'transaction' => '9a8c2f64090',
      'confirmations' => 4,
      'status' => 'confirmed'
  );
  $where = array(
      'id' => 2
  );
  update_crypto_payment($data, $where);*/

  // Update a payout status
  public function update_affiliatewp_payout_status($payout_id, $status) {

    global $wpdb;

    $data = array('status' => $status);
    $where = array('payout_id' => $payout_id);

    $table_name = $wpdb->prefix . 'affiliate_wp_payouts';

    $wpdb->update(
      $table_name,
      $data,
      $where
    );

  }

  // Get crypto payments. Returns standard post objects
  public function get_payments($where, $data = array()) {
    global $wpdb;

    $table_name = $wpdb->prefix . 'affiliate_wp_crypto_payments';
    $payments = $wpdb->get_results("SELECT * FROM {$table_name} WHERE {$where}");

    return $payments;
  }

  // Get a single payment. Returns array of all columns
  //affiliate_wp_crypto()->base->payments->get_payment(array('payment_id' => $payment_id));
  public function get_payment($args) {

    if ( isset($args['payment_id']) ) :

      $payments = $this->get_payments("id = {$args['payment_id']}");

    endif;

    if ( isset($args['payout_id']) ) :

      $payments = $this->get_payments("payout_id = {$args['payout_id']}");

    endif;

    if ( !empty($payments) ) :

      $payment = (array)$payments[0];

      return $payment;

    endif;

    return '';

  }

  // Delete a payment
  public function delete_payment($args) {

    if ( isset($args['payment_id']) ) :

      $payment_id = $args['payment_id'];

    endif;

    if ( isset($args['payout_id']) ) :

      $payment = $this->get_payment($args);
      if ( !empty($payment) ) :

        $payment_id = $payment['id'];

      endif;

    endif;

    if ( !empty($payment_id) ) :

      global $wpdb;
      $table_name = $wpdb->prefix . 'affiliate_wp_crypto_payments';
      $wpdb->delete($table_name, array('id' => $payment_id));

    endif;

  }

  // Get a crypto payment including extra formatted values. Returns array;
  public function get_formatted_payment($args) {

    /*if ( $args['payment_id'] ) :

        $payments = $this->get_payments("id = {$args['payment_id']}");

    endif;

    if ( $args['payout_id'] ) :

        $payments = $this->get_payments("payout_id = {$args['payout_id']}");

    endif;*/

    $payment = $this->get_payment($args);

    if ( !empty($payment) ) :

      //$payment = (array)$payments[0];

      foreach ($payment as $key => $value) :
        $payment[$key] = maybe_unserialize($value);
      endforeach;

      $c_config = affiliate_wp_crypto()->base->wallet->get_currency_config($payment['payment_currency']);

      // Format amount
      //if( $payment['payment_amount'] > 0 ) :
      $payment['formatted_amount'] = $payment['payment_amount'] . ' ' . $c_config['ticker'];
      $payment['formatted_amount_min'] = minify_amount($payment['payment_amount']) . ' ' . $c_config['ticker'];
      //endif;

      //echo '<pre>';
      //print_r($c_config);
      //echo '</pre>';

      // payout ID URL
      $payment['payout_url'] = '<a href="/wp-admin/admin.php?page=affiliate-wp-payouts&payout_id=' . $payment["payout_id"] . '&action=view_payout" target="_blank" class="payout_id text">' . $payment["payout_id"] . '</a>';

      $network = $payment['network'];

      // Add additional fields
      if ( $payment['transaction'] ) :
        $payment['explorer_url'] = str_replace("#thash#", $payment['transaction'], $c_config['explorer_url'][$network]);
        $payment['explorer_url_a'] = '<a href="' . $payment["explorer_url"] . '" target="_blank" class="explorer_link icon ' . $c_config['currency'] . '"></a>';
        $payment['explorer_url_at'] = '<a href="' . $payment["explorer_url"] . '" target="_blank" class="explorer_link text ' . $c_config['currency'] . '">' . minify_hash($payment["transaction"]) . '</a>';
      endif;
      //$payment = $payments[0];
      //echo '<pre>';
      //print_r($payment);
      //echo '</pre>';
      //$key = $args['key'];
      if ( !empty($args['key']) ) return $payment[$args['key']];
      return $payment;

    endif;

    return '';

  }

  // Get a payment column value
  public function get_payment_var($payment_id, $column) {

    $payment = $this->get_payment(array('payment_id' => $payment_id));

    if ( !empty($payment) ) :

      $var = maybe_unserialize($payment[$column]);

      if ( !empty($var) ) return $var;

    endif;

    return '';
  }

  // Check a payment's associated referrals all have a specific status
  public function confirm_payment_referral_statuses($payment_id, $statuses) {

    if ( !is_array($statuses) ) $statuses = array($statuses);

    $payment = $this->get_payment(array('payment_id' => $payment_id));

    $referrals = unserialize($payment['referrals']);
    if ( !empty($referrals) ) :

      foreach ($referrals as $referral_id) :

        $referral = affwp_get_referral($referral_id);

        if ( !in_array($referral->status, $statuses) ) :

          return false;

        endif;

      endforeach;

    endif;

    return true;

  }

  public function update_payment_log($payment_id, $log_row) {

    $payment_log = $this->get_payment_var($payment_id, 'log');
    $payment_log = (!empty($payment_log)) ? unserialize($payment_log) : array();

    array_push($payment_log, array($log_row));

    $payment_log = serialize($payment_log);

    $data = array('confirm_attempts' => $payment_log);
    $where = array('id' => $payment_id);
    $this->update_payment($data, $where);

  }

  // Get a payments age in seconds
  public function get_payment_age($payment_id, $type) {

    $payment_date = $this->get_payment_var($payment_id, $type);

    if ( $payment_date ) :

      $difference = time() - strtotime($payment_date);

      return $difference;

    endif;

    return 0;
  }

  // Increase the confirm attempts
  public function increase_confirm_attempts($payment_id) {

    $confirm_attempts = $this->get_payment_var($payment_id, 'confirm_attempts');
    //$confirm_attempts = (!empty($confirm_attempts)) ? $confirm_attempts : 0;
    $confirm_attempts++;

    $data = array('confirm_attempts' => $confirm_attempts);
    $where = array('id' => $payment_id);
    $this->update_payment($data, $where);

  }

  ///////// AJAX ////////

  public function ajax_pre_checks($response) {

    $payments_ui_data = $_POST['payments_ui_data'];

    $payment_ids = $_POST['payment_ids'];

    foreach ($payment_ids as $payment_id) :

      $amount = $payments_ui_data['payments'][$payment_id]['payment_amount'];
      $currency = $payments_ui_data['payments'][$payment_id]['payment_currency'];

      $c_config = affiliate_wp_crypto()->base->wallet->get_currency_config($currency);
      $decimals = ($c_config['type'] == 'token') ? $c_config['token_decimals'] : $c_config['decimals'];

      if ( !isset($totals[$currency]) ) $totals[$currency] = 0;
      $totals[$currency] = bcadd($totals[$currency], $amount, $decimals);

      $fee_currency = ($c_config['type'] == 'token') ? $c_config['token_fee_currency'] : $c_config['fee_currency'];
      $c_config = affiliate_wp_crypto()->base->wallet->get_currency_config($fee_currency);

      $max_fee = ($c_config['type'] == 'token') ? $c_config['token_max_fee'] : $c_config['max_fee'];
      $decimals = ($c_config['type'] == 'token') ? $c_config['token_decimals'] : $c_config['decimals'];

      if ( !isset($totals[$fee_currency]) ) $totals[$fee_currency] = 0;
      $totals[$fee_currency] = bcadd($totals[$fee_currency], $max_fee, $decimals);

    endforeach;

    //update_option('affwp_crypto_balance_check_0', $totals);

    //update_option('affwp_crypto_balance_check_1', $payments_ui_data);
    //update_option('affwp_crypto_balance_check_2', $payment_ids);

    foreach ($totals as $currency => $amount):

      $c_config = affiliate_wp_crypto()->base->wallet->get_currency_config($currency);
      $ticker = $c_config['ticker'];

      $balance = $this->get_address_balance(array('currency' => $currency), true);
      //update_option('affwp_crypto_balance_check_3', $balance);
      if ( $balance < $amount ) :

        //$response['type'] = 'error';

        $messages[$currency] = array(
          'type' => 'error',
          'heading' => $ticker . ' Balance Check Failed',
          'content' => 'You require: ' . $amount . ' ' . $ticker . '. <br>Your current balance is: ' . $balance . ' ' . $ticker . '.<br><br> Please try again after funding your address.',
        );

      endif;

    endforeach;

    if ( !isset($messages) ) :

      $response['type'] = 'success';

    elseif ( $response['type'] == 'error' ):

      //$response['type'] = 'error';
      $response['notification'] = affwp_crypto_array_to_messages($messages);
      $response['notification_type'] = 'prompt';
      $response['notification_style'] = 'error';
      $response['prompt_text'] = 'Okay';

    endif;

    //$response['type'] = 'success';

    //update_option('affwp_crypto_balance_check_4', $response);

    return $response;

  }

  // Approve and process
  public function ajax_pay_payments($response) {

    $this->provided_send_fields = $_POST['payments_data']['provided_send_fields'];
    add_filter('affwp_crypto_active_currencies', array($this, 'merge_send_fields'));

    $payment_id = $_POST['payment_id'];

    //update_option('crypto_post_' . $payment_id, $_POST);
    //update_option( 'affwp_crypto_payment_post_' . $payment_id, $_POST);

    if ( !empty($payment_id) ) :

      // Confirm the associated referrals are still unpaid (avoid double payment)
      if ( $this->confirm_payment_referral_statuses($payment_id, 'unpaid') ) :

        //$this->approve_payments(array($payment_id));

        //parse_str($_POST['form_data'], $form_data);

        //$processed_payments = $this->process_payments(array($payment_id));

        // Although multiple can be sent, currently only send one at a time
        $processed_payments = $this->process_payments(array($payment_id));

        update_option('affwp_crypto_apis_last_send_response', $processed_payments);

        // Normalized API responses (only for errors)
        if ( $processed_payments[0]['api_response']['status'] ) :
          $response['api_status'] = $processed_payments[0]['api_response']['status'];
          $response['api_code'] = $processed_payments[0]['api_response']['code'];
          $response['api_message'] = $processed_payments[0]['api_response']['message'];
        endif;

        //$payments = $this->get_payments("id = {$args['payment_id']}");

        //if( $processed_payments )

        $args = array('payment_id' => $payment_id);
        $payment = $this->get_payment($args);

        if ( $payment['status'] == 'sent' ) :

          $response['type'] = 'success';

          $formatted_payment_data = $this->get_formatted_payment($args);

          //$response['payment_status'] = ($payment['status'] == 'sent') ? ucfirst($payment['status']) . ' ' . $formatted_payment_data['explorer_url_at'] : ucfirst($payment['status']);
          $response['payment_status'] = ucfirst($payment['status']);
          $response['payment_tx_info'] = $formatted_payment_data['explorer_url_at'];
          $response['payment_payout_id'] = $formatted_payment_data['payout_url'];

        elseif ( $response['api_status'] && $response['api_status'] == 'error' ) :

          $response['type'] = 'error';

        endif;

      else:

        // Ignore if status is sent as it is in progress
        if ( !$this->confirm_payment_referral_statuses($payment_id, 'sent') ) :

          $response['type'] = 'success';
          $response['payment_status'] = 'Error - Duplicate';

        endif;

      endif;

    endif;

    return $response;

  }

  // Complete payments processed on the front end (metamask etc)
  public function ajax_complete_payments($response) {

    $completed_payments = $_POST['payments_data']['completed_payments'];

    if ( !empty($completed_payments) ) :

      foreach ($completed_payments as $payment_id => $data) :

        $transaction_id = $data['transaction_hash'];

        if ( !empty($payment_id) && !empty($transaction_id) ) :

          //$this->approve_payments(array($payment_id));

          $complete_payments = array(
            array('payment_id' => $payment_id, 'tx_hash' => $transaction_id)
          );

          $this->complete_payments($complete_payments);

          $response['type'] = 'success';

          $args = array('payment_id' => $payment_id);
          $formatted_payment_data = $this->get_formatted_payment($args);

          $response['payment_status'] = ucfirst($formatted_payment_data['status']);
          $response['payment_tx_info'] = $formatted_payment_data['explorer_url_at'];
          $response['payment_payout_id'] = $formatted_payment_data['payout_url'];

        endif;

      endforeach;

    endif;

    return $response;

  }

  // approve payments only
  /*public function ajax_approve_payments($response) {

      $this->approve_payments($_POST['payments_data']['payment_ids']);

      $response['type'] = 'success';

      return $response;

  }*/

  // Merge the manually provided keys
  public function merge_send_fields($active_currencies) {

    $send_fields = $this->provided_send_fields;

    if ( !empty($send_fields) ) :

      foreach ($send_fields as $send_field_key => $value) :

        $send_field_parts = explode("_", $send_field_key, 2);

        $currency_key = $send_field_parts[0];
        $field_key_key = $send_field_parts[1];

        $active_currencies[$currency_key][$field_key_key] = $value;

      endforeach;

    endif;

    return $active_currencies;

  }

  // no longer used but will be useful for auto payments
  public function check_payment_balances($args) {

    //update_option('affwp_crypto_check_' . $args['payment_currency'], $args);

    $amount = $args['payment_amount'];
    $currency_key = $args['payment_currency'];
    $fee_amount = $args['fee_amount'];
    $fee_currency_key = $args['fee_currency'];
    $allow_cache = (!empty($args['fee_currency'])) ? $args['fee_currency'] : false;

    $balance = $this->get_address_balance(array('currency' => $currency_key), $allow_cache);

    if ( $currency_key == $fee_currency_key ) :

      $check_amount = $amount + $fee_amount;
      if ( $balance < $check_amount ) :
        return false;
      endif;

    endif;

    if ( $currency_key != $fee_currency_key ) :

      if ( $balance < $amount ) :
        return false;
      endif;

      $fee_balance = $this->get_address_balance(array('currency' => $fee_currency_key), $allow_cache);
      if ( $fee_balance < $fee_amount ) :
        return false;
      endif;

    endif;

    return true;

  }

  public function ajax_load_payouts_ui($response) {

    ////// Set and check UI users //////
    /* $current_user_id = get_current_user_id();

     $ui_users = get_transient('affwp_crypto_ui_users');
     if ( empty($ui_users) ) $ui_users = array();

     $ui_users_display = $ui_users;
     foreach ($ui_users_display as $key => $value) {
         if ( $value == $current_user_id ) {
             unset($ui_users_display[$key]);
         }
     }

     if ( !empty($ui_users_display) ) :

         $ui_notice = 'The following users also have the payments UI open: ';

         $count = 1;
         foreach ($ui_users_display as $ui_user_id) :

             //if ( $ui_user_id != $current_user_id ) :
             $user_info = get_userdata($ui_user_id);

             $ui_notice .= $user_info->user_login;
             $ui_notice .= ($count >= 1 && $count < count($ui_users_display)) ? ', ' : '';

             //endif;

             ++$count;
         endforeach;

     endif;

     if ( !in_array($current_user_id, $ui_users) ) :

         array_push($ui_users, $current_user_id);

     endif;

     set_transient('affwp_crypto_ui_users', $ui_users, 2 * MINUTE_IN_SECONDS);*/

    //set_transient('affwp_crypto_ui_open', 1, 2 * MINUTE_IN_SECONDS);

    ////////////

    if ( isset($_POST['form_data']) ) :
      parse_str($_POST['form_data'], $form_data);
    endif;

    if ( $_POST['task'] == 'payout_single_affiliate' ) :

      $payments = $this->generate_payments_from_affiliate_ids($_POST['affiliate_id']);

    elseif ( $_POST['task'] == 'payout_bulk_affiliates' ):

      $payments = $this->generate_payments_from_affiliate_ids($form_data['affiliate_id']);

    elseif ( $_POST['task'] == 'payout_single_referral' ):

      $payments = $this->generate_payments_from_referral_ids($_POST['referral_id']);

    elseif ( $_POST['task'] == 'payout_bulk_referrals' ):

      $payments = $this->generate_payments_from_referral_ids($form_data['referral_id']);

    endif;

    ob_start();
    ?>
    <?php /*if ( $ui_notice ) : // not used */?><!--
      <div class="affwp_crypto_ui_section notices" style="text-align: center">
        <?php /*echo $ui_notice; */?>
      </div>
    --><?php /*endif; */?>

    <?php if ( affwp_crypto_get_network() != 'mainnet' ) : ?>

      <div style="text-align: center" class="affwp_crypto_network_label">
        Network: <?php echo ucfirst(affwp_crypto_get_network()); ?></div>

    <?php endif; ?>

    <?php if ( empty($payments['payments']) ) : ?>

      <div style="text-align: center">No Payments matched your Criteria</div>

    <?php else: ?>

      <!--<div>
          <h2>Connections</h2>
          <span class="connect_to_wallet_connect affwp_crypto_ui_button">Connect to WalletConnect</span>
      </div>-->

      <!--<table class="affwp_crypto_table">
          <thead>
          <tr>
              <th>Name</th>
              <th>Instrument</th>
          </tr>
          </thead>
          <tfoot>
          <tr>
              <th>Name</th>
              <th>Instrument</th>
          </tr>
          </tfoot>
          <tbody>
          <tr>
              <td>John Lennon</td>
              <td>Rhythm Guitar</td>
          </tr>
          <tr>
              <td>Paul McCartney</td>
              <td>Bass</td>
          </tr>
          </tbody>
      </table>-->

      <div class="affwp_crypto_ui_section wallet">
        <h2>Bulk Payouts Per Currency</h2>
        <div class="affwp_crypto_table_container">
          <table class="affwp_crypto_table payout_currencies">
            <thead>
            <tr>
              <th></th>
              <!--<th>Address</th>-->
              <!--<th>Balance</th>-->
              <th>Total Payout</th>
              <!--<th>(payments + max. fees)</th>-->
              <th>Max. Fees</th>
              <th>Payout Methods</th>
            </tr>
            </thead>
            <tbody>
            <?php
            // Get active currencies and manual methods
            $active_currencies = affiliate_wp_crypto()->base->wallet->get_active_currencies(true);
            //update_option('affwp_crypto_active_debug_2', $active_currencies);
            //$this->bulk_pay_button = true;

            foreach ($active_currencies as $key => $data) :
              //$address_data = $this->get_address_data(array('currency' => $key, 'address' => $active_currencies[$key]['address'], 'integration' => $active_currencies[$key]['source']));

              //$balance = $this->get_address_balance(array('currency' => $key), true);
              //$balance = ($balance > 0) ? $balance : 0;

              $total = $payments['payments_ui_data']['currencies'][$key]['total'];
              $total = ($total > 0) ? $total : 0;

              $fees = $payments['payments_ui_data']['currencies'][$key]['fees'];
              $fees = ($fees > 0) ? $fees : 0;

              $c_config = affiliate_wp_crypto()->base->wallet->get_currency_config($key);

              $fee_currency = ($c_config['type'] == 'token') ? $c_config['token_fee_currency'] : $c_config['fee_currency'];

              //$fee_string_append = ( $fee_currency !=  $key) ? affiliate_wp_crypto()->base->wallet->get_currency_config($fee_currency, 'ticker') : '';
              $fee_string_append = affiliate_wp_crypto()->base->wallet->get_currency_config($fee_currency, 'ticker');

              $manual_methods = $this->get_manual_methods($c_config['currency']);

              //$total_inc_fees = $payments['payments_ui_data']['currencies'][$key]['total_inc_fees'];
              //$total_inc_fees = ($total_inc_fees > 0) ? $total_inc_fees : 0;

              //$total_string = '(' . $total . ' + ' . $fees . ')';

              //$c_config = affiliate_wp_crypto()->base->wallet->get_currency_config($key);
              $ticker = $c_config['ticker'];
              ?>

              <?php
              if ( $total ) :

                /*$bc_args = array(
                    'payment_amount' => $total,
                    'payment_currency' => $key,
                    'fee_amount' => $fees,
                    'fee_currency' => $fee_currency,
                    'allow_cache' => true
                );
                $balance_checks = $this->check_payment_balances($bc_args);*/
                //$balance_checks = true;

                // Run a check of total fees to set the bulk pay status
                /*$bulk_fees = $payments['payments_ui_data']['currencies'][$key]['total_fees'];
                $bulk_fees = ($bulk_fees > 0) ? $bulk_fees : 0;

                $bulk_bc_args = array(
                    'payment_amount' => $total,
                    'payment_currency' => $key,
                    'fee_amount' => $bulk_fees,
                    'fee_currency' => $fee_currency,
                    'allow_cache' => true
                );

                if ( !$this->check_payment_balances($bulk_bc_args) || empty(affiliate_wp_crypto()->base->wallet->get_currency_active_methods($key, false)) ) $this->bulk_pay_button = false;
                */
                ?>
                <tr>
                  <td>
                    <?php
                    if ( $logo_src = affwp_crypto_get_currency_meta($key, 'logo') ) : ?>
                      <img class="affwp_crypto_currency_icon sml"
                           title="<?php echo $ticker; ?>"
                           src="<?php echo $logo_src; ?>">
                    <?php
                    else:
                      echo $ticker;
                    endif;
                    ?>
                  </td>
                  <!--                            <td><?php /*if ( $active_currencies[$key]['address'] ) echo minify_hash($active_currencies[$key]['address']); */ ?></td>
-->
                  <!--<td><?php /*//echo $balance; */ ?></td>-->
                  <td><?php echo $total; ?></td>
                  <td><?php echo $fees . ' ' . $fee_string_append ?></td>
                  <!--<td><?php /*echo ($total) ? $total : 0; */ ?></td>
                        <td><?php /*echo ($fees) ? $fees : 0; */ ?></td>
                        <td><?php /*echo ($total_inc_fees) ? $total_inc_fees : 0; */ ?></td>-->
                  <td>
                    <?php if ( !empty(affiliate_wp_crypto()->base->wallet->get_currency_active_methods($key, false)) ) : ?>
                      <span
                              class="affwp_crypto_ui_button payout_action currency <?php echo $ticker; ?> enabled <?php //echo ($balance_checks) ? 'enabled ' : 'disabled '; ?>row"
                              data-type="currency"
                              data-currency="<?php echo $key; ?>"
                              data-ticker="<?php echo $ticker; ?>"
                              data-method="api"
                              data-payments="<?php echo json_encode($payments['payments_ui_data']['currencies'][$key]['payment_ids']); ?>"
                      >APIs</span><!--<span> <?php /*//echo $balance; */ ?></span><br>-->
                    <?php endif; ?>
                    <?php foreach ($manual_methods as $m_key => $m_data): ?>
                      <?php if ( affiliate_wp_crypto()->base->wallet->is_currency_method_active($key, $m_key) ) : ?>
                        <span class="affwp_crypto_ui_button payout_action currency <?php echo $ticker; ?> enabled <?php //echo ($balance_checks) ? 'enabled ' : 'disabled '; ?>row"
                              data-type="currency"
                              data-currency="<?php echo $key; ?>"
                              data-ticker="<?php echo $ticker; ?>"
                              data-method="<?php echo $m_key; ?>"
                              data-payments="<?php echo json_encode($payments['payments_ui_data']['currencies'][$key]['payment_ids']); ?>"><?php echo $m_data['label']; ?></span>
                      <?php endif; ?>
                    <?php endforeach; ?>
                  </td>
                </tr>
              <?php endif; ?>


            <?php
            endforeach;
            //print_r($enabled_currencies);
            ?>
            </tbody>
          </table>
        </div>
      </div>

      <div class="affwp_crypto_ui_section bulk_payouts">
        <!--<h2>Bulk Payout Methods</h2>-->
        <div class="affwp_crypto_table_container">
          <table class="affwp_crypto_table">
            <tbody>
            <tr class="bulk_actions">
              <td>
                        <span class="affwp_crypto_ui_button payout_action enabled <?php //echo ($this->bulk_pay_button) ? 'enabled ' : 'disabled '; ?>bulk"
                              data-type="all"
                              data-method="api"
                              data-payments="<?php echo json_encode($payments['payment_ids']); ?>">PAYOUT ALL USING APIs</span>
              </td>
            </tr>
            </tbody>
          </table>
        </div>
      </div>

      <div class="affwp_crypto_ui_section affiliate_payments">
        <h2>Payouts Per Affiliate</h2>
        <?php //if ( empty($payments['payments']) ) :
        ?>
        <!--<div>No Payments matched your Criteria</div>-->
        <?php //else:
        ?>
        <div class="affwp_crypto_table_container">
          <table class="affwp_crypto_table affiliate_payments">
            <thead>
            <tr>
              <th><!--Currency--></th>
              <th>Affiliate</th>
              <th>Payout</th>
              <!--<th>Referrals</th>-->
              <th>Payout ID</th>
              <th>Tx Info</th>
              <th>Status</th>
              <th>Payout Methods</th>
            </tr>
            </thead>
            <tbody>
            <?php
            //if ( !empty($payments['payments']) ) :
            foreach ($payments['payments'] as $payment_id => $payment_data) :
              $c_config = affiliate_wp_crypto()->base->wallet->get_currency_config($payment_data['payment_currency']);

              //$balance = $this->get_address_balance(array('currency' => $payment_data['payment_currency']), true);
              //$total_inc_fees = $payments['payments_ui_data']['currencies'][$payment_data['payment_currency']]['total_inc_fees'];

              //$balance = $this->get_address_balance(array('currency' => $key), true);
              //$balance = ($balance > 0) ? $balance : 0;

              $fees = $payments['payments_ui_data']['currencies'][$payment_data['payment_currency']]['fees'];
              $fees = ($fees > 0) ? $fees : 0;

              //$c_config = affiliate_wp_crypto()->base->wallet->get_currency_config($payment_data['payment_currency']);
              $fee_currency = ($c_config['type'] == 'token') ? $c_config['token_fee_currency'] : $c_config['fee_currency'];

              $manual_methods = $this->get_manual_methods($payment_data['payment_currency']);

              /*$bc_args = array(
                  'payment_amount' => $payment_data['payment_amount'],
                  'payment_currency' => $payment_data['payment_currency'],
                  'fee_amount' => $fees,
                  'fee_currency' => $fee_currency,
                  'allow_cache' => true
              );
              $balance_checks = $this->check_payment_balances($bc_args);*/

              //$balance_checks = true;

              ?>
              <tr id="payment_id_<?php echo $payment_id; ?>">
                <td>
                  <?php
                  if ( $logo_src = affwp_crypto_get_currency_meta($payment_data['payment_currency'], 'logo') ) : ?>
                    <img class="affwp_crypto_currency_icon sml"
                         title="<?php echo $c_config['ticker']; ?>"
                         src="<?php echo $logo_src; ?>">
                  <?php else:
                    echo $c_config['ticker'];
                  endif;
                  ?>
                </td>
                <td><?php echo $payment_data['affiliate_name']; ?></td>
                <td><?php echo $payment_data['payment_amount']; ?></td>
                <td class="payout_id"></td>
                <td class="tx_info"></td>
                <td class="status">Pending</td>
                <td>
                  <?php if ( !empty(affiliate_wp_crypto()->base->wallet->get_currency_active_methods($payment_data['payment_currency'], false)) ) : ?>
                    <span class="affwp_crypto_ui_button payout_action affiliate <?php echo $c_config['ticker']; ?> <?php echo $payment_data['affiliate_id']; ?> enabled <?php //echo ($balance_checks) ? 'enabled ' : 'disabled '; ?>row"
                          data-type="affiliate"
                          data-currency="<?php echo $payment_data['payment_currency']; ?>"
                          data-ticker="<?php echo $c_config['ticker']; ?>"
                          data-method="api"
                          data-affiliate="<?php echo $payment_data['affiliate_id']; ?>"
                          data-payments="<?php echo json_encode(array($payment_id)); ?>">APIs</span>
                  <?php endif; ?>
                  <?php foreach ($manual_methods as $m_key => $m_data): ?>
                    <?php if ( affiliate_wp_crypto()->base->wallet->is_currency_method_active($payment_data['payment_currency'], $m_key) ) : ?>
                      <span class="affwp_crypto_ui_button payout_action affiliate <?php echo $c_config['ticker']; ?> <?php echo $payment_data['affiliate_id']; ?> enabled <?php //echo ($balance_checks) ? 'enabled ' : 'disabled '; ?>row"
                            data-type="affiliate"
                            data-currency="<?php echo $payment_data['payment_currency']; ?>"
                            data-ticker="<?php echo $c_config['ticker']; ?>"
                            data-method="<?php echo $m_key; ?>"
                            data-affiliate="<?php echo $payment_data['affiliate_id']; ?>"
                            data-payments="<?php echo json_encode(array($payment_id)); ?>"><?php echo $m_data['label']; ?></span>
                    <?php endif; ?>
                  <?php endforeach; ?>

                </td>
              </tr>
            <?php
            endforeach;
            //endif;

            //endif; ?>
            </tbody>
          </table>
        </div>
      </div>

      <div class="affwp_crypto_ui_section payments_ui_log">
        <div class="payments_ui_log_header"></div>
        <div class="payments_ui_log_content"></div>
        <div class="payments_ui_log_footer">
          <div class="payments_ui_log_status"><b>Queue Status:</b>
            <span class="payments_ui_log_status_label"></span>
          </div>
        </div>
      </div>

      <!--<div class="affwp_crypto_modal_close" title="close"></div>
      <div class="affwp_crypto_modal_content"></div>
      <div class="affwp_crypto_modal_prompt_button"></div>-->

      <div class="affwp_crypto_modal standard affwp_crypto_send_fields_form">
        <div class="affwp_crypto_send_fields_close" title="close"></div>
        <div class="affwp_crypto_modal_content"></div>
        <h3>Please enter the following required keys</h3>
        <p>These keys are never saved. They are discarded after the transactions are processed.</p>
        <form name="send_fields" id="send_fields">
          <?php
          foreach ($payments['payments_ui_data']['currencies'] as $currency => $c_data) :
            $c_config = affiliate_wp_crypto()->base->wallet->get_currency_config($currency);
            foreach ($c_data['required_send_fields'] as $field_key) :
              echo '<pre>';
              //print_r($c_data);
              echo '</pre>'; ?>
              <label for="<?php echo $field_key; ?>"
                     class="send_field <?php echo $field_key; ?>"><?php echo $c_config['ticker'] . ' ' . $c_data['required_send_field_labels'][$field_key] . ': '; ?>
                <input name="<?php echo $field_key; ?>" id="<?php echo $field_key; ?>"
                       placeholder="<?php //echo $field_key;
                       ?>"
                       class="send_field <?php echo $field_key; ?>" required>
              </label>
            <?php
            endforeach;
          endforeach;
          ?>
          <input type="submit" name="send_fields_submit" id="send_fields_submit" class="send_fields_submit">
        </form>
      </div>
      </div>

      <?php echo affwp_crypto_generate_modal(); ?>

    <?php

    endif;

    /*echo '<pre>';
    print_r($_POST);
    echo '</pre>';

    if( $form_data ) :
        echo '<pre>';
        print_r($form_data);
        echo '</pre>';
    endif;*/

    $payments['payments_ui_data']['redirect_url'] = remove_query_arg('action', $_SERVER['HTTP_REFERER']);

    /*echo '<pre>';
    print_r($payments['payments_ui_data']);
    echo '</pre>';*/

    $response['payments_ui_data'] = json_encode($payments['payments_ui_data']);
    $response['html'] = ob_get_contents();

    ob_end_clean();

    $response['type'] = 'success';
    return $response;


  }


}

?>