<?php

class AFFWP_CRYPTO_Base {

    protected $plugin_settings;
    protected $plugin_config;

    public function __construct() {

        //$this->plugin_config = unserialize(AFFWP_CRYPTO_PLUGIN_CONFIG);
        //$this->plugin_settings = unserialize(AFFWP_CRYPTO_PLUGIN_SETTINGS);
        $affiliate_wp_crypto = affiliate_wp_crypto();
        $this->plugin_config = $affiliate_wp_crypto->plugin_config;
        $this->plugin_settings = $affiliate_wp_crypto->plugin_settings;


        // If plugin features enabled
        //if( $this->plugin_settings[$this->plugin_config['plugin_prefix'].'_enable_mla'] == '1' ) :

        //$lps = get_site_option(  $this->plugin_config['plugin_prefix'].'_'.'lps', '' );
        //if( !empty($lps) && $lps != '2' ) :

        $this->load_textdomain();
        $this->includes();
        $this->setup_objects();

        //endif;

        //endif;

        // Scripts & Styles
        add_action('wp_enqueue_scripts', array($this, 'enqueue_scripts'));
        // Scripts & Styles Admin
        add_action('admin_enqueue_scripts', array($this, 'enqueue_scripts_admin'));
    }

    //_e('String', 'affiliatewp_crypto');
    //__( 'String', 'affiliatewp_crypto' );
    public function load_textdomain() {

        // Set filter for plugin's languages directory
        $lang_dir = $this->plugin_config['plugin_lang_dir'];

        global $wp_version;
        $get_locale = get_locale();
        if ( $wp_version >= 4.7 ) {
            $get_locale = get_user_locale();
        }

        $locale = apply_filters('plugin_locale', $get_locale, 'affiliatewp-crypto');
        $mofile = sprintf('%1$s-%2$s.mo', 'affiliatewp-crypto', $locale);

        $mofile_global = WP_LANG_DIR . '/affiliatewp-crypto/' . $mofile;

        if ( file_exists($mofile_global) ) {
            // Look in global /wp-content/languages/ folder
            load_textdomain('affiliatewp-crypto', $mofile_global);
        } else {
            // Load the default language files from plugin
            load_plugin_textdomain('affiliatewp-crypto', false, $lang_dir);
        }
    }

    private function includes() {

        // Includes
        //require_once $this->plugin_config['plugin_dir'] . 'plugin_core/includes/gamajo-template-loader.php';
        require_once $this->plugin_config['plugin_dir'] . 'plugin_core/includes/class-affwp-process-manager.php';

        // Core
        //require_once $this->plugin_config['plugin_dir'] . 'plugin_core/class-template-loader.php';
        require_once $this->plugin_config['plugin_dir'] . 'plugin_core/class-common.php';
        require_once $this->plugin_config['plugin_dir'] . 'plugin_core/class-wallet.php';
        require_once $this->plugin_config['plugin_dir'] . 'plugin_core/class-payments.php';
        require_once $this->plugin_config['plugin_dir'] . 'plugin_core/functions-admin.php';
        require_once $this->plugin_config['plugin_dir'] . 'plugin_core/functions-cron.php';
        //require_once $this->plugin_config['plugin_dir'] . 'plugin_core/functions-db.php';
        require_once $this->plugin_config['plugin_dir'] . 'plugin_core/functions-misc.php';

        // Integrations
        require_once $this->plugin_config['plugin_dir'] . 'plugin_core/integrations/class-integrations-base.php';
        require_once $this->plugin_config['plugin_dir'] . 'plugin_core/integrations/class-integrations.php';

        // Integrations
        // AffiliateWP BuddyPress
        /*if ( class_exists( 'AffiliateWP_BuddyPress' ) ) :
            if( $this->plugin_settings[$this->plugin_config['plugin_prefix'].'_dashboard_tab_enable'] == '1'
                && $this->plugin_settings[$this->plugin_config['plugin_prefix'].'_buddypress_enable'] == '1' ) :
                require_once $this->plugin_config['plugin_dir'] . 'plugin_core/integrations/affiliatewp-buddypress.php';
            endif;
        endif;*/

        // can be removed one integrated into the integrations class
        //require_once $this->plugin_config['plugin_dir'] . 'plugin_core/integrations/coinbase.php';
        //require_once $this->plugin_config['plugin_dir'] . 'plugin_core/integrations/cryptoapis.php';
        //require_once $this->plugin_config['plugin_dir'] . 'plugin_core/integrations/onchain.php'; // not working
        //require_once $this->plugin_config['plugin_dir'] . 'plugin_core/integrations/metamask.php';
        require_once $this->plugin_config['plugin_dir'] . 'plugin_core/integrations/examples/wallet_connect.php';
    }

    private function setup_objects() {
        //$this->hooks = new AFFWP_CRYPTO_Hooks();
        //$this->shortcodes = new AFFWP_CRYPTO_Shortcodes();

        //$this->integrations_base = new AFFWP_CRYPTO_Integrations_Base();
        $this->integrations = new AFFWP_CRYPTO_Integrations();
        $this->wallet = new AFFWP_CRYPTO_Wallet();
        $this->payments = new AFFWP_CRYPTO_Payments();

    }

    // Add the required scripts and styles
    public function enqueue_scripts() {

        // Dashboard Page
        /*if( isset($_GET['tab']) && $_GET['tab'] == 'mla-tab' ) :
        // jQuery
        wp_enqueue_script( 'affwp-mla-jquery', '//ajax.googleapis.com/ajax/libs/jquery/2.2.4/jquery.min.js' );

        // Step Indicator
        wp_enqueue_script( 'affwp-mla-step-indicator', plugin_dir_url(__FILE__) . 'includes/js/lib/animated-step-indicator/jquery.stepProgressBar.js', 'jquery', false );
        wp_enqueue_style( 'affwp-mla-step-indicator-css', plugin_dir_url(__FILE__) . 'includes/js/lib/animated-step-indicator/jquery.stepProgressBar.css' );

        endif;
    */
        wp_enqueue_style('affwp-crypto-css', plugin_dir_url(__FILE__) . 'includes/css/cs_plugin.css');

        wp_enqueue_script('affwp-crypto-global', plugin_dir_url(__FILE__) . 'includes/js/global.js', array('jquery'));

        //wp_enqueue_script('affwp-crypto-jquery', '//ajax.googleapis.com/ajax/libs/jquery/2.2.4/jquery.min.js');
        wp_localize_script('affwp-crypto-global', 'affwp_crypto_vars',
            array('ajaxurl' => admin_url('admin-ajax.php')));

        //wp_enqueue_script( 'affwp-crypto-admin', plugin_dir_url(__FILE__) . 'includes/js/admin.js' );

        // Wallet Connect
        // Not required on front end. here for testing only
        //wp_enqueue_script('affwp-crypto-wallet_connect', 'includes/js/wallet_connect/main.js');


    }

    // Add the required scripts and styles - Admin
    /*public function enqueue_scripts_admin() {

        wp_enqueue_style('affwp-crypto-css', plugin_dir_url(__FILE__) . 'includes/css/cs_plugin.css');

        wp_enqueue_script('affwp-crypto-jquery', '//ajax.googleapis.com/ajax/libs/jquery/2.2.4/jquery.min.js');
        wp_localize_script('affwp-crypto-jquery', 'affwp_crypto_vars',
            array('ajaxurl' => admin_url('admin-ajax.php')));

        wp_enqueue_script('affwp-crypto-global', plugin_dir_url(__FILE__) . 'includes/js/global.js');
        wp_enqueue_script('affwp-crypto-admin', plugin_dir_url(__FILE__) . 'includes/js/admin.js');

        // Web3/Metamask
        wp_enqueue_script('affwp-crypto-web3', '//rawgit.com/ethereum/web3.js/0.16.0/dist/web3.min.js');

        // Wallet Connect
        //wp_enqueue_script('affwp-crypto-wallet_connect_browser', plugin_dir_url(__FILE__) . 'includes/js/wallet_connect/packages/browser/lib/index.js');
        //wp_enqueue_script('affwp-crypto-wallet_connect_qr_modal', plugin_dir_url(__FILE__) . 'includes/js/wallet_connect/packages/qrcode-modal/lib/index.js');
        //wp_enqueue_script('affwp-crypto-wallet_connect_script', plugin_dir_url(__FILE__) . 'includes/js/wallet_connect/script.js');

        if ( $this->is_settings_page() ) :

            wp_enqueue_script('affwp-crypto-settings', plugin_dir_url(__FILE__) . 'includes/js/settings_page.js');

        endif;

    }*/

  // Add the required scripts and styles - Admin
  public function enqueue_scripts_admin() {

    wp_enqueue_style('affwp-crypto-css', plugin_dir_url(__FILE__) . 'includes/css/cs_plugin.css');

    wp_enqueue_script('affwp-crypto-global', plugin_dir_url(__FILE__) . 'includes/js/global.js', array('jquery'));
    wp_enqueue_script('affwp-crypto-admin', plugin_dir_url(__FILE__) . 'includes/js/admin.js');

    wp_localize_script('affwp-crypto-admin', 'affwp_crypto_vars',
      array('ajaxurl' => admin_url('admin-ajax.php')));

    // Web3/Metamask
    wp_enqueue_script('affwp-crypto-web3', '//rawgit.com/ethereum/web3.js/0.16.0/dist/web3.min.js');

    if ( $this->is_settings_page() ) :

      wp_enqueue_script('affwp-crypto-settings', plugin_dir_url(__FILE__) . 'includes/js/settings_page.js');

    endif;

  }


  public function is_settings_page() {

        if ( isset($_GET['tab']) && $_GET['tab'] == 'AFFWP_CRYPTO' ) return true;

        return false;
    }


} // End of class

?>