<?php
// AffiliateWP hooks that need to be here

// Add crypto fields to the admin edit affiliate form
add_action('affwp_edit_affiliate_end', 'affwp_admin_edit_affiliates_crypto_settings');
function affwp_admin_edit_affiliates_crypto_settings($affiliate) {

    $active_currencies = affiliate_wp_crypto()->base->wallet->get_active_currencies(true, true);
    $affiliates_currency = affiliate_wp_crypto()->base->payments->get_affiliates_payment_currency($affiliate->affiliate_id);
    ?>

    <tr class="form-row form-required">

        <th scope="row">
            <label for="crypto_payment_currency"><?php _e( 'Crypto Payment Currency', 'affiliatewp-crypto' ); ?></label>
        </th>
        <td>
            <select class="crypto_payment_currency" name="crypto_payment_currency">
                <option value=""><?php _e('None Selected', 'affiliatewp-crypto'); ?></option>
                <?php foreach ($active_currencies as $key => $data) :
                    $c_config = affiliate_wp_crypto()->base->wallet->get_currency_config($key); ?>
                    <option value="<?php echo $key; ?>" <?php echo ($key == $affiliates_currency) ? 'selected ' : ''; ?>><?php echo $c_config['ticker']; ?></option>
                <?php endforeach; ?>
            </select>
            <p class="description"><?php _e('The affiliate\'s Crypto Payment Currency', 'affiliatewp-crypto'); ?></p>
        </td>

    </tr>

    <?php
    if ( !empty($active_currencies) ) :

        foreach ($active_currencies as $key => $data) :
            ${$key . '_address'} = affiliate_wp_crypto()->base->payments->get_affiliates_address($affiliate->affiliate_id, $key);
            $c_config = affiliate_wp_crypto()->base->wallet->get_currency_config($key);
            ?>

            <tr class="form-row form-required">

                <th scope="row">
                    <label for="<?php echo $key . '_address' ?>"><?php echo $c_config['ticker']; ?> <?php _e('Address', 'affiliatewp-crypto'); ?></label>
                    <?php //print_r($active_currencies);
                    ?>
                </th>

                <td>
                    <input class="regular-text" type="text" name="<?php echo $key . '_address' ?>"
                           id="<?php echo $key . '_address' ?>"
                           value="<?php echo esc_attr(${$key . '_address'}); ?>"/>
                    <p class="description"><?php _e('The affiliate\'s', 'affiliatewp-crypto'); ?> <?php echo $c_config['ticker']; ?> <?php _e('address', 'affiliatewp-crypto'); ?>address</p>
                </td>

            </tr>

        <?php
        endforeach;

    endif;

}

// Update the crypto fields from the edit affiliate admin form
add_action('affwp_updated_affiliate', 'affwp_admin_update_affiliates_crypto_settings', 10, 2);
function affwp_admin_update_affiliates_crypto_settings($affiliate, $updated) {

    $active_currencies = affiliate_wp_crypto()->base->wallet->get_active_currencies(true, true);

    if ( $updated ) {

        $affiliate_id = $affiliate->affiliate_id;

        // The currency
        if ( !empty($_POST['crypto_payment_currency']) ) {

            $currency = $_POST['crypto_payment_currency'];
            affwp_update_affiliate_meta($affiliate_id, 'crypto_payment_currency', $currency);

        } else {

            affwp_delete_affiliate_meta($affiliate_id, 'crypto_payment_currency');

        }

        if ( !empty($active_currencies) ) :

            foreach ($active_currencies as $key => $data) :

                // The address
                if ( !empty($_POST[$key . '_address']) ) {

                    ${$key . '_address'} = sanitize_text_field($_POST[$key . '_address']);
                    affwp_update_affiliate_meta($affiliate_id, $key . '_address', ${$key . '_address'});

                    // Add the address network
                    affwp_update_affiliate_meta($affiliate_id, $key . '_address_network', affwp_crypto_get_network() );

                } else {

                    affwp_delete_affiliate_meta($affiliate_id, $key . '_address');

                }

            endforeach;

        endif;

    }
}

// Add the crypto fields to the affiliate registration form
add_action('affwp_register_fields_before_tos', 'affwp_add_crypto_fields_affiliate_registration_form');
function affwp_add_crypto_fields_affiliate_registration_form() {

    //$active_currencies = affiliate_wp_crypto()->base->wallet->get_active_currencies(true, true);
    $active_currencies = affiliate_wp_crypto()->base->wallet->get_active_currencies(true);
    //$affiliates_currency = affiliate_wp_crypto()->base->payments->get_affiliates_payment_currency($affiliate->affiliate_id);
    ?>

    <p>
        <label for="crypto_payment_currency"><?php _e('Crypto Payment Currency', 'affiliatewp-crypto'); ?></label>
        <select class="crypto_payment_currency" name="crypto_payment_currency">
            <option value=""><?php _e('None Selected', 'affiliatewp-crypto'); ?></option>
            <?php foreach ($active_currencies as $key => $data) :
                $c_config = affiliate_wp_crypto()->base->wallet->get_currency_config($key); ?>
                <option value="<?php echo $key; ?>"
                        data-currencykey="<?= $c_config['ticker']; ?>"><?php echo $c_config['ticker']; ?></option>
            <?php endforeach; ?>
        </select>
    </p>

    <?php
    if ( !empty($active_currencies) ) :

        foreach ($active_currencies as $key => $data) :

            $errors = affiliate_wp()->register->get_errors();
            if ( !array_key_exists('empty_' . $key . '_address', $errors) ) {

                ${$key . '_address'} = sanitize_text_field($_POST[$key . '_address']);

            }

            $c_config = affiliate_wp_crypto()->base->wallet->get_currency_config($key);
            ?>

            <p class="payment_currency_p <?php echo $c_config['ticker']; ?>" style="display:none;">
                <label for="<?php echo $key . '_address' ?>"><?php echo $c_config['ticker']; ?> <?php _e('Payment Address', 'affiliatewp-crypto'); ?></label>
                <input id="<?php echo $key . '_address' ?>" type="text" name="<?php echo $key . '_address' ?>"
                       value="<?php if ( !empty(${$key . '_address'}) ) {
                           echo ${$key . '_address'};
                       } ?>" title="<?php echo $c_config['ticker']; ?> <?php _e('Address', 'affiliatewp-crypto'); ?>"/>
            </p>

        <?php

        endforeach;

    endif;

}


// Save the crypto fields to the affiliate meta after registration
add_action('affwp_register_user', 'affwp_save_affiliate_crypto_settings', 10, 3);
function affwp_save_affiliate_crypto_settings($affiliate_id, $status, $args) {

    $active_currencies = affiliate_wp_crypto()->base->wallet->get_active_currencies(true, true);

    // The currency
    if ( !empty($_POST['crypto_payment_currency']) ) {

        $currency = $_POST['crypto_payment_currency'];
        affwp_update_affiliate_meta($affiliate_id, 'crypto_payment_currency', $currency);

    } else {

        affwp_delete_affiliate_meta($affiliate_id, 'crypto_payment_currency');

    }

    // The addresses
    if ( !empty($active_currencies) ) :

        foreach ($active_currencies as $key => $data) :

            ${$key . '_address'} = sanitize_text_field($_POST[$key . '_address']);

            if ( !empty(${$key . '_address'}) ) {

                affwp_add_affiliate_meta($affiliate_id, $key . '_address', ${$key . '_address'});

                 // Add the address network
                 affwp_update_affiliate_meta($affiliate_id, $key . '_address_network', affwp_crypto_get_network() );

            }

        endforeach;

    endif;

}


// Make the crypto fields required during affiliate registration {Remove if it shouldn't be required}
/*add_filter('affwp_register_required_fields', 'affwp_add_btc_address_to_required_fields');
function affwp_add_btc_address_to_required_fields($required_fields) {
    $required_fields['affwp_btc_address'] = array(
        'error_id' => 'empty_btc_address',
        'error_message' => 'Please enter your Bitcoin Address',
    );
    return $required_fields;
}*/

// Display the crypto fields in the Profile Settings page on the affiliate dashboard
add_action('affwp_affiliate_dashboard_before_submit', 'affwp_show_btc_address_in_affiliate_dashboard', 10, 2);
function affwp_show_btc_address_in_affiliate_dashboard($affiliate_id, $affiliate_user_id) {

    //$active_currencies = affiliate_wp_crypto()->base->wallet->get_active_currencies(true, true);
    $active_currencies = affiliate_wp_crypto()->base->wallet->get_active_currencies(true);
    //echo '<pre>'; print_r($active_currencies); echo '</pre>';
    $affiliates_currency = affiliate_wp_crypto()->base->payments->get_affiliates_payment_currency($affiliate_id);
    ?>

    <div class="affwp-wrap affwp-btc-address-wrap">

        <label for="crypto_payment_currency"><?php _e('Crypto Payment Currency', 'affiliatewp-crypto'); ?></label>
        <select class="crypto_payment_currency" name="crypto_payment_currency">
            <option value=""><?php _e('None Selected', 'affiliatewp-crypto'); ?></option>
            <?php foreach ($active_currencies as $key => $data) :
                $c_config = affiliate_wp_crypto()->base->wallet->get_currency_config($key); ?>
                <option value="<?php echo $key; ?>" <?php echo ($key == $affiliates_currency) ? 'selected ' : ''; ?>
                        data-currencykey="<?= $c_config['ticker']; ?>"><?php echo $c_config['ticker']; ?></option>
            <?php endforeach; ?>
        </select>

    </div>

    <?php
    if ( !empty($active_currencies) ) :

        foreach ($active_currencies as $key => $data) :

            ${$key . '_address'} = affiliate_wp_crypto()->base->payments->get_affiliates_address($affiliate_id, $key);
            $c_config = affiliate_wp_crypto()->base->wallet->get_currency_config($key);
            ?>

            <p class="payment_currency_p <?php echo $c_config['ticker']; ?>" <?php echo ($key != $affiliates_currency) ? 'style="display:none;"' : ''; ?>>
                <label for="<?php echo $key . '_address' ?>"><?php echo $c_config['ticker']; ?> <?php _e('Payment Address', 'affiliatewp-crypto'); ?></label>
                <input id="<?php echo $key . '_address' ?>" type="text" name="<?php echo $key . '_address' ?>"
                       value="<?php echo esc_attr(${$key . '_address'}); ?>"
                       title="<?php echo strtoupper($key); ?> <?php _e('Address', 'affiliatewp-crypto'); ?>"/>
            </p>

        <?php
        endforeach;

    endif;

}

// Update the crypto fields from the Profile Settings page in the affiliate dashboard
add_action('affwp_update_affiliate_profile_settings', 'affwp_affiliate_dashboard_update_btc_address');
function affwp_affiliate_dashboard_update_btc_address($data) {

    $affiliate_id = absint($data['affiliate_id']);
    $active_currencies = affiliate_wp_crypto()->base->wallet->get_active_currencies(true, true);

    // The currency
    if ( !empty($_POST['crypto_payment_currency']) ) {

        $currency = $_POST['crypto_payment_currency'];
        affwp_update_affiliate_meta($affiliate_id, 'crypto_payment_currency', $currency);

    } else {

        affwp_delete_affiliate_meta($affiliate_id, 'crypto_payment_currency');

    }

    // The addresses
    if ( !empty($active_currencies) ) :

        foreach ($active_currencies as $key => $data) :

            ${$key . '_address'} = sanitize_text_field($_POST[$key . '_address']);

            // The address
            if ( !empty($_POST[$key . '_address']) ) {

                ${$key . '_address'} = sanitize_text_field($_POST[$key . '_address']);
                affwp_update_affiliate_meta($affiliate_id, $key . '_address', ${$key . '_address'});

                // Add the address network
                affwp_update_affiliate_meta($affiliate_id, $key . '_address_network', affwp_crypto_get_network() );

            } else {

                affwp_delete_affiliate_meta($affiliate_id, $key . '_address');

            }

        endforeach;

    endif;

}

// Delete payment after a payout is deleted
add_action('affwp_delete_payout', 'affwp_crypto_delete_payout');
function affwp_crypto_delete_payout($payout_id) {

    affiliate_wp_crypto()->base->payments->delete_payment(array('payout_id' => $payout_id));

    //$this->delete_payment(array('payout_id' => $payout_id));

}
?>