<?php
/*
Plugin Name: AffiliateWP - Crypto
Plugin URI: http://clickstudio.com.au
Description: Crypto Payments for AffiliateWP
Version: 1.0.12
Author: Click Studio
Author URI: http://clickstudio.com.au
License: GPL2
*/

class AFFWP_CRYPTO {

  private static $instance = NULL;

  public static function instance() {

    /*NULL === self::$instance and self::$instance = new self;

    //self::$instance->plugin_config();
    self::$instance->includes();
    self::$instance->setup_objects();
    self::$instance->setup_hooks();

    return self::$instance;*/

    if ( NULL === self::$instance ) {

      self::$instance = new self;

      self::$instance->includes();
      self::$instance->setup_objects();
      self::$instance->setup_hooks();
    }

    return self::$instance;

  }

  public function __construct() {
    update_option( 'AFFWP_CRYPTO_'.'license_key', '12345678923dsf' );
    update_option( 'AFFWP_CRYPTO_'.'license_status', 'valid' );
    update_option( 'AFFWP_CRYPTO_'.'lps', 1 );

    $plugin_config = array();

    $plugin_config['plugin_file'] = __FILE__;
    $plugin_config['plugin_dir'] = plugin_dir_path(__FILE__);
    $plugin_config['plugin_lang_dir'] = basename(dirname(__FILE__)) . '/languages';

    // Item name must be identical to the name on Easy Digital Downloads server.
    $plugin_config['plugin_item_id'] = '33112';
    $plugin_config['plugin_item_name'] = 'AffiliateWP - Crypto';
    $plugin_config['plugin_item_sname'] = 'Crypto'; // Used for non critical things. Can be changed
    $plugin_config['plugin_prefix'] = 'AFFWP_CRYPTO';
    $plugin_config['plugin_version'] = '1.0.12';
    $plugin_config['plugin_updater_url'] = 'http://www.clickstudio.com.au';
    //$plugin_config['plugin_renewal_url'] = 'http://www.clickstudio.com.au/checkout'; /////////////// New not used yet
    $plugin_config['plugin_author'] = 'Click Studio';

    $this->plugin_config = $plugin_config;

    // Save plugin version
    update_site_option($plugin_config['plugin_prefix'] . '_version', $plugin_config['plugin_version']);

  }

  // Includes
  private function includes() {
    require_once $this->plugin_config['plugin_dir'] . 'plugin_core/class-settings.php';
    require_once $this->plugin_config['plugin_dir'] . 'plugin_core/class-base.php';
    if ( is_admin() ) {
      require_once $this->plugin_config['plugin_dir'] . 'includes/class-licenses.php';
      require_once $this->plugin_config['plugin_dir'] . 'includes/class-updater.php';
    }
  }

  // Set up objects
  private function setup_objects() {

    // AFFWP_CRYPTO_PLUGIN_CONFIG
    //define( $this->plugin_config['plugin_prefix'].'_PLUGIN_CONFIG', serialize( $this->plugin_config ) );

    // AFFWP_CRYPTO_PLUGIN_SETTINGS
    self::$instance->settings = new AFFWP_CRYPTO_Settings();
    self::$instance->plugin_settings = self::$instance->settings->plugin_settings;
    //define( $this->plugin_config['plugin_prefix'].'_PLUGIN_SETTINGS', serialize( self::$instance->plugin_settings ) );

    self::$instance->base = new AFFWP_CRYPTO_Base($this->plugin_config, self::$instance->plugin_settings);
    if ( is_admin() ) {
      self::$instance->license = new Click_Studio_Licenses_V1_5($this->plugin_config, self::$instance->plugin_settings);
      self::$instance->updater = new Click_Studio_Updater_V1_4($this->plugin_config, self::$instance->license->get_license_option('license_key'));
    }
  }

  // Set up hooks
  private function setup_hooks() {
  }

} // End of class


// Dependency check
add_action('init', 'affiliate_wp_crypto');
function affiliate_wp_crypto() {

  $activation_config = array(
    'plugin_name' => 'AffiliateWP - Multi Level Affiliates',
    'plugin_path' => plugin_dir_path(__FILE__),
    'plugin_file' => basename(__FILE__),
    'plugin_dependencies' => array(
      'Affiliate_WP' => array(
        'name' => 'AffiliateWP',
        'plugin_folder_file' => 'affiliate-wp/affiliate-wp.php',
        'url' => 'https://aaffiliatewp.com/'
      )
    ),

  );

  require_once 'includes/class-activation.php';
  $activation = new Click_Studio_Activation_V1_1($activation_config);

  // If all dependencies are fine return instance
  if ( $activation->check_dependencies() ) {
    return AFFWP_CRYPTO::instance();
    register_activation_hook(__FILE__, 'AFFWP_CRYPTO_Activate_Plugin');
  }

}

// Activation hook	
register_activation_hook(__FILE__, 'AFFWP_CRYPTO_Activate_Plugin');
function AFFWP_CRYPTO_Activate_Plugin() {

  //wp_schedule_event(time(), 'seconds_15', 'affwp_crypto_seconds_15');

  // Add custom 'crypto_payments' dB table
  global $wpdb;
  global $crypto_payments_db_version;

  $table_name = $wpdb->prefix . 'affiliate_wp_crypto_payments';

  $charset_collate = $wpdb->get_charset_collate();

  $sql = "CREATE TABLE $table_name (
		id mediumint(9) NOT NULL AUTO_INCREMENT,
		payout_id mediumint(9) NULL,
		/*type varchar(55) NOT NULL,*/
		user_id mediumint(9) NULL,
		affiliate_id mediumint(9) NULL,
		base_currency text NOT NULL,
        base_amount text NOT NULL,
        payment_currency text NOT NULL,
        payment_amount text NOT NULL,
        exchange_rate text NOT NULL,
        network text NOT NULL,
        address text NOT NULL,
		transaction text NULL,
		/*confirmations mediumint(9) NULL,*/	
		status text NOT NULL,
		generation_date datetime NOT NULL,
		transaction_date datetime NULL,
		confirm_attempts mediumint(9) DEFAULT 0 NULL,
		referrals longtext NOT NULL,
		log longtext NULL,
		PRIMARY KEY  (id)
	) $charset_collate;";

  require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
  dbDelta($sql);

  add_option('crypto_payments_db_version', $crypto_payments_db_version);
}

// New cron schedule
add_filter('cron_schedules', 'AFFWP_CRYPTO_new_cron_intervals');
function AFFWP_CRYPTO_new_cron_intervals($interval) {

  $interval['seconds_15'] = array('interval' => 15, 'display' => 'Once Every 15 Seconds');

  return $interval;
}

// Register cron tasks
function AFFWP_CRYPTO_new_cron_schedule_events() {

  if ( !wp_next_scheduled('affwp_crypto_seconds_15') ) {
    wp_schedule_event(time(), 'seconds_15', 'affwp_crypto_seconds_15');
  }

}
AFFWP_CRYPTO_new_cron_schedule_events();

// Deactivation hook
register_deactivation_hook(__FILE__, 'AFFWP_CRYPTO_Deactivate_Plugin');
function AFFWP_CRYPTO_Deactivate_Plugin() {
}

// Functions and actions required on plugin load
require_once plugin_dir_path(__FILE__) . 'functions.php';
//require_once plugin_dir_path( __FILE__ ) . 'customization_examples.php';

?>