<?php

class AffiliateWP_MLA_Matrix extends AffiliateWP_MLA_Common {

  public function __construct($args) {

    parent::__construct();

    $this->args = $args;
    $this->matrix_amount = $args['amount'];
    $this->matrix_affiliate_id = $args['affiliate_id'];
    $this->matrix_products = maybe_unserialize($args['products']);

  }

  // Prepare the matrix data.

  public function prepare_matrix_data() {

    $affiliate = new AffiliateWP_MLA_Affiliate($this->matrix_affiliate_id);

    // Just gets the default (global) matrix settings
    $matrix_aff_settings = $affiliate->get_affiliate_matrix_settings('', false);
    // Generates the default level variables
    $matrix_level_vars = $affiliate->get_matrix_level_vars(false);
    // Generates the default affiliates for each level
    $matrix_level_affiliates = $affiliate->get_all_level_affiliates();

    // Set matrix Data
    $matrix_data = array(
      'args' => $this->args, // The arguments passed from the insert pending referral filter
      'direct_affiliate_id' => $this->matrix_affiliate_id,
      'default_matrix_settings' => $matrix_aff_settings,
      'matrix_level_vars' => $matrix_level_vars,
      'matrix_level_affiliates' => $matrix_level_affiliates,
      'matrix_order_total' => $this->get_order_total(),
      'default_referrals' => array(),
      'referrals' => array(),
    );

    // The level 1 should be this as its passed in and can now be modified via the matrix settings in a previous hook (parent or purchaser)
    // This and direct affiliate should be merged ?
    $matrix_data['matrix_level_affiliates'][1] = $this->matrix_affiliate_id;

    if ( !empty($this->matrix_products) ) $matrix_data['products'] = $this->matrix_products;

    // Hook to modify the initial matrix variables
    $matrix_data = apply_filters('mla_initial_matrix_data', $matrix_data);

    // Generates the default indirect MLA referrals (based on the Global matrix settings)
    if ( $matrix_data['matrix_level_vars']['total_levels'] >= 1 ) :

      // Loop through the levels
      for ($level = '1'; $level <= $matrix_data['matrix_level_vars']['total_levels']; $level++) :

        if ( isset($matrix_data['matrix_level_affiliates'][$level]) && !empty($matrix_data['matrix_level_affiliates'][$level]) ) :

          $affiliate_id = $matrix_data['matrix_level_affiliates'][$level];

          $referral_filter_vars = array(
            'affiliate_id' => $affiliate_id,
            //'matrix_order_total'  			=> $matrix_data['matrix_order_total'],
            //'products' 						=> ( !empty($matrix_data['products']) ) ? $matrix_data['products'] : array(),
            //'existing_referral_totals' 		=> ( !empty($matrix_data['referrals']) ) ? $matrix_data['referrals'] : array(),
            //'level_variables' 				=> $matrix_data['matrix_level_vars'],
            'level' => $level
          );

          // Hook to modify the base amount (order total)
          $referral_base_amount = apply_filters('mla_referral_base_amount', $matrix_data['matrix_order_total'], $matrix_data, $referral_filter_vars);

          // Check if an affiliate exists on the level
          //if( !empty($affiliate_id) && affwp_is_active_affiliate($affiliate_id) ) :
          if ( !empty($affiliate_id) && apply_filters('mla_referral_is_active_affiliate', affwp_is_active_affiliate($affiliate_id), $referral_filter_vars) ) :

            // Hook to disable the MLA referral
            if ( apply_filters(' mla_award_referral', (bool)TRUE, $referral_filter_vars) ) :

              $referral_amount = AffiliateWP_MLA_Referral::calculate_referral_amount($matrix_data['matrix_level_vars']['type'], $matrix_data['matrix_level_vars']['level_rates'][$level], $referral_base_amount);

              $default_referral_vars = array(
                'rate_type' => $matrix_data['matrix_level_vars']['type'],
                'rate_value' => $matrix_data['matrix_level_vars']['level_rates'][$level],
                'base_amount' => $referral_base_amount
              );

              // Hook to modify the calculated referral amount for the level (based on the Global matrix settings)
              $referral_amount = apply_filters('mla_referral_amount', $referral_amount, $matrix_data, $referral_filter_vars, $default_referral_vars);

              // Add the referral details to the array
              $referral = array(
                'affiliate_id' => $affiliate_id,
                'referral_total' => $referral_amount,
                'log' => array(__('Referral generated by MLA global matrix', 'affiliatewp-multi-level-affiliates') . ': ' . $referral_amount)
              );

              // Backup the original referral
              $matrix_data['default_referrals'][$level] = $referral;

              // Hook to modify the referral array for the level (based on the Global matrix settings)
              // Global per product rates hooked here with priority 15
              $matrix_data['referrals'][$level] = apply_filters('mla_referral', $referral, $matrix_data, $referral_filter_vars, $default_referral_vars);

            endif;

          endif;

        endif;

      endfor;

    endif;

    // Hook to modify the default indirect referrals generated by MLA
    $matrix_data['referrals'] = apply_filters('mla_referrals', $matrix_data['referrals'], $matrix_data);

    // Hook to modify the matrix data (including referrals array) to be saved with parent referral and used for generating the MLA commissions
    // Groups add-on (and Group product rates) hooked here with priority 15
    $matrix_data = apply_filters('mla_matrix_data', $matrix_data);

    // Generate the direct affiliate commission if enabled

    // Recurring
    if ( isset($matrix_data['args']['parent_id']) ) :
      $purchaser_user_id = $this->get_purchaser_from_parent_referral($matrix_data['args']['parent_id']);
    // Initial order
    elseif ( isset($matrix_data['args']['customer']['user_id']) ):
      $purchaser_user_id = $matrix_data['args']['customer']['user_id'];
    endif;

    if ( $purchaser_user_id ) :
      $purchaser_aff_id = affwp_get_affiliate_id($purchaser_user_id);
    endif;

    // Direct bonus
    if ( $purchaser_aff_id ) :

      $direct_affiliate_id = mla_get_direct_id($purchaser_aff_id);

      if ( $direct_affiliate_id ) :

        $direct_group_id = 'default';

        if ( $this->groups_enabled() ) : // replace with filter

          $groups = get_affiliates_active_groups($direct_affiliate_id);
          if ( !empty($groups) ) :
            $direct_group_id = key($groups);

          endif;

        endif;

        $direct_enabled = $this->matrix_setting('enable_direct_referral', $direct_group_id);

        if ( $direct_enabled ) :

          $direct_rate_type = $this->matrix_setting('direct_referral_rate_type', $direct_group_id);
          // Get the AffiliateWP type if required
          if ( $direct_rate_type == 'default' ) $direct_rate_type = affiliate_wp()->settings->get('referral_rate_type');

          $direct_rate_value = $this->matrix_setting('direct_referral_rate', $direct_group_id);

          $referral_amount = AffiliateWP_MLA_Referral::calculate_referral_amount($direct_rate_type, $direct_rate_value, $matrix_data['matrix_order_total']);

          $matrix_data['referrals']['direct_referral'] = array(
            'affiliate_id' => $direct_affiliate_id,
            'referral_total' => $referral_amount,
            'special_referral' => 'direct_referral',
            'reference' => 'Direct Referral'
          );


        endif;

      endif;

    endif;

    // Override all level 1 calculations if MLA disabled on the group or or matrix/group matrix settings
    // Return original referral amount.
    $level1_affiliate_group_id = 'default'; // was $matrix_aff_settings['matrix_setting_id']
    $mla_group_mode = '';

    if ( $this->groups_enabled() ) : // replace with filter

      $groups = get_affiliates_active_groups($affiliate_id);
      if ( !empty($groups) ) :
        $level1_affiliate_group_id = key($groups);
        $mla_group_mode = get_affiliate_group_setting('mla_mode', $level1_affiliate_group_id);
      endif;

    endif;

    if ( $mla_group_mode == 'disabled' || $this->matrix_setting('direct_referral_mode', $level1_affiliate_group_id) != 'mla' ) :
      $matrix_data['referrals']['1']['referral_total'] = $this->matrix_amount;
      $matrix_data['referrals']['1']['log'][] = 'AffiliateWP default returned:' . $this->matrix_amount;
    endif;

    // Team Leaders hooked here with priority 20
    $matrix_data = apply_filters('mla_matrix_data_end', $matrix_data);

    $matrix_data['referrals_total'] = $this->get_commissions_total($matrix_data);

    return $matrix_data;


  }

} // end class

?>