<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

if ( ! class_exists( 'AWL_License_Page' ) ) :

    /**
     * Class for pro plugin license manager
     */
    class AWL_License_Page {

        /**
         * @var AWL_License_Page The single instance of the class
         */
        protected static $_instance = null;

        /**
         * @var AWL_License_Page License key
         */
        private $license_key = false;

        /**
         * Main AWL_License_Page Instance
         *
         * Ensures only one instance of AWL_License_Page is loaded or can be loaded.
         *
         * @static
         * @return AWL_License_Page - Main instance
         */
        public static function instance() {
            if ( is_null( self::$_instance ) ) {
                self::$_instance = new self();
            }
            return self::$_instance;
        }

        /**
         * Constructor
         */
        function __construct() {

            $this->license_key = AWL_PRO()->license->get_license_key();

            add_action( 'admin_init', array( $this, 'admin_init' ) );

            add_action( 'admin_menu', array( $this, 'add_admin_page' ) );

            add_action( 'admin_enqueue_scripts', array( $this, 'admin_enqueue_scripts' ) );

        }

        /*
         * On page init
         */
        public function admin_init() {
            if ( isset( $_GET['awl-ssl'] ) ) {
                add_filter( 'awl_api_request_verify_ssl', '__return_false' );
                delete_transient( 'advanced_woo_labels_pro_info' );
            }
        }

        /*
         * Add options page
         */
        public function add_admin_page() {
            $slug = 'edit.php?post_type=awl-labels';
            add_submenu_page( $slug, esc_html__('Updates','advanced-woo-labels'), esc_html__('Updates','advanced-woo-labels'), 'manage_options', 'awl-options-updates', array( $this,'updates_page' ) );
        }

        /*
         * License page content
         */
        public function updates_page() {

            echo '<div class="wrap">';

                echo '<h1></h1>';
                echo '<h1>' . esc_html__( 'Updates', 'advanced-woo-labels' ) . '</h1>';

                echo '<div class="awl-box-wrap">';

                    do_action( 'awl_updater_page_top' );

                    $this->license_block();

                    $this->info_block();

                echo '</div>';

            echo '</div>';

        }

        /*
         * Block with license info
         */
        private function license_block() {

            $license_key = $this->license_key ? '***********************' : '';
            $valid_class = $this->license_key ? 'valid' : '';
            $deactivate_input = $this->license_key ? ' disabled' : '';

            $btn_html = $this->license_key ?
                '<button id="activate-license" data-is-active="active" class="button button-primary">' . esc_html__( 'Deactivate License', 'advanced-woo-labels' ) . '</button>' :
                '<button id="activate-license" data-is-active="inactive" class="button button-primary">' . esc_html__( 'Activate License', 'advanced-woo-labels' ) . '</button>';


            echo '<div class="awl-box">';

                echo '<div class="title">';
                    echo '<h3>' . esc_html__( 'License Information', 'advanced-woo-labels' ) . '</h3>';
                echo '</div>';

                echo '<div class="inner">';

                    echo '<p>';
                        echo __( 'To unlock updates, please enter your license key below. You can find it inside an email that you receive after the purchase.', 'advanced-woo-labels' ) . '<br>';
                        echo sprintf( esc_html__( 'Also, to manage your account information and license activations please visit %s.', 'advanced-woo-labels' ), '<a target="_blank" href="https://portal.advanced-woo-labels.com/">' . esc_html__( 'user portal', 'advanced-woo-labels' ) . '</a>' );
                        echo '<br>';
                    echo '</p>';

                    echo '<form data-license-form action="" name="awl_form" id="awl_form" method="post" class="'. $valid_class .'">';

                        echo '<table class="form-table">';
                            echo '<tbody>';

                                echo '<tr valign="top">';

                                    echo '<th scope="row">'. esc_html__('License Key', 'advanced-woo-labels' ) . '</th>';

                                    echo '<td>';
                                        echo '<input' . $deactivate_input . ' type="text" name="license_key" class="regular-text" value="'.esc_attr( $license_key ).'">';
                                    echo '</td>';

                                    echo '<td>';
                                        echo '<div class="awl-license-btn-wrap">';
                                            echo $btn_html;
                                            echo '<div class="awl-loader"></div>';
                                        echo '</div>';
                                    echo '</td>';

                                echo '</tr>';

                            echo '</tbody>';
                        echo '</table>';

                        echo '<div class="license-error">' . esc_html__( 'Sorry, your license key is not valid.', 'advanced-woo-labels' ) . '</div>';
                        echo '<div class="license-valid">' . esc_html__( 'Your license key is active.', 'advanced-woo-labels' ) . '</div>';

                    echo '</form>';

                echo '</div>';

            echo '</div>';

        }

        /*
         * Block with plugin info
         */
        private function info_block() {

            $plugin_info = AWL_PRO()->license->updater->get_plugin_info();
            $license_key = $this->license_key ? $this->license_key : '';

            if ( ! $plugin_info ) {
                echo esc_html__( 'Something goes wrong while getting plugin data.', 'advanced-woo-labels' );
                echo '<br><br><a id="change-ssl-check" class="button button-secondary" href="' . admin_url( 'edit.php?post_type=awl-labels&page=awl-options-updates&awl-ssl=true' ) . '">' . esc_html__( 'Try to reconnect', 'advanced-woo-labels' ) . '</a></div>';
                return;
            }

            $plugin_latest_version = $plugin_info->new_version;

            if ( version_compare( AWL_PRO_VERSION, $plugin_latest_version, '<' ) ) {

                if ( $license_key ) {
                    $plugin_update_available = esc_html__( 'Yes', 'advanced-woo-labels' ) . '<a id="update-plugin" class="button button-primary awl-update" href="' . admin_url('plugins.php?s=Advanced+Woo+Labels+Pro') . '">' . esc_html__( 'Update Plugin', 'advanced-woo-labels' ) . '</a><div class="awl-loader"></div>';
                } else {
                    $plugin_update_available = esc_html__( 'Yes', 'advanced-woo-labels' ) . '<a class="button awl-update" disabled="disabled" href="#">' . esc_html__( 'Please enter your license key to unlock updates', 'advanced-woo-labels' ) . '</a>';
                }

                $plugin_changelog = $plugin_info->sections['changelog'];

                if ( $plugin_changelog ) {

                    preg_match( '/(<h4[\S\s]*?)<h4>'.AWL_PRO_VERSION.'.*?<\/h4>/i', $plugin_changelog, $matches );

                    if ( $matches && isset( $matches[1] ) ) {
                        $plugin_changelog = $matches[1];
                    }

                }

            } else {
                $plugin_update_available = esc_html__( 'No', 'advanced-woo-labels' );
                $plugin_changelog ='';
            }


            // Update info
            echo '<div class="awl-box">';

                echo '<div class="title">';
                    echo '<h3>' . esc_html__( 'Update Information', 'advanced-woo-labels' ) . '</h3>';
                echo '</div>';

                echo '<div class="inner">';

                    echo '<table class="form-table">';
                        echo '<tbody>';

                            echo '<tr valign="top">';

                                echo '<th scope="row">'. esc_html__('Refresh', 'advanced-woo-labels' ) . '</th>';

                                echo '<td class="awl-license-btn-wrap">';
                                    echo '<a id="refresh-plugin-info" class="button button-secondary" href="#">' . esc_html__( 'Refresh Plugin Info', 'advanced-woo-labels' ) . '</a><div class="awl-loader"></div>';
                                echo '</td>';

                            echo '</tr>';

                            echo '<tr valign="top">';

                                echo '<th scope="row">'. esc_html__('Current Version', 'advanced-woo-labels' ) . '</th>';

                                echo '<td>';
                                    echo AWL_PRO_VERSION;
                                echo '</td>';

                            echo '</tr>';

                            echo '<tr valign="top">';

                                echo '<th scope="row">'. esc_html__('Latest Version', 'advanced-woo-labels' ) . '</th>';

                                echo '<td>';
                                    echo $plugin_latest_version;
                                echo '</td>';

                            echo '</tr>';

                            echo '<tr valign="top">';

                                echo '<th scope="row">'. esc_html__('Update Available', 'advanced-woo-labels' ) . '</th>';

                                echo '<td class="awl-license-btn-wrap">';
                                    echo $plugin_update_available;
                                echo '</td>';

                            echo '</tr>';

                            echo '<tr valign="top">';

                                echo '<th scope="row">'. esc_html__('Changelog', 'advanced-woo-labels' ) . '</th>';

                                echo '<td>';

                                    echo $plugin_changelog;

                                    echo '<a href="https://advanced-woo-labels.com/guide/premium-version/" target="_blank">' . esc_html__( 'View all changelog', 'advanced-woo-labels' ) . '</a>';

                                echo '</td>';

                            echo '</tr>';

                        echo '</tbody>';
                    echo '</table>';

                echo '</div>';

            echo '</div>';

        }

        /*
         * Enqueue admin scripts and styles
         */
        public function admin_enqueue_scripts() {

            if ( isset( $_GET['page'] ) && $_GET['page'] == 'awl-options-updates' ) {

                wp_enqueue_style( 'plugin-admin-updates-style', AWL_PRO_URL . '/license/assets/css/admin-updates.css' );

                wp_enqueue_script( 'jquery' );

                wp_enqueue_script( 'awl-admin-updates', AWL_PRO_URL . '/license/assets/js/admin-updates.js', array('jquery') );
                wp_localize_script( 'awl-admin-updates', 'awl_vars', array(
                    'ajaxurl'    => admin_url('admin-ajax.php' ),
                    'ajax_nonce' => wp_create_nonce( 'awl_pro_admin_ajax_nonce' ),
                ) );

            }

        }

    }


endif;

add_action( 'init', 'AWL_License_Page::instance' );