<?php

/**
 * Perfect Brands for WooCommerce plugin support
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

if (!class_exists('AWL_Perf_Brands')) :

    /**
     * Class for main plugin functions
     */
    class AWL_Perf_Brands
    {

        /**
         * @var AWL_Perf_Brands The single instance of the class
         */
        protected static $_instance = null;

        /**
         * Main AWL_Perf_Brands Instance
         *
         * Ensures only one instance of AWL_Perf_Brands is loaded or can be loaded.
         *
         * @static
         * @return AWL_Perf_Brands - Main instance
         */
        public static function instance() {
            if (is_null(self::$_instance)) {
                self::$_instance = new self();
            }
            return self::$_instance;
        }

        /*
         * Constructor
         */
        public function __construct() {

            add_filter( 'awl_labels_text_vars', array( $this, 'labels_text_vars' ), 1 );

        }

        /*
         * Add new text variables
         */
        public function labels_text_vars( $variables ) {

            $variable['/{PBRANDS_NAME}/i'] = array(
                'func' => array( $this, 'brand_name' ),
                'desc' => __( "Perfect Brands brand name", "advanced-woo-labels" ),
                'example' => '{PBRANDS_NAME}',
            );

            $variable['/{PBRANDS_LOGO}/i'] = array(
                'func' => array( $this, 'brand_logo' ),
                'desc' => __( "Perfect Brands brand logo image", "advanced-woo-labels" ),
                'example' => '{PBRANDS_LOGO}',
            );

            $variable['/{PBRANDS_BANNER}/i'] = array(
                'func' => array( $this, 'brand_banner' ),
                'desc' => __( "Perfect Brands brand banner image", "advanced-woo-labels" ),
                'example' => '{PBRANDS_BANNER}',
            );

            $variable['/{PBRANDS_LINK}/i'] = array(
                'func' => array( $this, 'brand_link' ),
                'desc' => __( "Perfect Brands brand link to archive page", "advanced-woo-labels" ),
                'example' => '{PBRANDS_LINK}',
            );

            $variable['/{PBRANDS_BANNER_LINK}/i'] = array(
                'func' => array( $this, 'brand_banner_link' ),
                'desc' => __( "Perfect Brands brand banner link", "advanced-woo-labels" ),
                'example' => '{PBRANDS_BANNER_LINK}',
            );

            $variables = array_merge( $variable, $variables );

            return $variables;

        }

        /*
         * Text variable: Brand name
         */
        public function brand_name( $matches ) {
            global $product;
            $name = '';
            $term = $this->get_brand_term( $product );
            if ( $term ) {
                $name = $term->name;
            }
            return $name;
        }

        /*
         * Text variable: Brand logo
         */
        public function brand_logo( $matches ) {
            global $product;
            $logo = '';
            $term = $this->get_brand_term( $product );
            if ( $term ) {
                $thumb_id = get_term_meta( $term->term_id, 'pwb_brand_image', 1 );
                if ( $thumb_id ) {
                    $thumb_src = wp_get_attachment_image_src( $thumb_id, 'thumbnail' );
                    if ( $thumb_src ) {
                        $logo = '<img style="max-width:50px;" src="' . $thumb_src[0] . '" />';
                    }
                }
            }
            return $logo;
        }

        /*
         * Text variable: Brand banner
         */
        public function brand_banner( $matches ) {
            global $product;
            $banner = '';
            $term = $this->get_brand_term( $product );
            if ( $term ) {
                $thumb_id = get_term_meta( $term->term_id, 'pwb_brand_banner', 1 );
                if ( $thumb_id ) {
                    $thumb_src = wp_get_attachment_image_src( $thumb_id, 'thumbnail' );
                    if ( $thumb_src ) {
                        $banner = '<img style="max-width:50px;" src="' . $thumb_src[0] . '" />';
                    }
                }
            }
            return $banner;
        }

        /*
         * Text variable: Brand link
         */
        public function brand_link( $matches ) {
            global $product;
            $link = '';
            $term = $this->get_brand_term( $product );
            if ( $term ) {
                $link = get_term_link( $term );
            }
            return $link;
        }

        /*
         * Text variable: Brand banner link
         */
        public function brand_banner_link( $matches ) {
            global $product;
            $link = '';
            $term = $this->get_brand_term( $product );
            if ( $term ) {
                $link = get_term_meta( $term->term_id, 'pwb_brand_banner_link', 1 );
            }
            return $link;
        }

        /*
         * Get brand term for current product
         */
        private function get_brand_term( $product ) {
            $term = false;
            $product_id = $product->is_type( 'variation' ) && method_exists( $product, 'get_parent_id' ) ? $product->get_parent_id() : $product->get_id();
            $terms = wp_get_object_terms( $product_id, 'pwb-brand' );
            if ( ! is_wp_error( $terms ) && ! empty( $terms ) ) {
                $term = $terms[0];
            }
            return $term;
        }

    }

endif;

AWL_Perf_Brands::instance();