jQuery(document).ready(function ($) {
    'use strict';

    // Label preview

    var settingsTable = $('.awl-label-settings');
    var previewBox = $('#awl-preview');
    var previewLabelContainer = $('#awl-preview .advanced-woo-labels');
    var previewLabel = previewLabelContainer.find('.awl-product-label');
    var previewLabelBefore = previewLabel.find('.awl-label-before');
    var previewLabelAfter = previewLabel.find('.awl-label-after');
    var labelSvg = previewLabel.find('svg');
    var labelSvgLine = labelSvg.find('.d-stroke');
    var previewLabelShadow = previewLabelContainer.find('.awl-shadow');
    var previewLabelTextContainer = previewLabelContainer.find('.awl-label-text');
    var previewLabelText = previewLabelContainer.find('.awl-inner-text');
    var previewLabelImage = previewLabelContainer.find('.awl-label-image img');

    var customStylesCheckbox = $('#awl-label-params-settings-custom-styles');

    var inputLabelType = $('#awl-label-params-settings-type');
    var inputLabelText = $('#awl-label-params-settings-text');
    var inputLabelPositionType = $('#awl-label-params-settings-position-type');
    var inputLabelPosition = $('#awl-label-params-settings-position');
    var inputLabelPositionX = $('#awl-label-params-settings-position-x');
    var inputLabelTemplate = $('#awl-label-params-settings-template');
    var inputLabelBgColor = $('#awl-label-params-settings-bg-color');
    var inputLabelTextColor = $('#awl-label-params-settings-text-color');
    var inputLabelFontSize = $('#awl-label-params-settings-font-size');
    var inputLabelFontStyle = $('#awl-label-params-settings-font-style');
    var inputLabelFontWeight = $('#awl-label-params-settings-font-weight');
    var inputLabelLetterSpacing = $('#awl-label-params-settings-letter-spacing');
    var inputLabelShadow = $('#awl-label-params-settings-shadow');
    var inputLabelBorder = $('#awl-label-params-settings-border');
    var inputLabelBorderColor = $('#awl-label-params-settings-border-color');
    var inputLabelOpacity = $('#awl-label-params-settings-opacity');
    var inputLabelPaddingTop = $('#awl-label-params-settings-padding-top');
    var inputLabelPaddingRight = $('#awl-label-params-settings-padding-right');
    var inputLabelPaddingBottom = $('#awl-label-params-settings-padding-bottom');
    var inputLabelPaddingLeft = $('#awl-label-params-settings-padding-left');
    var inputLabelMarginTop = $('#awl-label-params-settings-margin-top');
    var inputLabelMarginRight = $('#awl-label-params-settings-margin-right');
    var inputLabelMarginBottom = $('#awl-label-params-settings-margin-bottom');
    var inputLabelMarginLeft = $('#awl-label-params-settings-margin-left');
    var inputLabelSize = $('#awl-label-params-settings-label-size');
    var inputLabelCustomCss = $('#awl-label-params-settings-custom-css');

    var firstInit = true;


    var variables = {
        '{REGULAR_PRICE}' : '$100',
        '{PRICE}' : '$90',
        '{SALE_PRICE}': '$90',
        '{SAVE_PERCENT\\s*\\|*\\s*([\\d]*)\\s*}': '10',
        '{SAVE_AMOUNT\\s*\\|*\\s*([\\d]*)\\s*}': '10',
        '{SALE_ENDS}': '7',
        '{SYMBOL}': '$',
        '{SKU}': 'AA564',
        '{QTY}': 99,
        '{SALES_NUM\\s*\\|*\\s*([\\d]*)\\s*}' : 26,
        '{REVIEWS_NUM\\s*\\|*\\s*([\\d]*)\\s*}' : 17,
        '{RATING\\s*\\|*\\s*([\\d]*)\\s*}' : 4.73,
        '{ATTR\\:([\\w]+)\\s*}' : 'white, blue',
        '{TAX\\:([\\w]+)\\s*}' : 'Category',
        '{META\\:([\\w]+)\\s*}' : 'some meta',
        '{BR}' : '<br>'
    };


    // on load
    // on label type change
    // on custom styles checkbox change
    function rebuildPreview() {

        previewBox.addClass('awl-rebuild');

        previewLabelContainer.removeAttr( 'style' );
        previewLabel.removeAttr( 'style' );
        previewLabelTextContainer.removeAttr( 'style' );
        previewLabelText.removeAttr( 'style' );
        previewLabelImage.removeAttr( 'style' );
        labelSvg.removeAttr( 'style' );
        labelSvgLine.removeAttr( 'style' );
        previewLabelShadow.removeAttr( 'style' );
        previewBox.find('#awl-css').remove();

        window.setTimeout(function(){
            if ( ! firstInit ) {
                $('#awl_label_settings [data-section="styles"], #awl_label_settings [data-option-id="position"]:visible, #awl_label_settings [data-option-id="position_x"]:visible').find('td:visible input, td:visible select, td:visible textarea').trigger('change').trigger('keyup');
            } else {
                $('#awl_label_settings').find('td:visible input:not(#awl-label-params-settings-custom-styles), td:visible select:not(#awl-label-params-settings-type), td:visible textarea').trigger('change').trigger('keyup');
            }
            previewBox.removeClass('awl-rebuild');
            firstInit = false;
        }, 600);

        window.setTimeout(function(){
            settingsTable.removeClass('awl-first-init');
        }, 2000);

    }

    rebuildPreview();

    customStylesCheckbox.on( 'change', function(e) {
        if ( ! firstInit ) {
            rebuildPreview();
        }
    });

    inputLabelType.on( 'change', function(e) {
        if ( ! firstInit ) {
            rebuildPreview();
        }
    });

    function replaceAll( str, find ) {
        return str.replace(new RegExp(find, 'g'), function(match, p1, p2){
            if ( p1 && match.indexOf('{RATING') !== -1 ) {
                return variables[find].toFixed(p1);
            }
            return variables[find];
        });
    }

    inputLabelText.on( 'keyup input', function(e) {

        var text = $(this).val();

        $.each(variables, function (name, value) {
            text = replaceAll( text, name );
        });

        var html_entities = {
            '\<script\>' : '',
            '\<\/script\>' : '',
        };

        $.each(html_entities, function (name, value) {
            text = text.replace(new RegExp(name, "g"), value);
        });

        previewLabelText.html( text );

    });


    inputLabelPositionType.on( 'change', function(e) {

        var label = $('.advanced-woo-labels');
        var typeClass = '';

        switch ( $(this).val() ) {
            case 'on_image':
                label.prependTo("#awl-preview .image-wrapper");
                typeClass = 'awl-position-type-image';
                break;
            case 'before_title':
                $( "#awl-preview .product-name" ).before( label );
                typeClass = 'awl-position-type-before-title';
                break;
        }

        previewLabelContainer[0].className = previewLabelContainer[0].className.replace( /(awl-position-type-[a-z-]+)/gi , '' );
        previewLabelContainer.addClass(typeClass);

        if ( typeClass === 'awl-position-type-image' ) {
            inputLabelPosition.trigger('change');
        } else {
            inputLabelPositionX.trigger('change');
        }

    });


    inputLabelTemplate.on( 'change', function(e) {
        var label = '';

        switch ( $(this).val() ) {
            case 'standard':
                label = 'awl-type-label';
                break;
            case 'rounded':
                label = 'awl-type-label awl-type-label-rounded';
                break;
            case 'round':
                label = 'awl-type-label awl-type-label-round';
                break;
            case 'triangled':
                label = 'awl-type-label awl-type-label-triangle';
                break;
            case 'triangled-left':
                label = 'awl-type-label awl-type-label-triangle-left';
                break;
            case 'angle':
                label = 'awl-type-label awl-type-label-right-angle';
                break;
            case 'angle-left':
                label = 'awl-type-label awl-type-label-angle-left';
                break;
            case 'two-angles':
                label = 'awl-type-label awl-type-label-two-angles';
                break;
            case 'arrow':
                label = 'awl-type-label awl-type-label-arrow';
                break;
            case 'arrow-reverse':
                label = 'awl-type-label awl-type-label-arrow-reverse';
                break;
            case 'triangled-reverse':
                label = 'awl-type-label awl-type-label-triangle-reverse';
                break;
            case 'triangled-reverse-left':
                label = 'awl-type-label awl-type-label-triangle-reverse-left';
                break;
            default:
                label = 'awl-type-image';
        }

        previewLabel[0].className = previewLabel[0].className.replace( /(awl-type-[a-z-]+)/gi , '' );
        previewLabel.addClass(label);

        if ( label === 'awl-type-image' ) {

            var imageUrl = $(this).val();
            // not uploaded image
            if ( imageUrl.indexOf("image-") === 0 ) {
                imageUrl = awl_vars.img_url + imageUrl + '.png';
            }

            previewLabel.find('.awl-label-image img').attr( 'src', imageUrl );

        } else {

            inputLabelText.trigger('keyup');

            if ( inputLabelBorder.is( ":visible" ) ) {
                inputLabelBorder.trigger('change');
            }

        }

    });

    inputLabelPosition.on( 'change', function(e) {
        var style;

        switch ( this.value ) {
            case 'left_top':
                style = { "left" : "0", "top" : "0", "right" : "auto", "bottom" : "auto", "transform" : "none", "justify-content" : "flex-start" };
                break;
            case 'center_top':
                style = { "left" : "0", "top" : "0", "right" : "auto", "bottom" : "auto", "transform" : "none", "justify-content" : "center" };
                break;
            case 'right_top':
                style = { "left" : "0", "top" : "0", "right" : "auto", "bottom" : "auto", "transform" : "none", "justify-content" : "flex-end" };
                break;
            case 'left_center':
                style = { "left" : "0", "top" : "50%", "right" : "auto", "bottom" : "auto", "transform" : "translateY(-50%)", "justify-content" : "flex-start" };
                break;
            case 'center_center':
                style = { "left" : "0", "top" : "50%", "right" : "auto", "bottom" : "auto", "transform" : "translateY(-50%)", "justify-content" : "center"  };
                break;
            case 'right_center':
                style = { "left" : "0", "top" : "50%", "right" : "auto", "bottom" : "auto", "transform" : "translateY(-50%)", "justify-content" : "flex-end" };
                break;
            case 'left_bottom':
                style = { "left" : "0", "right" : "auto", "top" : "auto", "bottom" : "0", "transform" : "none", "justify-content" : "flex-start" };
                break;
            case 'center_bottom':
                style = { "left" : "0", "right" : "auto", "top" : "auto", "bottom" : "0", "transform" : "none", "justify-content" : "center" };
                break;
            case 'right_bottom':
                style = { "left" : "0", "right" : "auto", "top" : "auto", "bottom" : "0", "transform" : "none", "justify-content" : "flex-end" };
                break;
        }

        previewLabelContainer.css( style );

    });

    inputLabelPositionX.on( 'change', function(e) {
        var style;

        switch ( this.value ) {
            case 'left':
                style = { "left" : "0", "top" : "0", "right" : "auto", "bottom" : "auto", "transform" : "none", "justify-content" : "flex-start"  };
                break;
            case 'center':
                style = { "left" : "0", "top" : "0", "right" : "auto", "bottom" : "auto", "transform" : "none", "justify-content" : "center"  };
                break;
            case 'right':
                style = { "left" : "0", "top" : "0", "right" : "auto", "bottom" : "auto", "transform" : "none", "justify-content" : "flex-end"  };
                break;
        }

        previewLabelContainer.css( style );

    });

    inputLabelBgColor.on( 'change', function(e) {
        previewLabelTextContainer.css( 'background-color', $(this).val() );
        labelSvg.css( 'fill', $(this).val() );
    });

    inputLabelTextColor.on( 'change', function(e) {
        previewLabel.css( 'color', $(this).val() );
    });

    inputLabelFontSize.on( 'keyup input', function(e) {
        previewLabel.css( 'font-size', $(this).val() + 'px' );
    });

    inputLabelFontStyle.on( 'change', function(e) {
        previewLabel.css( 'font-style', $(this).val() );
    });

    inputLabelLetterSpacing.on( 'keyup input', function(e) {
        previewLabel.css( 'letter-spacing', $(this).val() + 'px' );
    });

    inputLabelFontWeight.on( 'change', function(e) {
        previewLabel.css( 'font-weight', $(this).val() );
    });

    inputLabelShadow.on( 'change', function(e) {
        var style = '';
        var svgStyle = '';

        switch ( this.value ) {
            case 'none':
                style = 'none';
                break;
            case 'small':
                style = '0 1px 2px 0px rgba(0, 0, 0, 0.3)';
                svgStyle = 'drop-shadow(rgba(0, 0, 0, 0.3) 0px 1px 2px)';
                break;
            case 'medium':
                style = '0 2px 4px 0px rgba(0, 0, 0, 0.3)';
                svgStyle = 'drop-shadow(rgba(0, 0, 0, 0.3) 0px 2px 2px)';
                break;
            case 'large':
                style = '0 4px 6px -1px rgba(0, 0, 0, 0.3)';
                svgStyle = 'drop-shadow(rgba(0, 0, 0, 0.3) 0px 3px 2px)';
                break;
        }

        previewLabelShadow.css( 'box-shadow', style );
        labelSvg.css( 'filter', svgStyle );

    });

    inputLabelBorder.on( 'change', function(e) {
        var width = 0;

        switch ( this.value ) {
            case 'none':
                width = 0;
                break;
            case 'small':
                width = 1;
                break;
            case 'medium':
                width = 2;
                break;
            case 'large':
                width = 3;
                break;
        }

        previewLabelTextContainer.css( 'border-top-width', width + 'px' );
        previewLabelTextContainer.css( 'border-bottom-width', width + 'px' );
        previewLabelTextContainer.css( 'border-style', 'solid' );
        previewLabelTextContainer.css( 'border-color', inputLabelBorderColor.val() );
        labelSvg.css( 'stroke-width', width );
        labelSvgLine.css( 'stroke-width', width * 2 );
        labelSvg.css( 'stroke', inputLabelBorderColor.val() );

        if ( previewLabelBefore.is(":hidden") ) {
            previewLabelTextContainer.css( 'border-left-width', width + 'px' );
        } else {
            previewLabelTextContainer.css( 'border-left-width', '0' );
        }

        if ( previewLabelAfter.is(":hidden") ) {
            previewLabelTextContainer.css( 'border-right-width', width + 'px' );
        } else {
            previewLabelTextContainer.css( 'border-right-width', '0' );
        }

    });

    inputLabelBorderColor.on( 'change', function(e) {
        previewLabelTextContainer.css( 'border-color', $(this).val() );
        labelSvg.css( 'stroke', $(this).val() );
    });

    inputLabelPaddingTop.on( 'keyup input', function(e) {
        previewLabelTextContainer.css( 'padding-top', $(this).val()+'em' );
    });

    inputLabelPaddingRight.on( 'keyup input', function(e) {
        previewLabelTextContainer.css( 'padding-right', $(this).val()+'em' );
    });

    inputLabelPaddingBottom.on( 'keyup input', function(e) {
        previewLabelTextContainer.css( 'padding-bottom', $(this).val()+'em' );
    });

    inputLabelPaddingLeft.on( 'keyup input', function(e) {
        previewLabelTextContainer.css( 'padding-left', $(this).val()+'em' );
    });

    inputLabelMarginTop.on( 'keyup input', function(e) {
        previewLabel.css( 'margin-top', $(this).val()+'px' );
    });

    inputLabelMarginRight.on( 'keyup input', function(e) {
        previewLabel.css( 'margin-right', $(this).val()+'px' );
    });

    inputLabelMarginBottom.on( 'keyup input', function(e) {
        previewLabel.css( 'margin-bottom', $(this).val()+'px' );
    });

    inputLabelMarginLeft.on( 'keyup input', function(e) {
        previewLabel.css( 'margin-left', $(this).val()+'px' );
    });

    inputLabelOpacity.on( 'keyup input', function(e) {
        previewLabel.css( 'opacity', $(this).val() );
    });

    inputLabelSize.on( 'keyup input', function(e) {
        previewLabelImage.css( 'width', $(this).val()+'px' );
    });

    inputLabelCustomCss.on( 'keyup input', function(e) {

        var css = $(this).val();
        var cssBox = $('#awl-css');

        if ( cssBox.length > 0 ) {
            cssBox.text( css );
        } else {
            previewLabelContainer.before( $('<style id="awl-css">'+css+'</style>') );
        }

    });

});