<?php
/*
 * Plugin Name: Easy Social Share Buttons for WordPress Addon - Opt-in Booster
 * Plugin URI: http://codecanyon.net/item/easy-social-share-buttons-for-wordpress/6394476?ref=appscreo
 * Description: Display opt-in forms on exit intend, on scroll, on inactivity or other user defined options and boost your mail subscribers
 * Version: 1.0 
 * Author: CreoApps 
 * Author URI: http://codecanyon.net/user/appscreo/portfolio?ref=appscreo
 */

if (! defined ( 'WPINC' ))
	die ();

define ( 'ESSB3_OFOB_VERSION', '1.0' );
define ( 'ESSB3_OFOB_PLUGIN_ROOT', dirname ( __FILE__ ) . '/' );
define ( 'ESSB3_OFOB_PLUGIN_URL', plugins_url () . '/' . basename ( dirname ( __FILE__ ) ) );
define ( 'ESSB3_OFOB_PLUGIN_BASE_NAME', plugin_basename ( __FILE__ ) );
define ( 'ESSB3_OFOB_OPTIONS_NAME', 'essb3-ofob' );

global $essb3ofob_options;

class ESSBAddonOptinFormsBooster {
	private static $_instance;
	private $version = "1.0";
	
	function __construct() {
		
		global $essb3ofob_options;
		
		$essb3ofob_options = get_option ( ESSB3_OFOB_OPTIONS_NAME );
				
		$this->init();
		
		if ($this->option_bool_value('ofob_time') || $this->option_bool_value('ofob_scroll') || $this->option_bool_value('ofob_exit')) {
			add_action ( 'wp_footer', array(&$this, 'draw_forms'), 100);
			add_action('init', array(&$this, 'load_assets'), 99);
				
		}
		
		
	}
	
	public function load_assets() {
		if (function_exists('essb_resource_builder')) {
			essb_resource_builder()->add_static_resource(ESSB3_OFOB_PLUGIN_URL . '/assets/essb-optin-booster.css', 'essb-optin-booster', 'css');
			essb_resource_builder()->add_static_resource_footer(ESSB3_OFOB_PLUGIN_URL . '/assets/essb-optin-booster.js', 'essb-optin-booster', 'js');
		}
	}
	
	public function option_value($param) {
		global $essb3ofob_options;
		
		$value = isset($essb3ofob_options[$param]) ? $essb3ofob_options[$param] : '';
		
		return $value;
	}
	
	public function option_bool_value($param) {
		global $essb3ofob_options;
		
		$value = isset($essb3ofob_options[$param]) ? $essb3ofob_options[$param] : '';
		
		if ($value == 'true') {
			return true;
		}
		else {
			return false;
		}
	}
	
	/**
	 * Get static instance of class
	 *
	 * @return ESSB_Manager
	 */
	public static function getInstance() {
		if (! (self::$_instance instanceof self)) {
			self::$_instance = new self ();
		}
		
		return self::$_instance;
	}
	
	/**
	 * Cloning disabled
	 */
	private function __clone() {
	}
	
	/**
	 * Serialization disabled
	 */
	private function __sleep() {
	}
	
	/**
	 * De-serialization disabled
	 */
	private function __wakeup() {
	}
	
	public function handle_save_settings() {
		if (@$_POST && isset ( $_POST ['option_page'] )) {
			$changed = false;
			if ('essbofob_settings_group' == $this->getval ( $_POST, 'option_page' )) {
				$this->update_options ();
				$changed = true;
					
			}
			if ($changed) {
				$user_section = isset ( $_REQUEST ['section'] ) ? $_REQUEST ['section'] : '';
				$user_subsection = isset ( $_REQUEST ['subsection'] ) ? $_REQUEST ['subsection'] : '';
	
				// $goback = add_query_arg ( 'settings-updated', 'true',
				// wp_get_referer () );
				$goback = esc_url_raw ( add_query_arg ( array ('settings-updated' => 'true', 'section' => $user_section, 'subsection' => $user_subsection ), wp_get_referer () ) );
				// $goback = str_replace('#038;', '', $goback);
				wp_redirect ( $goback );
				die ();
			}
		}
	
	}
		
	public function update_options() {
		global $essbofob_options_structure;
	
		$tabs = $essbofob_options_structure->tabs;
		$sidebar_sections = $essbofob_options_structure->sidebar_sections;
		$sidebar_section_options = $essbofob_options_structure->sidebar_section_options;
	
		$current_options = get_option ( ESSB3_OFOB_OPTIONS_NAME );
		if (! is_array ( $current_options )) {
			$current_options = array ();
		}
	
		$current_tab = isset ( $_REQUEST ['tab'] ) ? $_REQUEST ['tab'] : '';
		$user_options = isset ( $_REQUEST ['essb_options'] ) ? $_REQUEST ['essb_options'] : array ();
	
		$reset_settings = isset ( $_REQUEST ['reset_settings'] ) ? $_REQUEST ['reset_settings'] : '';
	
		// print_r($user_options);
	
		if ($current_tab == '') {
			return;
		}
	
		$options = $sidebar_section_options [$current_tab];
	
		foreach ( $options as $section => $fields ) {
			$section_options = $fields;
				
			foreach ( $section_options as $option ) {
				$type = $option ['type'];
				$id = isset ( $option ['id'] ) ? $option ['id'] : '';
	
				if ($id == '') {
					continue;
				}
	
				switch ($type) {
					case "checkbox_list_sortable" :
						$option_value = isset ( $user_options [$id] ) ? $user_options [$id] : '';
						$current_options [$id] = $option_value;
	
						$option_value = isset ( $user_options [$id . '_order'] ) ? $user_options [$id . '_order'] : '';
						$current_options [$id . '_order'] = $option_value;
						break;
					default :
						$option_value = isset ( $user_options [$id] ) ? $user_options [$id] : '';
						$current_options [$id] = $option_value;
	
						break;
				}
			}
		}
	
		$current_options = $this->clean_blank_values ( $current_options );
	
		
		update_option ( ESSB3_OFOB_OPTIONS_NAME, $current_options );
	
	}
	
	function clean_blank_values($object) {
		foreach ( $object as $key => $value ) {
			if (! is_array ( $value )) {
				$value = trim ( $value );
	
				if (empty ( $value )) {
					unset ( $object [$key] );
				}
			} else {
				if (count ( $value ) == 0) {
					unset ( $object [$key] );
				}
			}
		}
	
		return $object;
	}
		
	public function init() {
		
		
		if (is_admin()) {
			include_once (ESSB3_OFOB_PLUGIN_ROOT . 'lib/essbofob-admin.php');
			add_action ( 'admin_menu', array ($this, 'register_menu' ), 99 );
			
			$hook = (defined ( 'WP_NETWORK_ADMIN' ) && WP_NETWORK_ADMIN) ? 'network_admin_menu' : 'admin_menu';
			add_action ( $hook, array ($this, 'handle_save_settings' ) );
			
			add_action( 'admin_enqueue_scripts', array( $this, 'admin_enqueue_scripts' ) );
		}
	}
	
	public function admin_enqueue_scripts() {
		$page = isset($_REQUEST['page']) ? $_REQUEST['page'] : '';
		
		if ($page == 'essb_of' || $page == 'essb_ofob') {
			wp_enqueue_script( 'wp-color-picker-alpha', plugins_url( 'assets/wp-color-picker-alpha.js', __FILE__ ), array( 'wp-color-picker' ), time() );
		}
	}
	
	public function register_menu() {
		global $essb_options;
	
		$menu_pos = false;
		$essb_access = "edit_pages";
			
		add_submenu_page ( 'essb_options', __ ( 'Opt-in Booster', 'easy-optin-booster' ), '' . __ ( '[Addon] Opt-in Booster', 'easy-optin-booster' ) . '', $essb_access, 'essb_ofob', array ($this, 'essb_ofob_settings_redirect' ) );
	}

	function essb_ofob_settings_redirect() {
		include_once (ESSB3_OFOB_PLUGIN_ROOT . 'lib/admin/essbofob-settings.php');
	}
		
	
	function getval($from, $what, $default = false) {
		if (is_object ( $from ) && isset ( $from->$what ))
			return $from->$what;
		else if (is_array ( $from ) && isset ( $from [$what] ))
			return $from [$what];
		else
			return $default;
	}
	
	public function draw_forms() {
		$ofob_single = $this->option_bool_value('ofob_single');
		$ofob_creditlink = $this->option_bool_value('ofob_creditlink');
		
		if ($this->option_bool_value('ofob_time')) {
			$ofob_time_delay = $this->option_value('ofob_time_delay');
			$of_time_design = $this->option_value('of_time_design');
			$of_time_bgcolor = $this->option_value('of_time_bgcolor');
			
			if ($ofob_time_delay != '') {
				$callback = ' data-delay="'.$ofob_time_delay.'" data-single="'.$ofob_single.'"';
				$this->draw_form_code('time', $of_time_design, $of_time_bgcolor, $callback, $ofob_creditlink);
			}
		}
		
		if ($this->option_bool_value('ofob_scroll')) {
			$ofob_scroll_percent = $this->option_value('ofob_scroll_percent');
			$of_scroll_design = $this->option_value('of_scroll_design');
			$of_scroll_bgcolor = $this->option_value('of_scroll_bgcolor');
				
			if ($ofob_scroll_percent != '') {
				$callback = ' data-scroll="'.$ofob_scroll_percent.'" data-single="'.$ofob_single.'"';
				$this->draw_form_code('scroll', $of_scroll_design, $of_scroll_bgcolor, $callback, $ofob_creditlink);
			}
		}
		
		if ($this->option_bool_value('ofob_exit')) {			
			$of_exit_design = $this->option_value('of_exit_design');
			$of_exit_bgcolor = $this->option_value('of_exit_bgcolor');				
			$callback = ' data-exit="1" data-single="'.$ofob_single.'"';
			$this->draw_form_code('exit', $of_exit_design, $of_exit_bgcolor, $callback, $ofob_creditlink);
				
		}
	}
	
	public function draw_form_code($event = '', $design = '', $overlay_color = '', $event_fire = '', $credit_link = false) {
		$output = '';
		
		$affiliate_user = $this->option_value('ofob_creditlink_user');
		if ($affiliate_user == '') {
			$affiliate_user = 'appscreo';
		}
		
		$close_type = $this->option_value('of_'.$event.'_close');
		$close_color = $this->option_value('of_'.$event.'_closecolor');
		$close_text = $this->option_value('of_'.$event.'_closetext');
		
		$css_color = '';
		if ($close_color != '') {
			$css_color = ' style="color:'.$close_color.'!important;"';
		}
		
		if ($close_type == '') {
			$close_type = 'icon';
		}
		
		if ($close_text == '') {
			$close_text = __("No thanks. I don't want.");
		}
		
		$output .= '<div class="essb-optinbooster essb-optinbooster-'.$event.'" '.$event_fire.'>';
		
		if ($close_type == 'icon') {
			$output .= '<div class="essb-optinbooster-close essb-optinbooster-closeicon" '.$css_color.'><i class="essb_icon_close"></i></div>';
		}
		
		$output .= do_shortcode('[easy-subscribe design="'.$design.'" mode="mailchimp"]');
		if ($close_type != 'icon') {
			$output .= '<div class="essb-optinbooster-close essb-optinbooster-closetext" '.$css_color.'>'.$close_text.'</div>';
		}
		
		$output .= '</div>';
		$output .= '<div class="essb-optinbooster-overlay essb-optinbooster-overlay-'.$event.'"'.($overlay_color != '' ? ' style="background-color:'.$overlay_color.'!important;"' : '').'>';
		if ($credit_link) {
			$output .= '<div class="promo">Powered by <a href="http://codecanyon.net/item/easy-social-share-buttons-for-wordpress/6394476?ref='.$affiliate_user.'" target="_blank">Best Social Sharing Plugin for WordPress</a> Easy Social Share Buttons</div>';
		}
		
		$output .= '</div>';
		
		echo $output;
	}
}

/**
 * main code *
 */
global $essb_ofob;
function essb_optin_forms_booster() {
	global $essb_ofob;
	
	if (! isset ( $essb_ofob )) {
		$essb_ofob = ESSBAddonOptinFormsBooster::getInstance ();
	}
}

add_action ( 'init', 'essb_optin_forms_booster', 9 );