<?php
/*
 * Plugin Name: Easy Social Share Buttons for WordPress Addon - Social A/B
 * Plugin URI: http://codecanyon.net/item/easy-social-share-buttons-for-wordpress/6394476?ref=appscreo
 * Description: Easy create and run A/B test of social share buttons configuration and choose the best setting for your site 
 * Version: 1.0 
 * Author: CreoApps 
 * Author URI: http://codecanyon.net/user/appscreo/portfolio?ref=appscreo
 */

if (! defined ( 'WPINC' ))
	die ();

define ( 'ESSB3_AB_VERSION', '1.0' );
define ( 'ESSB3_AB_PLUGIN_ROOT', dirname ( __FILE__ ) . '/' );
define ( 'ESSB3_AB_PLUGIN_URL', plugins_url () . '/' . basename ( dirname ( __FILE__ ) ) );
define ( 'ESSB3_AB_PLUGIN_BASE_NAME', plugin_basename ( __FILE__ ) );
define ( 'ESSB3_AB_OPTIONS_NAME', 'essb3-ab' );
define ( 'ESSB3_AB_STAT_NAME', 'essb3-ab-stat' );

global $essb3ab_options, $essbab_used;

class ESSBAddonSocialAB {
	private static $_instance;
	private $version = "1.0";
	
	function __construct() {
		
		global $essb3ab_options;
		
		
		$essb3ab_options = get_option ( ESSB3_AB_OPTIONS_NAME );
		
		$this->init();
	}
	
	/**
	 * Get static instance of class
	 *
	 * @return ESSB_Manager
	 */
	public static function getInstance() {
		if (! (self::$_instance instanceof self)) {
			self::$_instance = new self ();
		}
		
		return self::$_instance;
	}
	
	/**
	 * Cloning disabled
	 */
	private function __clone() {
	}
	
	/**
	 * Serialization disabled
	 */
	private function __sleep() {
	}
	
	/**
	 * De-serialization disabled
	 */
	private function __wakeup() {
	}
	
	public function handle_save_settings() {
		if (@$_POST && isset ( $_POST ['option_page'] )) {
			$changed = false;
			if ('essbab_settings_group' == $this->getval ( $_POST, 'option_page' )) {
				$this->update_options ();
				$changed = true;
					
			}
			if ($changed) {
				$user_section = isset ( $_REQUEST ['section'] ) ? $_REQUEST ['section'] : '';
				$user_subsection = isset ( $_REQUEST ['subsection'] ) ? $_REQUEST ['subsection'] : '';
	
				// $goback = add_query_arg ( 'settings-updated', 'true',
				// wp_get_referer () );
				$goback = esc_url_raw ( add_query_arg ( array ('settings-updated' => 'true', 'section' => $user_section, 'subsection' => $user_subsection ), wp_get_referer () ) );
				// $goback = str_replace('#038;', '', $goback);
				wp_redirect ( $goback );
				die ();
			}
		}
	
	}
	
	public function update_options() {
		global $essbab_options_structure;
	
		$tabs = $essbab_options_structure->tabs;
		$sidebar_sections = $essbab_options_structure->sidebar_sections;
		$sidebar_section_options = $essbab_options_structure->sidebar_section_options;
	
		$current_options = get_option ( ESSB3_AB_OPTIONS_NAME );
		if (! is_array ( $current_options )) {
			$current_options = array ();
		}
	
		$current_tab = isset ( $_REQUEST ['tab'] ) ? $_REQUEST ['tab'] : '';
		$user_options = isset ( $_REQUEST ['essb_options'] ) ? $_REQUEST ['essb_options'] : array ();
	
		$reset_settings = isset ( $_REQUEST ['reset_settings'] ) ? $_REQUEST ['reset_settings'] : '';
	
		// print_r($user_options);
	
		if ($current_tab == '') {
			return;
		}
	
		$options = $sidebar_section_options [$current_tab];
	
		foreach ( $options as $section => $fields ) {
			$section_options = $fields;
				
			foreach ( $section_options as $option ) {
				$type = $option ['type'];
				$id = isset ( $option ['id'] ) ? $option ['id'] : '';
	
				if ($id == '') {
					continue;
				}
	
				switch ($type) {
					case "checkbox_list_sortable" :
						$option_value = isset ( $user_options [$id] ) ? $user_options [$id] : '';
						$current_options [$id] = $option_value;
	
						$option_value = isset ( $user_options [$id . '_order'] ) ? $user_options [$id . '_order'] : '';
						$current_options [$id . '_order'] = $option_value;
						break;
					default :
						$option_value = isset ( $user_options [$id] ) ? $user_options [$id] : '';
						$current_options [$id] = $option_value;
	
						break;
				}
			}
		}
	
		$current_options = $this->clean_blank_values ( $current_options );
	
		update_option ( ESSB3_AB_OPTIONS_NAME, $current_options );
		
		$ab_active = isset($user_options['ab_active']) ? $user_options['ab_active'] : '';
		$ab_reset = isset($user_options['ab_reset']) ? $user_options['ab_reset'] : '';
		
		if ($ab_active == 'true' && $ab_reset == 'true') {
			update_option(ESSB3_AB_STAT_NAME, array());
			$current_options['ab_reset'] = 'false';
			update_option ( ESSB3_AB_OPTIONS_NAME, $current_options );
		}
	
	}
	
	function clean_blank_values($object) {
		foreach ( $object as $key => $value ) {
			if (! is_array ( $value )) {
				$value = trim ( $value );
	
				if (empty ( $value )) {
					unset ( $object [$key] );
				}
			} else {
				if (count ( $value ) == 0) {
					unset ( $object [$key] );
				}
			}
		}
	
		return $object;
	}
		
	public function init() {
		
	
		if (is_admin()) {
			include_once (ESSB3_AB_PLUGIN_ROOT . 'lib/essbab-admin.php');
			add_action ( 'admin_menu', array ($this, 'register_menu' ), 99 );
			
			$hook = (defined ( 'WP_NETWORK_ADMIN' ) && WP_NETWORK_ADMIN) ? 'network_admin_menu' : 'admin_menu';
			add_action ( $hook, array ($this, 'handle_save_settings' ) );
			
		}
		
	}
	
	
	
	public function register_menu() {
		global $essb_options;
	
		$menu_pos = false;
		$essb_access = "edit_pages";
			
		add_submenu_page ( 'essb_options', __ ( 'Social A/B', 'easy-optin-forms' ), '' . __ ( '[Addon] Social A/B', 'essb-ab' ) . '', $essb_access, 'essb_ab', array ($this, 'essb_of_settings_redirect' ) );
	}

	function essb_of_settings_redirect() {
		include_once (ESSB3_AB_PLUGIN_ROOT . 'lib/admin/essbab-settings.php');
	}
		
	
	function getval($from, $what, $default = false) {
		if (is_object ( $from ) && isset ( $from->$what ))
			return $from->$what;
		else if (is_array ( $from ) && isset ( $from [$what] ))
			return $from [$what];
		else
			return $default;
	}
}

/**
 * main code *
 */
global $essb_ab;
function essb_social_ab() {
	global $essb_ab;
	
	if (! isset ( $essb_ab )) {
		$essb_ab = ESSBAddonSocialAB::getInstance ();
	}
}

function essb_ab_option_value($param = '') {
	global $essb3ab_options;
	
	return isset($essb3ab_options[$param]) ? $essb3ab_options[$param] : '';
}

function essb_ab_option_bool_value($param = '') {
	global $essb3ab_options;
	
	$value = isset($essb3ab_options[$param]) ? $essb3ab_options[$param] : '';
	
	if ($value == 'true') {
		return true;
	}
	else {
		return false;
	}
} 

add_action ( 'init', 'essb_social_ab', 9 );
essb_ab_initialize();
function essb_ab_initialize() {
	global $essb3ab_options;
	$essb3ab_options = get_option ( ESSB3_AB_OPTIONS_NAME );
	
	$is_active = essb_ab_option_bool_value('ab_active');
	
	$page = isset($_REQUEST['page']) ? $_REQUEST['page'] : '';
	if ($page == 'essb_ab') { $is_active = false; }
	
	if ($is_active && !is_admin()) {
		add_filter('essb4_options_ab', 'essb4_apply_ab_settings');
		add_action('wp_footer', 'essb4_ab_generate_tracking');
	}
}

function essb4_ab_generate_tracking() {
	global $essbab_used;
	
	$update_url = essb_get_current_page_url();
	$output = '<script type="text/javascript">
	function essb_abtesting_logger(oService, oPostID, oInstance) {
		console.log("absplit testing log");
		var element = jQuery(\'.essb_\'+oInstance);
		var instance_postion = jQuery(element).attr("data-essb-position") || "";
		var instance_template = jQuery(element).attr("data-essb-template") || "";
		var instance_button = jQuery(element).attr("data-essb-button-style") || "";
	
		var instance_mobile = false;
		var essbab_url = "'.$update_url.'";
	
		if( (/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i).test(navigator.userAgent) ) {
			instance_mobile = true;
		}
		if (typeof(essb_settings) != "undefined") {
			jQuery.post(essbab_url, {
				\'essb4_ab_logging\': \'true\',
				\'post_id\': oPostID,
				\'service\': oService,
				\'template\': instance_template,
				\'mobile\': instance_mobile ? "true":"false",
				\'position\': instance_postion,
				\'button\': instance_button,
				\'abkey\': "'.$essbab_used.'"
			}, function (data) { if (data) {
	
			}},\'json\');
		}
	};
	</script>';
	
	echo $output;
	
}

function essb4_apply_ab_settings($basic_options) {
	global $essb3ab_options, $essbab_used;

	// choose random configuration to apply
	$select_setup = essb4_ab_choose_settings();
	$essbab_used = $select_setup;
	
	$setup_prefix = 'ab'.$select_setup.'_';
	
	$has_button_position = false;

	foreach ($essb3ab_options as $key => $value) {
		if (strpos($key, $setup_prefix) !== false) {
			$essb_key = str_replace($setup_prefix, '', $key);

			$basic_options[$essb_key] = $essb3ab_options[$key];
			
			if ($essb_key == 'button_position') {
				$has_button_position = true;
			}
		}
	}
	
	if (!$has_button_position) {
		$basic_options['button_position'] = array();
	}

	return $basic_options;
}

function essb4_ab_choose_settings() {
	$ab_stats = get_option ( ESSB3_AB_STAT_NAME );
	if (!$ab_stats || !is_array($ab_stats)) {
		$ab_stats = array();
	}

	$last_used_setup = isset($ab_stats['last']) ? $ab_stats['last'] : '';
	$number_of_options = essb_ab_option_value('ab_count');

	if (intval ($number_of_options) == 0) {
		$number_of_options = 2;
	}

	$current_setup = mt_rand(1, intval ($number_of_options));

	if (intval($current_setup) == intval($last_used_setup)) {
		$current_setup = mt_rand(1, intval ($number_of_options));
	}
	if (intval($current_setup) == intval($last_used_setup)) {
		if (intval($current_setup) < intval($number_of_options)) {
			$current_setup = intval($current_setup) + 1;
		}
		else {
			$current_setup = intval($current_setup) - 1;
		}
	}

	// saving last used configuration to avoid appearing it again in next load
	$ab_stats['last'] = $current_setup;
	
	
	// record display stats
	if (!isset($ab_stats['display'])) {
		$ab_stats['display'] = array();
	}
	if (!isset($ab_stats['display'][$current_setup])) {
		$ab_stats['display'][$current_setup] = 0;
	}
	$ab_stats['display'][$current_setup] += 1;
	
	update_option(ESSB3_AB_STAT_NAME, $ab_stats);

	return $current_setup;
}

add_action ( 'template_redirect', 'essb4_ab_process_additional_ajax_requests', 1 );

function essb4_ab_process_additional_ajax_requests() {
	$essb4_ab_logging = isset($_REQUEST['essb4_ab_logging']) ? $_REQUEST['essb4_ab_logging']: '';
	
	// logging
	if ($essb4_ab_logging == 'true') {
		
		$ab_stats = get_option ( ESSB3_AB_STAT_NAME );
		if (!$ab_stats || !is_array($ab_stats)) {
			$ab_stats = array();
		}
		
		$ab_service = isset($_REQUEST['service']) ? $_REQUEST['service'] : '';
		$ab_mobile = isset($_REQUEST['mobile']) ? $_REQUEST['mobile'] : '';
		$ab_position = isset($_REQUEST['position']) ? $_REQUEST['position'] : '';
		$ab_key = isset($_REQUEST['abkey']) ? $_REQUEST['abkey'] : '';
		
		if (!isset($ab_stats['clicks'])) {
			$ab_stats['clicks'] = array();
		}
		
		if (!isset($ab_stats['clicks'][$ab_key])) {
			$ab_stats['clicks'][$ab_key] = array('total' => 0, 'desktop' => 0, 'mobile' => 0, 'networks' => array(), 'positions' => array());
		}
		
		$ab_stats['clicks'][$ab_key]['total']++;
		if ($ab_mobile == "true") {
			$ab_stats['clicks'][$ab_key]['mobile']++;
		}
		else {
			$ab_stats['clicks'][$ab_key]['desktop']++;
		}
		
		if (!isset($ab_stats['clicks'][$ab_key]['networks'][$ab_service])) {
			$ab_stats['clicks'][$ab_key]['networks'][$ab_service] = 0;
		}
		
		$ab_stats['clicks'][$ab_key]['networks'][$ab_service]++;

		if (!isset($ab_stats['clicks'][$ab_key]['positions'][$ab_position])) {
			$ab_stats['clicks'][$ab_key]['positions'][$ab_position] = 0;
		}
		
		$ab_stats['clicks'][$ab_key]['positions'][$ab_position]++;
		
		update_option(ESSB3_AB_STAT_NAME, $ab_stats);
		die();
	}
}