<?php
if( ! class_exists('cjaddons_sample_widget') ) {
	class cjaddons_sample_widget extends WP_Widget{
		
		public $helpers;
		
		public function __construct() {
			
			$this->helpers = cjaddons_helpers::getInstance();
			$widget = array(
				'base_id' => 'cjaddons_sample_widget',
				'title' => esc_attr__('Sample widget (cjaddons)', 'cjaddons'),
				'description' => esc_attr__('Sample widget framework for further development.', 'cjaddons'),
			);
			parent::__construct($widget['base_id'], $widget['title'], array( 'description' => $widget['description'] ));
		}
		
		public function form_fields() {
			
			$fields = array(
				array(
					'type' => 'text',
					'id' => 'title',
					'label' => esc_attr__('Title', 'cjaddons'),
					'info' => '',
					'suffix' => '',
					'prefix' => '',
					'default' => 'New Title',
					'options' => '', // array in case of dropdown, checkbox and radio buttons
				),
				array(
					'type' => 'dropdown',
					'id' => 'dropdown',
					'label' => esc_attr__('Dropdown', 'cjaddons'),
					'info' => '',
					'suffix' => '',
					'prefix' => '',
					'default' => 'New Title',
					'options' => $this->helpers->arrays('yes-no-maybe'), // array in case of dropdown, checkbox and radio buttons
				),
			);
			
			return $fields;
		}
		
		public function form($instance) {
			
			$options = $this->form_fields();
			foreach( $options as $key => $option ) {
				$id = $option['id'];
				$form_instance[$id]['id'] = $this->get_field_id($id);
				$form_instance[$id]['name'] = $this->get_field_name($id);
				$form_instance[$id]['value'] = ( isset( $instance[$id] ) ) ? $instance[$id] : '';
			}
			
			echo $this->helpers->renderWidgetForm($options, $form_instance);
			
		}
		
		public function update($new_instance, $old_instance) {
			
			$instance = array();
			$fields = $this->form_fields();
			foreach( $fields as $key => $option ) {
				$id = $option['id'];
				if( is_array($new_instance[$id]) ) {
					$instance[$id] = implode('~~~~~', $new_instance[$id]);
				}
				else {
					$instance[$id] = $new_instance[$id];
				}
			}
			
			return $instance;
		}
		
		public function widget($args, $instance) {
			
			$output = '';
			$output .= $args['before_widget'];
			if (!empty($instance['title'])) {
				$output .= $args['before_title'] . apply_filters('widget_title', $instance['title']) . $args['after_title'];
			}
			$content_file_path = dirname(__FILE__) . '/content.php';
			if (file_exists($content_file_path)) {
				ob_start();
				require($content_file_path);
				$output .= ob_get_clean();
			} else {
				$output .= '<div class="cj-notification cj-is-danger">' . sprintf(__('Widget content file not found.<br>%s', 'cjaddons'), str_replace(dirname(dirname(__FILE__)), '', $content_file_path)) . '</div>';
			}
			$output .= $args['after_widget'];
			echo $output;
		}
		
	}
	
	// register_widget('cjaddons_sample_widget');
}