<?php
/*
Plugin Name: WP Unlimited PopUps
Plugin URI: https://cssjockey.com/shop/wp-unlimited-popups
Description: This add-on helps you create different kind of pop-ups with custom styles, colors, size, display options. You can include any type of content, HTML, CSS, Javascript and WordPress Shortcodes in these popups..
Author: CSSJockey Team
Version: 1.4.7
Author URI: https://cssjockey.com
*/
ob_start();
require_once dirname( __FILE__ ) . '/cssjockey-addon.php';
add_filter( 'plugin_action_links_' . plugin_basename( __FILE__ ), function ( $links ) {
	if( class_exists( 'cjaddons_framework' ) ) {
		$addon_id = basename( dirname( __FILE__ ) );
		$link = get_admin_url( null, 'admin.php?page=cjaddons-' . $addon_id . '&callback=' . $addon_id . '~info' );
		$links[] = '<a href="' . esc_url( $link ) . '">' . __( 'Settings', 'cjaddons' ) . '</a>';
	} else {
		$link = 'https://downloads.wordpress.org/plugin/cssjockey-add-ons.zip';
		$links[] = '<a href="' . esc_url( $link ) . '">' . __( 'Install Framework', 'cjaddons' ) . '</a>';
	}

	return $links;
} );
add_action( 'init', function () {
	$domain = basename( __DIR__ );
	$locale = apply_filters( 'plugin_locale', get_locale(), $domain );
	load_textdomain( $domain, trailingslashit( WP_LANG_DIR ) . $domain . '/' . $domain . '-' . $locale . '.mo' );
	load_plugin_textdomain( $domain, false, basename( dirname( __FILE__ ) ) . '/languages/' );
} );
if( ! class_exists( 'cjaddons_framework' ) ) {
	return false;
}