<?php
$dir_name = str_replace( '.php', '', basename( dirname( __FILE__ ) ) );

$cjaddons_item_vars['module_info'][ $dir_name ] = array(
	'item_id' => 'UPP8W9W1BC',
	'envato_id' => '8575498',
	'module_id' => basename( $dir_name ),
	'module_path' => dirname( __FILE__ ),
	'module_name' => __( 'Unlimited PopUps', 'addon-unlimited-popups' ),
	'module_version' => '1.4.7',
	'core' => false, // if true, sub menu page will not be created and menu options will be added to default admin page dropdown.
	'module_description' => 'This add-on helps you create different kind of pop-ups with custom styles, colors, size, display options. You can include any type of content, HTML, CSS, Javascript and WordPress Shortcodes in these popups.',
	'docs_url' => 'https://cssjockey.com/documentation/addon-unlimited-popups/',
	'pro_version_url' => '',
	'dependencies' => array(),
);

$cjaddons_item_vars['locale'][ $dir_name ]['module_info'] = $cjaddons_item_vars['module_info'][ $dir_name ];
if( class_exists( 'cjaddons_helpers' ) ) {
	$config_dir_path = dirname( __FILE__ ) . '/config/';
	$module_id = $cjaddons_item_vars['module_info'][ $dir_name ]['module_id'];
	$dirs = preg_grep( '/^([^.])/', scandir( $config_dir_path ) );
	$deactivated_modules = get_option( 'cjaddons_modules_deactivated' );
	$deactivated_modules = (!is_array($deactivated_modules)) ? array() : $deactivated_modules;
	if( is_array( $dirs ) && ! in_array( $module_id, $deactivated_modules ) ) {
		foreach( $dirs as $key => $dir ) {
			$file_path = $config_dir_path . $dir;
			if( ! is_dir( $file_path ) && file_exists( $file_path ) ) {
				require_once $file_path;
			}
		}
	}
}