<?php
require_once sprintf( '%s/helpers.php', dirname( __FILE__ ) );

if( ! class_exists( 'cjaddons_unlimited_popups_base' ) ) {

	class cjaddons_unlimited_popups_base {

		private static $instance;

		public $helpers, $options, $module_dir, $module_url;

		public static function getInstance() {
			if( ! isset( self::$instance ) ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		public function __construct() {
			$this->module_dir = wp_normalize_path( dirname( __FILE__ ) );
			$this->module_url = str_replace( str_replace( '\\', '/', WP_CONTENT_DIR ), WP_CONTENT_URL, $this->module_dir );
			$this->helpers = cjaddons_unlimited_popups_helpers::getInstance();
			$cjaddons_ready = get_option( 'cjaddons_ready', array() );
			$addon_name = basename( $this->module_dir );
			if( isset( $cjaddons_ready[ $addon_name ] ) && $cjaddons_ready[ $addon_name ] == 1 ) {
				add_action( 'admin_enqueue_scripts', array($this, 'enqueueModuleAdminScripts'), 100 );
				add_action( 'wp_enqueue_scripts', array($this, 'enqueueModuleFrontendScripts'), 100 );
				add_filter( 'cjaddons-localize-scripts', array($this, 'localizeScripts') );
				add_action( 'admin_menu', array($this, 'adminMenu') );
				add_action( 'widgets_init', array($this, 'includeWidgets') );
				add_action( 'wp_loaded', array($this, 'includeMetaboxes') );
				add_action( 'wp_loaded', array($this, 'includeShortcodes') );
				add_action( 'wp_loaded', array($this, 'includeComponents') );
				$this->includeAutoload();
			}
		}

		public function enqueueModuleAdminScripts() {
			$assets_dir = trailingslashit( $this->module_dir ) . 'assets';
			$assets_url = trailingslashit( $this->module_url ) . 'assets';
			$module_name = basename( $this->module_dir );

			$item_version = time();

			$file_name = $assets_dir . '/backend-plugins.min.js';
			if( file_exists( $file_name ) && filesize( $file_name ) > 0 ) {
				$file_url = str_replace( $assets_dir, $assets_url, $file_name );
				wp_register_script( 'cjaddons-module-' . $module_name . '-backend-plugins', $file_url, array(), $item_version, true );
				wp_enqueue_script( 'cjaddons-module-' . $module_name . '-backend-plugins' );
			}

			$file_name = $assets_dir . '/backend.min.js';
			if( file_exists( $file_name ) && filesize( $file_name ) > 0 ) {
				$file_url = str_replace( $assets_dir, $assets_url, $file_name );
				wp_register_script( 'cjaddons-module-' . $module_name . '-backend', $file_url, array(), $item_version, true );
				wp_enqueue_script( 'cjaddons-module-' . $module_name . '-backend' );
				wp_localize_script( 'cjaddons-module-' . $module_name . '-backend', 'localize', $this->localizeScripts() );
			}

			$file_name = $assets_dir . '/backend-plugins.min.css';
			if( file_exists( $file_name ) && filesize( $file_name ) > 0 ) {
				$file_url = str_replace( $assets_dir, $assets_url, $file_name );
				wp_register_style( 'cjaddons-module-' . $module_name . '-backend-plugins', $file_url, false, $item_version );
				wp_enqueue_style( 'cjaddons-module-' . $module_name . '-backend-plugins' );
			}

			$file_name = $assets_dir . '/backend.min.css';
			if( file_exists( $file_name ) && filesize( $file_name ) > 0 ) {
				$file_url = str_replace( $assets_dir, $assets_url, $file_name );
				wp_register_style( 'cjaddons-module-' . $module_name . '-backend', $file_url, false, $item_version );
				wp_enqueue_style( 'cjaddons-module-' . $module_name . '-backend' );
			}
		}

		public function enqueueModuleFrontendScripts() {
			$assets_dir = trailingslashit( $this->module_dir ) . 'assets';
			$assets_url = trailingslashit( $this->module_url ) . 'assets';
			$module_name = basename( $this->module_dir );
			$combine_assets = $this->helpers->savedOption( 'core_combine_assets' );
			$item_version = time();

			$file_name = $assets_dir . '/frontend-plugins.min.js';
			if( file_exists( $file_name ) && filesize( $file_name ) > 0 ) {
				$file_url = str_replace( $assets_dir, $assets_url, $file_name );
				wp_register_script( 'cjaddons-module-' . $module_name . '-frontend-plugins', $file_url, array(), $item_version, true );
				if( $combine_assets !== 'yes' ) {
					wp_enqueue_script( 'cjaddons-module-' . $module_name . '-frontend-plugins' );
				}
			}

			$file_name = $assets_dir . '/frontend.min.js';
			if( file_exists( $file_name ) && filesize( $file_name ) > 0 ) {
				$file_url = str_replace( $assets_dir, $assets_url, $file_name );
				wp_register_script( 'cjaddons-module-' . $module_name . '-frontend', $file_url, array('jquery'), $item_version, true );
				if( $combine_assets !== 'yes' ) {
					wp_enqueue_script( 'cjaddons-module-' . $module_name . '-frontend' );
					wp_localize_script( 'cjaddons-module-' . $module_name . '-frontend', 'localize', $this->localizeScripts() );
				}
			}

			$file_name = $assets_dir . '/frontend-plugins.min.css';
			if( file_exists( $file_name ) && filesize( $file_name ) > 0 ) {
				$file_url = str_replace( $assets_dir, $assets_url, $file_name );
				wp_register_style( 'cjaddons-module-' . $module_name . '-frontend-plugins', $file_url, false, $item_version );
				if( $combine_assets !== 'yes' ) {
					wp_enqueue_style( 'cjaddons-module-' . $module_name . '-frontend-plugins' );
				}
			}

			$file_name = $assets_dir . '/frontend.min.css';
			if( file_exists( $file_name ) && filesize( $file_name ) > 0 ) {
				$file_url = str_replace( $assets_dir, $assets_url, $file_name );
				wp_register_style( 'cjaddons-module-' . $module_name . '-frontend', $file_url, false, $item_version );
				if( $combine_assets !== 'yes' ) {
					wp_enqueue_style( 'cjaddons-module-' . $module_name . '-frontend' );
				}
			}
		}

		public function localizeScripts() {
			global $cjaddons_item_vars;
			$cjaddons_item_vars['locale'] = apply_filters( 'cjaddons_locale', $cjaddons_item_vars['locale'] );

			return $cjaddons_item_vars['locale'];
		}

		public function adminMenu() {
			$page_slug = $this->helpers->itemInfo( 'page_slug' );
			$slug = $page_slug . '-' . basename( $this->module_dir );
			add_submenu_page( $page_slug, $this->moduleInfo( 'module_name' ), $this->moduleInfo( 'module_name' ), 'manage_options', $slug, array($this, 'adminMenuPage') );
		}

		public function adminMenuPage() {
			require_once $this->helpers->root_dir . '/framework/html/admin-submenu-page.php';
		}

		public function moduleInfo( $var = null ) {
			$module_data = $this->helpers->itemVars( 'module_info' );
			$module_info = $module_data[ basename( $this->module_dir ) ];

			return (is_null( $var )) ? $module_info : $module_info[ $var ];
		}

		public function includeAutoload() {
			$functions_dir = dirname( __FILE__ ) . '/autoload/';
			if( is_dir( $functions_dir ) ) {
				$dirs = preg_grep( '/^([^.])/', scandir( $functions_dir ) );
				foreach( $dirs as $key => $value ) {
					$file_path = $functions_dir . $value;
					if( is_file( $file_path ) ) {
						require_once($file_path);
					}
				}
			}
		}

		public function includeWidgets() {
			$widgets_dir = dirname( __FILE__ ) . '/widgets/';
			if( is_dir( $widgets_dir ) ) {
				$dirs = preg_grep( '/^([^.])/', scandir( $widgets_dir ) );
				foreach( $dirs as $key => $value ) {
					$file_path = $widgets_dir . $value . '/init.php';
					if( is_file( $file_path ) ) {
						require_once($file_path);
					}
				}
			}
		}

		public function includeShortcodes() {
			$shortcodes_dir = dirname( __FILE__ ) . '/shortcodes/';
			if( is_dir( $shortcodes_dir ) ) {
				$dirs = preg_grep( '/^([^.])/', scandir( $shortcodes_dir ) );
				foreach( $dirs as $key => $value ) {
					$file_path = $shortcodes_dir . $value . '/init.php';
					if( is_file( $file_path ) ) {
						require($file_path);
					}
				}
			}
		}

		public function includeComponents() {
			$components_dir = dirname( __FILE__ ) . '/components/';
			if( is_dir( $components_dir ) ) {
				$dirs = preg_grep( '/^([^.])/', scandir( $components_dir ) );
				foreach( $dirs as $key => $dir_name ) {
					$file_path = $components_dir . $dir_name . '/init.php';
					if( is_file( $file_path ) ) {
						require($file_path);
					}
				}
			}
		}

		public function includeMetaboxes() {
			$metaboxes_dir = dirname( __FILE__ ) . '/metaboxes/';
			if( is_dir( $metaboxes_dir ) ) {
				$dirs = preg_grep( '/^([^.])/', scandir( $metaboxes_dir ) );
				foreach( $dirs as $key => $value ) {
					$file_path = $metaboxes_dir . $value;
					if( is_file( $file_path ) ) {
						require_once $file_path;
					}
				}
			}
		}

	}

	cjaddons_unlimited_popups_base::getInstance();
}