<?php
if( ! class_exists( 'cjaddons_unlimited_popups_metabox' ) ) {
	class cjaddons_unlimited_popups_metabox {
		private static $instance;
		public $helpers;

		public static function getInstance() {
			if( ! isset( self::$instance ) ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		public function __construct() {
			$this->helpers = cjaddons_unlimited_popups_helpers::getInstance();
			add_action( 'add_meta_boxes', array($this, 'registerMetaBoxes') );
			add_action( 'save_post', array($this, 'savePostSettings'), 10, 3 );
		}

		public function registerMetaBoxes() {
			add_meta_box( 'cjaddons-unlimited-popups-display-settings-metabox', __( 'Pop-up Display Settings', 'addon-unlimited-popups' ), array($this, 'displaySettingsMetaboxCallback'), 'cjaddons-popups', 'side', 'low' );
			add_meta_box( 'cjaddons-unlimited-popups-settings-metabox', __( 'Pop-up Settings', 'addon-unlimited-popups' ), array($this, 'settingsMetaboxCallback'), 'cjaddons-popups', 'advanced', 'high' );
		}

		public function displaySettingsMetaboxCallback() {
			require_once 'html/popup-display-settings-form.php';
		}

		public function settingsMetaboxCallback() {
			require_once 'html/popup-settings-form.php';
		}

		public function savePostSettings( $post_id, $post, $update ) {
			$post_type = get_post_type( $post_id );

			// If this isn't a 'book' post, don't update it.
			if( "cjaddons-popups" != $post_type ) {
				return;
			}
			if( wp_is_post_revision( $post_id ) ) {
				return;
			}

			if( isset( $_POST['popup_display'] ) ) {

				if(!isset($_POST['popup_display']['entire_website'])){
					$_POST['popup_display']['entire_website'] = 'no';
				}
				if(in_array('everyone', $_POST['popup_display']['display_roles'])){
					foreach($_POST['popup_display']['display_roles'] as $role_key => $role_value){
						if($role_value !== 'everyone'){
							unset($_POST['popup_display']['display_roles'][$role_key]);
						}
					}
				}
				update_post_meta( $post_id, '_popup_display_settings', $_POST['popup_display'] );
			}
			if( isset( $_POST['popup_settings'] ) ) {
				update_post_meta( $post_id, '_popup_settings', $_POST['popup_settings'] );
			}
		}
	}

	cjaddons_unlimited_popups_metabox::getInstance();
}