<?php
global $post;
$saved_settings = get_post_meta( $post->ID, '_popup_settings', true );

$css_class_default = '<div class="cj-mt-10"><code>show-cjaddons-popup-'.$post->ID.'</code> <span style="position: relative; top: 3px;" data-clipboard-text="show-cjaddons-popup-'.$post->ID.'" data-clipboard-confirmation="<i class=\'fa fa-check cj-color-green\'></i>" class="cj-icon cj-is-small"><i class="fa fa-copy"></i></span></div>';
$css_class_default .= '<div class="cj-mt-10"><code>'.htmlentities('<a href="#" class="show-cjaddons-popup-'.$post->ID.'">Open Pop-up</a>').'</code></div>';
$css_class_info = __('You can use this CSS class on any HTML element to display this popup.', 'addon-unlimited-popups');

$settings_form_fields = array(

	array(
		'id' => 'popup_settings[show_on_click]',
		'type' => 'dropdown',
		'label' => __( 'Bind OnClick Event', 'addon-unlimited-popups' ),
		'info' => $css_class_info.$css_class_default,
		'default' => (isset( $saved_settings['show_on_click'] )) ? $saved_settings['show_on_click'] : 'no',
		'options' => $this->helpers->arrays('yes-no'),
		'show_gap' => 0,
		'label_padding' => 'pl-15 pr-15 pt-15 pb-0',
	),

	array(
		'id' => 'popup_settings[popup_type]',
		'type' => 'dropdown',
		'label' => __( 'Select Pop-up Type', 'addon-unlimited-popups' ),
		'info' => __( 'Choose pop-up style as per the content you would like to display.', 'addon-unlimited-popups' ),
		'default' => (isset( $saved_settings['popup_type'] )) ? $saved_settings['popup_type'] : 'modal',
		'options' => array(
			'modal' => __( 'Modal', 'addon-unlimited-popups' ),
			'fullscreen' => __( 'Full Screen', 'addon-unlimited-popups' ),
			'bar-top' => __( 'Bar - Top', 'addon-unlimited-popups' ),
			'bar-bottom' => __( 'Bar - Bottom', 'addon-unlimited-popups' ),
			'box-top-left' => __( 'Box - Top Left', 'addon-unlimited-popups' ),
			'box-top-right' => __( 'Box - Top Right', 'addon-unlimited-popups' ),
			'box-bottom-left' => __( 'Box - Bottom Left', 'addon-unlimited-popups' ),
			'box-bottom-right' => __( 'Box - Bottom Right', 'addon-unlimited-popups' ),
			'panel-left' => __( 'Panel - Left', 'addon-unlimited-popups' ),
			'panel-right' => __( 'Panel - Right', 'addon-unlimited-popups' ),
		),
		'show_gap' => 0,
		'label_padding' => 'pl-15 pr-15 pt-15 pb-0',
	),
	array(
		'id' => 'popup_settings[popup_width]',
		'type' => 'text',
		'label' => __( 'Pop-up Width', 'addon-unlimited-popups' ),
		'info' => __( 'This is applied to modal, box and panel pop-up styles and will fallback to default responsive styles.', 'addon-unlimited-popups' ),
		'default' => (isset( $saved_settings['popup_width'] )) ? $saved_settings['popup_width'] : '50%',
		'options' => '',
		'show_gap' => 0,
		'label_padding' => 'pl-15 pr-15 pt-15 pb-0',
	),
	array(
		'id' => 'popup_settings[popup_background_color]',
		'type' => 'color',
		'label' => __( 'Pop-up Background Color', 'addon-unlimited-popups' ),
		'info' => '',
		'default' => (isset( $saved_settings['popup_background_color'] )) ? $saved_settings['popup_background_color'] : '#00BDFF',
		'options' => '',
		'show_gap' => 0,
		'label_padding' => 'pl-15 pr-15 pt-15 pb-0',
	),
	array(
		'id' => 'popup_settings[popup_text_color]',
		'type' => 'color',
		'label' => __( 'Pop-up Text Color', 'addon-unlimited-popups' ),
		'info' => '',
		'default' => (isset( $saved_settings['popup_text_color'] )) ? $saved_settings['popup_text_color'] : '#ffffff',
		'options' => '',
		'show_gap' => 0,
		'label_padding' => 'pl-15 pr-15 pt-15 pb-0',
	),
	array(
		'id' => 'popup_settings[popup_link_color]',
		'type' => 'color',
		'label' => __( 'Pop-up Link Color', 'addon-unlimited-popups' ),
		'info' => '',
		'default' => (isset( $saved_settings['popup_link_color'] )) ? $saved_settings['popup_link_color'] : '#ffff00',
		'options' => '',
		'show_gap' => 0,
		'label_padding' => 'pl-15 pr-15 pt-15 pb-0',
	),
	array(
		'id' => 'popup_settings[popup_padding]',
		'type' => 'text',
		'label' => __( 'Pop-up Padding', 'addon-unlimited-popups' ),
		'info' => '',
		'default' => (isset( $saved_settings['popup_padding'] )) ? $saved_settings['popup_padding'] : '30px',
		'options' => '',
		'show_gap' => 0,
		'label_padding' => 'pl-15 pr-15 pt-15 pb-0',
	),
	array(
		'type' => 'group',
		'id' => 'popup_settings[backdrop]',
		'group' => 'popup-backdrop',
		'label' => __( 'Backdrop', 'addon-unlimited-popups' ),
		'info' => __( 'Select if you would like to display backdrop with the pop-up.', 'addon-unlimited-popups' ),
		'default' => (isset( $saved_settings['backdrop'] ) && isset( $saved_settings['backdrop']['selected_value'] )) ? $saved_settings['backdrop']['selected_value'] : 'yes',
		'options' => $this->helpers->arrays( 'yes-no' ), // array in case of dropdown, checkbox and radio buttons
		'options_disable_blank' => true,
		'items' => array(
			'yes' => array(
				'background-color' => array(
					'id' => 'background-color',
					'type' => 'color',
					'label' => __( 'Color', 'addon-unlimited-popups' ),
					'info' => '',
					'default' => (isset($saved_settings['backdrop']['items']['yes']['background-color'])) ? $saved_settings['backdrop']['items']['yes']['background-color'] : '#000000',
					'options' => '', // array in case of dropdown, checkbox and radio buttons
				),
				'opacity' => array(
					'id' => 'opacity',
					'type' => 'number',
					'label' => __( 'Opacity', 'addon-unlimited-popups' ),
					'info' => '',
					'default' => (isset($saved_settings['backdrop']['items']['yes']['opacity'])) ? $saved_settings['backdrop']['items']['yes']['opacity'] : '70',
					'params' => array(
						'min' => 0,
						'max' => 100,
					),
					'options' => '', // array in case of dropdown, checkbox and radio buttons
				)
			),
			'no' => array(),
		)
	),
	array(
		'id' => 'popup_settings[popup_animation_in]',
		'type' => 'dropdown',
		'label' => __( 'In Animation', 'addon-unlimited-popups' ),
		'label_suffix' => sprintf( __( '<a href="%s" target="_blank">Animation Styles</a>', 'addon-unlimited-popups' ), 'https://daneden.github.io/animate.css/' ),
		'info' => __( 'This animation will be applied to display this pop-up.', 'addon-unlimited-popups' ),
		'default' => (isset( $saved_settings['popup_animation_in'] )) ? $saved_settings['popup_animation_in'] : 'bounceInUp',
		'options' => $this->helpers->arrays( 'animate-css' ),
		'show_gap' => 0,
		'label_padding' => 'pl-15 pr-15 pt-15 pb-0',
	),
	array(
		'id' => 'popup_settings[popup_animation_out]',
		'type' => 'dropdown',
		'label' => __( 'Out Animation', 'addon-unlimited-popups' ),
		'label_suffix' => sprintf( __( '<a href="%s" target="_blank">Animation Styles</a>', 'addon-unlimited-popups' ), 'https://daneden.github.io/animate.css/' ),
		'info' => __( 'This animation will be applied to hide this pop-up.', 'addon-unlimited-popups' ),
		'default' => (isset( $saved_settings['popup_animation_out'] )) ? $saved_settings['popup_animation_out'] : 'bounceOutUp',
		'options' => $this->helpers->arrays( 'animate-css' ),
		'show_gap' => 0,
		'label_padding' => 'pl-15 pr-15 pt-15 pb-0',
	),
	array(
		'id' => 'popup_settings[popup_delay]',
		'type' => 'number',
		'label' => __( 'Delay', 'addon-unlimited-popups' ),
		'info' => __( 'Specify number of seconds to delay this pop-up.', 'addon-unlimited-popups' ),
		'default' => (isset( $saved_settings['popup_delay'] )) ? $saved_settings['popup_delay'] : 0,
		'params' => array(
			'min' => 0,
			'placeholder' => __('e.g. 2000 = 2 seconds', 'addon-unlimited-popups'),
		),
		'options' => '',
		'show_gap' => 0,
		'label_padding' => 'pl-15 pr-15 pt-15 pb-0',
	),
	array(
		'id' => 'popup_settings[popup_auto_hide]',
		'type' => 'number',
		'label' => __( 'Auto Hide', 'addon-unlimited-popups' ),
		'info' => __( 'Specify number of seconds to auto hide this pop-up.', 'addon-unlimited-popups' ),
		'default' => (isset( $saved_settings['popup_auto_hide'] )) ? $saved_settings['popup_auto_hide'] : 0,
		'params' => array(
			'min' => 0,
			'placeholder' => __('e.g. 2000 = 2 seconds', 'addon-unlimited-popups'),
		),
		'options' => '',
		'show_gap' => 0,
		'label_padding' => 'pl-15 pr-15 pt-15 pb-0',
	),
	array(
		'type' => 'group',
		'id' => 'popup_settings[close_button]',
		'group' => 'popup-close-button',
		'label' => __( 'Display Close Button', 'addon-unlimited-popups' ),
		'info' => __( 'Manage pop-up close button settings.', 'addon-unlimited-popups' ),
		'default' => (isset( $saved_settings['close_button'] ) && isset( $saved_settings['close_button']['selected_value'] )) ? $saved_settings['close_button']['selected_value'] : 'yes',
		'options' => $this->helpers->arrays( 'yes-no' ), // array in case of dropdown, checkbox and radio buttons
		'options_disable_blank' => true,
		'items' => array(
			'yes' => array(
				'button_text' => array(
					'id' => 'button_text',
					'type' => 'text',
					'label' => __( 'Button Text or Icon', 'addon-unlimited-popups' ),
					'info' => '',
					'default' => (isset($saved_settings['close_button']['items']['yes']['button_text'] )) ? $saved_settings['close_button']['items']['yes']['button_text'] : '<i class="fa fa-times-circle"></i>',
					'options' => '', // array in case of dropdown, checkbox and radio buttons
				),
				'button_position' => array(
					'id' => 'button_position',
					'type' => 'dropdown',
					'label' => __( 'Button Position', 'addon-unlimited-popups' ),
					'info' => '',
					'default' => (isset($saved_settings['close_button']['items']['yes']['button_position'])) ? $saved_settings['close_button']['items']['yes']['button_position'] : 'top-right',
					'params' => array(
						'class' => 'selectize'
					),
					'options' => array(
						'top-right' => __( 'Top Right', 'addon-unlimited-popups' ),
						'top-left' => __( 'Top Left', 'addon-unlimited-popups' ),
					),
				),
				'button_background_color' => array(
					'id' => 'button_background_color',
					'type' => 'color',
					'label' => __( 'Button Background Color', 'addon-unlimited-popups' ),
					'info' => '',
					'default' => (isset($saved_settings['close_button']['items']['yes']['button_background_color'])) ? $saved_settings['close_button']['items']['yes']['button_background_color'] : 'transparent',
					'options' => '', // array in case of dropdown, checkbox and radio buttons
				),
				'button_text_color' => array(
					'id' => 'button_text_color',
					'type' => 'color',
					'label' => __( 'Button Text Color', 'addon-unlimited-popups' ),
					'info' => '',
					'default' => (isset($saved_settings['close_button']['items']['yes']['button_text_color'])) ? $saved_settings['close_button']['items']['yes']['button_text_color'] : '#ffffff',
					'options' => '', // array in case of dropdown, checkbox and radio buttons
				),
			),
			'no' => array(),
		)
	),
	array(
		'id' => 'popup_settings[popup_esc_close]',
		'type' => 'dropdown',
		'label' => __( 'Close with ESC key?', 'addon-unlimited-popups' ),
		'info' => __( 'Users can hide the pop-up by pressing ESC key on their keyboard.', 'addon-unlimited-popups' ),
		'default' => (isset( $saved_settings['popup_esc_close'] )) ? $saved_settings['popup_esc_close'] : 'yes',
		'options' => $this->helpers->arrays( 'yes-no' ),
		'show_gap' => 0,
		'label_padding' => 'pl-15 pr-15 pt-15 pb-0',
	),
	array(
		'id' => 'popup_settings[popup_page_scroll]',
		'type' => 'dropdown',
		'label' => __( 'Disable Page Scroll?', 'addon-unlimited-popups' ),
		'info' => __( 'Disable background page scroll when pop-up is displayed.', 'addon-unlimited-popups' ),
		'default' => (isset( $saved_settings['popup_page_scroll'] )) ? $saved_settings['popup_page_scroll'] : 'yes',
		'options' => $this->helpers->arrays( 'yes-no' ),
		'show_gap' => 0,
		'label_padding' => 'pl-15 pr-15 pt-15 pb-0',
	),
	array(
		'id' => 'popup_settings[popup_responsiveness]',
		'type' => 'multi-dropdown',
		'label' => __( 'Responsive Display', 'addon-unlimited-popups' ),
		'info' => __( 'Choose screen types where you would like to display this pop-up.', 'addon-unlimited-popups' ),
		'default' => (isset( $saved_settings['popup_responsiveness'] )) ? $saved_settings['popup_responsiveness'] : array('widescreen', 'desktop', 'tablet', 'mobile'),
		'options' => array(
			'widescreen' => __( 'HD Screens', 'addon-unlimited-popups' ),
			'desktop' => __( 'Desktop', 'addon-unlimited-popups' ),
			'tablet' => __( 'Tablet', 'addon-unlimited-popups' ),
			'mobile' => __( 'Mobile', 'addon-unlimited-popups' ),
		),
		'show_gap' => 0,
		'label_padding' => 'pl-15 pr-15 pt-15 pb-0',
	),
	array(
		'id' => 'popup_settings[popup_cookie_expire]',
		'type' => 'number',
		'label' => __( 'Cookie expires in', 'addon-unlimited-popups' ),
		'info' => __( 'When a user close this pop-up, a cookie is saved so this pop-up does not display again for specified number of days.', 'addon-unlimited-popups' ),
		'suffix' => 'days',
		'params' => array(
			'min' => 0
		),
		'default' => (isset( $saved_settings['popup_cookie_expire'] )) ? $saved_settings['popup_cookie_expire'] : 365,
		'show_gap' => 0,
		'label_padding' => 'pl-15 pr-15 pt-15 pb-0',
	),
	array(
		'id' => 'popup_settings[popup_date_range]',
		'type' => 'date-range',
		'label' => __( 'Display between', 'addon-unlimited-popups' ),
		'info' => __( 'Select start date and end date and this pop-up will only display between these dates.', 'addon-unlimited-popups' ),
		'default' => (isset( $saved_settings['popup_date_range'] )) ? $saved_settings['popup_date_range'] : array(),
		'show_gap' => 0,
		'label_padding' => 'pl-15 pr-15 pt-15 pb-0',
	),
	array(
		'id' => 'popup_settings[popup_raw_html]',
		'type' => 'textarea',
		'label' => __( 'Raw Content', 'addon-unlimited-popups' ),
		'info' => __( 'You can specify Raw HTML, CSS and Javascript code in this box.<br>If not blank, then this content will override pop-up content specified in the editor.', 'addon-unlimited-popups' )
                .'<div class="cj-mt-10">'.__('<b>Full width and height video</b><br>If you are using an iframe to display a video, remove height and width from the iframe and specify <code>video</code> css class to cover pop-up with video.', 'addon-unlimited-popups').'</div>'
                .'<div class="cj-mt-10"><code>&lt;iframe class="video" src="REPLACE_VIDEO_URL" frameborder="0" allowfullscreen&gt;&lt;/iframe&gt;</code></div>',
		'default' => (isset( $saved_settings['popup_raw_html'] )) ? $saved_settings['popup_raw_html'] : '',
		'params' => array(
			'placeholder' => __( 'HTML, CSS or Javascript code', 'addon-unlimited-popups' ),
			'style' => 'height: 250px;',
		),
		'show_gap' => 0,
		'label_padding' => 'pl-15 pr-15 pt-15 pb-0',
	),
);
echo '<div class="cssjockey-ui">';
echo '<div class="popup-settings-metabox-form">';
echo $this->helpers->renderAdminForm( $settings_form_fields );
echo '</div>';
echo '</div>';

?>
<style>
    #cjaddons-unlimited-popups-settings-metabox .inside {
        margin: 0;
        padding: 0;
    }

    #cjaddons-unlimited-popups-settings-metabox .popup-settings-metabox-form .admin-form {
        border: 0;
    }

    #cjaddons-unlimited-popups-settings-metabox .popup-settings-metabox-form .admin-form .field {
        margin-bottom: 0;
    }

    #cjaddons-unlimited-popups-settings-metabox .field-display-options-heading h2 {
        padding: 0;
        margin: 0;
    }
</style>
