<?php

global $post;
$saved_settings = get_post_meta( $post->ID, '_popup_display_settings', true );

$display_categories_single_checked = (isset( $saved_settings['display_categories'] ) && isset( $saved_settings['display_categories_single'] ) && $saved_settings['display_categories_single'] == 'on') ? 'checked' : '';
$display_post_types_single_checked = (isset( $saved_settings['display_post_types'] ) && isset( $saved_settings['display_post_types_single'] ) && $saved_settings['display_post_types_single'] == 'on') ? 'checked' : '';
$display_taxonomies_single_checked = (isset( $saved_settings['display_taxonomies'] ) && isset( $saved_settings['display_taxonomies_single'] ) && $saved_settings['display_taxonomies_single'] == 'on') ? 'checked' : '';

$page_on_front = get_option( 'page_on_front' );
$page_for_posts = get_option( 'page_for_posts' );

$homepage_field = array(
	'id' => 'popup_display[homepage]',
	'type' => 'checkbox',
	'label' => '',
	'info' => '',
	'default' => (isset( $saved_settings['homepage'] )) ? $saved_settings['homepage'] : array('no'),
	'options' => array('yes' => __( 'Display on Homepage?', 'addon-unlimited-popups' )),
	'show_gap' => 0,
	'show_label' => 0,
	'label_padding' => 'pl-15 pr-15 pt-15 pb-0',
);

$blog_field = array();
if( $page_for_posts != 0 ) {
	$blog_field = array(
		'id' => 'popup_display[blog]',
		'type' => 'checkbox',
		'label' => '',
		'info' => '',
		'default' => (isset( $saved_settings['blog'] )) ? $saved_settings['blog'] : array('no'),
		'options' => array('yes' => __( 'Display on Posts page?', 'addon-unlimited-popups' )),
		'show_gap' => 0,
		'show_label' => 0,
		'label_padding' => 'pl-15 pr-15 pt-15 pb-0',
	);
}

$settings_form_fields = array(
	array(
		'id' => 'popup_display[display-options-info]',
		'type' => 'info-full',
		'label' => '',
		'info' => '',
		'default' => __( 'Select content pages where you would like to display this pop-up.', 'addon-unlimited-popups' ),
		'options' => '',
		'show_gap' => 0,
		'show_label' => 0,
	),
	array(
		'id' => 'popup_display[entire_website]',
		'type' => 'checkbox',
		'label' => '',
		'info' => '',
		'default' => (isset( $saved_settings['entire_website'] )) ? $saved_settings['entire_website'] : array('yes'),
		'options' => array('yes' => __( 'Display Sitewide?', 'addon-unlimited-popups' )),
		'show_gap' => 0,
		'show_label' => 0,
		'label_padding' => 'pl-15 pr-15 pt-15 pb-0',
	),
	$homepage_field,
	$blog_field,
	array(
		'id' => 'popup_display[display_roles]',
		'type' => 'roles',
		'label' => __( 'Show to User Roles', 'addon-unlimited-popups' ),
		'info' => __( 'Show this pop-up to selected user roles.', 'addon-unlimited-popups' ),
		'default' => (isset( $saved_settings['display_roles'] )) ? $saved_settings['display_roles'] : array('everyone'),
		'options' => '',
		'container_class' => 'enable-with-sitewide',
		'show_gap' => 0,
		'label_padding' => 'pl-15 pr-15 pt-15 pb-0',
	),
	array(
		'id' => 'popup_display[display_pages]',
		'type' => 'pages',
		'label' => __( 'Pages', 'addon-unlimited-popups' ),
		'info' => __( 'Show this pop-up on selected pages.', 'addon-unlimited-popups' ),
		'default' => (isset( $saved_settings['display_pages'] )) ? $saved_settings['display_pages'] : '',
		'options' => '',
		'show_gap' => 0,
		'label_padding' => 'pl-15 pr-15 pt-15 pb-0',
	),
	array(
		'id' => 'popup_display[display_posts]',
		'type' => 'posts',
		'label' => __( 'Posts', 'addon-unlimited-popups' ),
		'info' => __( 'Show this pop-up on selected posts.', 'addon-unlimited-popups' ),
		'default' => (isset( $saved_settings['display_posts'] )) ? $saved_settings['display_posts'] : '',
		'options' => '',
		'show_gap' => 0,
		'label_padding' => 'pl-15 pr-15 pt-15 pb-0',
	),
	array(
		'id' => 'popup_display[display_categories]',
		'type' => 'categories',
		'label' => __( 'Categories', 'addon-unlimited-popups' ),
		'info' => __( 'Show this pop-up on selected categories.', 'addon-unlimited-popups' ) . '<div class="cj-mt-10"><label><input ' . $display_categories_single_checked . ' name="popup_display[display_categories_single]" type="checkbox"> <span style="position: relative; top: -3px; margin-left: 4px;">' . __( 'Include single posts as well.', 'addon-unlimited-popups' ) . '</span></label></div>',
		'default' => (isset( $saved_settings['display_categories'] )) ? $saved_settings['display_categories'] : '',
		'options' => '',
		'show_gap' => 0,
		'label_padding' => 'pl-15 pr-15 pt-15 pb-0',
	),
	array(
		'id' => 'popup_display[display_post_types]',
		'type' => 'post-types',
		'label' => __( 'Custom Post Type Archives', 'addon-unlimited-popups' ),
		'info' => __( 'Show this pop-up on selected post types.', 'addon-unlimited-popups' ) . '<div class="cj-mt-10"><label><input ' . $display_post_types_single_checked . ' name="popup_display[display_post_types_single]" type="checkbox"> <span style="position: relative; top: -3px; margin-left: 4px;">' . __( 'Include single posts as well.', 'addon-unlimited-popups' ) . '</span></label></div>',
		'default' => (isset( $saved_settings['display_post_types'] )) ? $saved_settings['display_post_types'] : '',
		'options' => '',
		'show_gap' => 0,
		'exclude' => array('cj-ui-blocks', 'cjaddons-popups'),
		'label_padding' => 'pl-15 pr-15 pt-15 pb-0',
	),
	array(
		'id' => 'popup_display[display_taxonomies]',
		'type' => 'taxonomies',
		'label' => __( 'Custom Taxonomies', 'addon-unlimited-popups' ),
		'info' => __( 'Show this pop-up on selected custom taxonomies.', 'addon-unlimited-popups' ) . '<div class="cj-mt-10"><label><input ' . $display_taxonomies_single_checked . ' name="popup_display[display_taxonomies_single]" type="checkbox"> <span style="position: relative; top: -3px; margin-left: 4px;">' . __( 'Include single posts as well.', 'addon-unlimited-popups' ) . '</span></label></div>',
		'default' => (isset( $saved_settings['display_taxonomies'] )) ? $saved_settings['display_taxonomies'] : array(),
		'show_gap' => 0,
		//'exclude' => array('cj-ui-blocks', 'cjaddons-popups'),
		'label_padding' => 'pl-15 pr-15 pt-15 pb-0',
	),
	array(
		'id' => 'popup_display[display_user_meta_keys]',
		'type' => 'user-meta-key-value',
		'label' => __( 'Show with User Meta', 'addon-unlimited-popups' ),
		'info' => __( 'Show this pop-up if user is logged in and has this meta key and value.', 'addon-unlimited-popups' ),
		'default' => (isset( $saved_settings['display_user_meta_keys'] )) ? $saved_settings['display_user_meta_keys'] : array(),
		'options' => '',
		'show_gap' => 0,
		'container_class' => 'enable-with-sitewide',
		//'exclude' => array('cj-ui-blocks', 'cjaddons-popups'),
		'label_padding' => 'pl-15 pr-15 pt-15 pb-0',
	),
	array(
		'id' => 'popup_display[display_post_meta_keys]',
		'type' => 'post-meta-key-value',
		'label' => __( 'Show with Post Meta', 'addon-unlimited-popups' ),
		'info' => __( 'Show this pop-up single post page and post has this meta key and value.', 'addon-unlimited-popups' ),
		'default' => (isset( $saved_settings['display_post_meta_keys'] )) ? $saved_settings['display_post_meta_keys'] : array(),
		'options' => '',
		'show_gap' => 0,
		'container_class' => 'enable-with-sitewide',
		//'exclude' => array('cj-ui-blocks', 'cjaddons-popups'),
		'label_padding' => 'pl-15 pr-15 pt-15 pb-0',
	),
	array(
		'id' => 'popup_display[display_urls]',
		'type' => 'textarea',
		'label' => __( 'Include URLs', 'addon-unlimited-popups' ) . '<div class="cj-color-danger cj-mt-5 cj-text-normal">' . __( 'This will override all above settings.', 'addon-unlimited-popups' ) . '</div>',
		'info' => __( 'Show this pop-up on specified URLs. Enter one URL per line.', 'addon-unlimited-popups' ),
		'default' => (isset( $saved_settings['display_urls'] )) ? $saved_settings['display_urls'] : '',
		'options' => '',
		'show_gap' => 0,
		'container_class' => 'enable-with-sitewide',
		//'exclude' => array('cj-ui-blocks', 'cjaddons-popups'),
		'label_padding' => 'pl-15 pr-15 pt-15 pb-0',
	),
	array(
		'id' => 'popup_display[display_exclude_urls]',
		'type' => 'textarea',
		'label' => __( 'Exclude URLs', 'addon-unlimited-popups' ) . '<div class="cj-color-danger cj-mt-5 cj-text-normal">' . __( 'This will override all above settings.', 'addon-unlimited-popups' ) . '</div>',
		'info' => __( 'Hide this pop-up on specified URLs. Enter one URL per line.', 'addon-unlimited-popups' ),
		'default' => (isset( $saved_settings['display_exclude_urls'] )) ? $saved_settings['display_exclude_urls'] : '',
		'options' => '',
		'show_gap' => 0,
		'container_class' => 'enable-with-sitewide',
		//'exclude' => array('cj-ui-blocks', 'cjaddons-popups'),
		'label_padding' => 'pl-15 pr-15 pt-15 pb-0',
	)
);
echo '<div class="cssjockey-ui">';
echo '<div class="popup-settings-metabox-form">';
echo $this->helpers->renderAdminForm( $settings_form_fields );
echo '</div>';
echo '</div>';

$field_containers = array();
foreach( $settings_form_fields as $key => $option ) {
	if( $option['id'] != 'popup_display[display-options-info]' && $option['id'] != 'popup_display[entire_website]' ) {
		if(isset($option['container_class']) &&  strpos( $option['container_class'], 'enable-with-sitewide' ) === false ) {
			$field_containers[] = 'div#container-' . $this->helpers->cleanString( $option['id'] );
		}
	}
}
$other_field_selectors = implode( ', ', $field_containers );
?>
<style>

    #cjaddons-unlimited-popups-display-settings-metabox #container-popup-display-entire-website- {
        background-color: #f7f7f7;
    }

    #cjaddons-unlimited-popups-display-settings-metabox .inside {
        margin: 0;
        padding: 0;
    }

    #cjaddons-unlimited-popups-display-settings-metabox .popup-settings-metabox-form .admin-form {
        border: 0;
    }

    #cjaddons-unlimited-popups-display-settings-metabox .popup-settings-metabox-form .admin-form .field {
        margin-bottom: 0;
    }

    #cjaddons-unlimited-popups-display-settings-metabox .popup-settings-metabox-form .admin-form .field label.checkbox {
        margin-bottom: 0;
    }

    #cjaddons-unlimited-popups-display-settings-metabox .popup-settings-metabox-form .admin-form .field label.checkbox input[type="checkbox"] {
        position: relative;
        top: 3px;
    }

    #cjaddons-unlimited-popups-display-settings-metabox .field-display-options-heading h2 {
        padding: 0;
        margin: 0;
    }
</style>
<script>
    jQuery(document).ready(function ($) {
        var checked = $('#container-popup-display-entire-website- input[type="checkbox"]').attr('checked');
        if (checked === undefined) {
            $('<?php echo $other_field_selectors; ?>').removeClass('hidden');
        } else {
            $('<?php echo $other_field_selectors; ?>').addClass('hidden');
        }
        $(document).on('change', '#container-popup-display-entire-website- input[type="checkbox"]', function () {
            if ($(this).attr('checked') === undefined) {
                $('<?php echo $other_field_selectors; ?>').removeClass('hidden');
            } else {
                $('<?php echo $other_field_selectors; ?>').addClass('hidden');
            }
        });

    });
</script>