<?php
if( ! class_exists( 'cjaddons_unlimited_popups_display' ) ) {
	class cjaddons_unlimited_popups_display {
		private static $instance;
		public $helpers;

		public static function getInstance() {
			if( ! isset( self::$instance ) ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		public function __construct() {
			$this->helpers = cjaddons_helpers::getInstance();
			add_action( 'wp_footer', array($this, 'displayPopups') );
		}

		public function checkShouldDisplay( $popup_info ) {
			$return = 0;
			$current_user = wp_get_current_user();
			$settings = (isset( $popup_info['_popup_display_settings'] )) ? $popup_info['_popup_display_settings'] : array();

			// entire website check
			if( isset( $settings['entire_website'] ) && $settings['entire_website'][0] == 'yes' ) {
				$return = 1;
			}

			// homepage
			if( is_front_page() && is_home() && isset( $settings['homepage'] ) && $settings['homepage'] != '' ) {
				$return = 1;
			} elseif( is_front_page() && isset( $settings['homepage'] ) && $settings['homepage'] != '' ) {
				$return = 1;
			} elseif( is_home() && isset( $settings['blog'] ) && $settings['blog'] != '' ) {
				$return = 1;
			}

			// pages
			if( isset( $settings['display_pages'] ) && ! empty( $settings['display_pages'] ) && is_page( $settings['display_pages'] ) ) {
				$return = 1;
			}

			// posts
			if( isset( $settings['display_posts'] ) && ! empty( $settings['display_posts'] ) && is_single( $settings['display_posts'] ) ) {
				$return = 1;
			}

			// categories
			if( isset( $settings['display_categories'] ) && ! empty( $settings['display_categories'] ) && is_category( $settings['display_categories'] ) ) {
				$return = 1;
			}
			if( isset( $settings['display_categories'] ) && is_single() && in_category( $settings['display_categories'] ) && isset( $settings['display_categories_single'] ) && $settings['display_categories_single'] == 'on' ) {
				$return = 1;
			}

			// custom post type
			if( isset( $settings['display_post_types'] ) && ! empty( $settings['display_post_types'] ) && is_post_type_archive( $settings['display_post_types'] ) ) {
				$return = 1;
			}
			if( is_single() && isset( $settings['display_post_types'] ) ) {
				$post_type = get_post_type();
				if( in_array( $post_type, $settings['display_post_types'] ) && isset( $settings['display_post_types_single'] ) && $settings['display_post_types_single'] == 'on' ) {
					$return = 1;
				}
			}

			// custom taxonomy
			if( isset( $settings['display_taxonomies'] ) && ! empty( $settings['display_taxonomies'] ) ) {
				foreach( $settings['display_taxonomies'] as $t_key => $t_value ) {
					$term_data = explode( '~~~~', $t_value );
					$taxonomy = $term_data[1];
					$term = $term_data[0];
					if( is_tax( $taxonomy, $term ) ) {
						$return = 1;
					}
					if( is_singular() && isset( $settings['display_taxonomies_single'] ) && $settings['display_taxonomies_single'] == 'on' ) {
						global $post;
						if( has_term( $term, $taxonomy, $post ) ) {
							$return = 1;
						}
					}
				}
			}

			// post meta check
			if( is_singular() ) {
				global $post;
				$meta_key = (isset( $settings['display_post_meta_keys']['meta_key'] ) && $settings['display_post_meta_keys']['meta_key'] != '') ? $settings['display_post_meta_keys']['meta_key'] : '';
				$meta_value = (isset( $settings['display_post_meta_keys']['meta_value'] ) && $settings['display_post_meta_keys']['meta_value'] != '') ? $settings['display_post_meta_keys']['meta_value'] : '';
				if( $meta_key != '' && $meta_value != '' ) {
					$post_meta = get_post_meta( $post->ID, $meta_key, true );
					if( $post_meta != '' && $post_meta == $meta_value ) {
						$return = 1;
					} else {
						$return = 0;
					}
				}
			}

			// user meta check
			if( $return == 1 && is_user_logged_in() ) {
				$meta_key = (isset( $settings['display_user_meta_keys']['meta_key'] ) && $settings['display_user_meta_keys']['meta_key'] != '') ? $settings['display_user_meta_keys']['meta_key'] : '';
				$meta_value = (isset( $settings['display_user_meta_keys']['meta_value'] ) && $settings['display_user_meta_keys']['meta_value'] != '') ? $settings['display_user_meta_keys']['meta_value'] : '';
				if( $meta_key != '' && $meta_value != '' ) {
					$user_meta = get_user_meta( $current_user->ID, $meta_key, true );
					if( $user_meta != '' && $user_meta == $meta_value ) {
						$return = 1;
					} else {
						$return = 0;
					}
				}
			}

			// user roles
			if( $return == 1 && isset( $settings['display_roles'] ) && ! empty( $settings['display_roles'] ) ) {
				if( ! is_user_logged_in() ) {
					$user_roles = array('visitor');
				} else {
					$user_roles = $current_user->roles;
				}
				$array_intersect = array_intersect( $settings['display_roles'], $user_roles );
				if( ! empty( $array_intersect ) ) {
					$return = 1;
				} else {
					$return = 0;
				}
				if( in_array( 'everyone', $settings['display_roles'] ) ) {
					$return = 1;
				}
			}

			$display_urls = explode( "\n", $settings['display_urls'] );
			$current_url = $this->helpers->currentUrl();
			foreach( $display_urls as $key => $value ) {
				if( sanitize_title( $value ) == sanitize_title( $current_url ) ) {
					return true;
				}
			}

			$display_exclude_urls = explode( "\n", $settings['display_exclude_urls'] );
			$current_url = $this->helpers->currentUrl();
			foreach( $display_exclude_urls as $key => $value ) {
				if( sanitize_title( $value ) == sanitize_title( $current_url ) ) {
					return false;
				}
			}

			return $return;
		}

		public function displayPopups() {
			global $wpdb;
			$popups = $wpdb->get_results( "SELECT * FROM $wpdb->posts WHERE post_type = 'cjaddons-popups' AND post_status = 'publish' ORDER BY menu_order" );
			$display_popups = array();
			if( ! empty( $popups ) ) {
				$count = - 1;
				foreach( $popups as $key => $popup ) {
					$popup_info = $this->helpers->postInfo( $popup->ID );
					$popup_settings = (isset( $popup_info['_popup_settings'] )) ? $popup_info['_popup_settings'] : array();
					$should_display = $this->checkShouldDisplay( $popup_info );
					if( $should_display ) {
						$count ++;
						$display_popups[ $popup_info['ID'] ]['info'] = $popup_info;
						$display_popups[ $popup_info['ID'] ]['settings'] = $popup_settings;
						if( $popup_settings['show_on_click'] == 'no' ) {
							$display_popups[ $popup_info['ID'] ]['settings']['menu_order'] = (int) $count;
						}
					}
				}
			}
			if( ! empty( $display_popups ) ) {
				foreach( $display_popups as $key => $popup ) {
					$this->renderPopup( $popup );
				}
			}
		}

		public function renderPopup( $popup ) {
			$popup_type = $popup['settings']['popup_type'];
			$popup_info = $popup['info'];
			$popup_settings = $popup['settings'];
			$popup_settings['backdrop']['featured_image'] = $popup_info['featured_image_url'];
			$popup_settings_encoded = $popup_settings;
			$popup_settings_encoded['popup_id'] = $popup_info['ID'];
			unset( $popup_settings_encoded['popup_raw_html'] );
			$popup_settings_encoded = json_encode( $popup_settings_encoded );
			require 'html/popups/' . $popup_type . '.php';
		}

		public function popupCloseButton( $settings, $popup_id ) {
			$display = array();
			if( isset( $settings['selected_value'] ) && $settings['selected_value'] == 'yes' ) {
				$button_settings = $settings['items']['yes'];
				$button_position = ($button_settings['button_position'] == 'top-right') ? 'right' : 'left';
				$button_style = array(
					'display' => 'inline-block',
					'padding' => '10px',
					'line-height' => '10px',
					'position' => 'absolute',
					'top' => 0,
					$button_position => 0,
					'background-color' => $button_settings['button_background_color'],
					'color' => $button_settings['button_text_color'],
				);
				$button_style_string = '';
				foreach( $button_style as $key => $value ) {
					$button_style_string .= $key . ':' . $value . ';';
				}
				$display[] = '<a class="cjaddons-close-popup cjaddons-close-popup-button" data-popup-container="#cjaddons-popup-' . $popup_id . '" href="#cjaddons-popup-' . $popup_id . '" style="' . $button_style_string . '">' . $button_settings['button_text'] . '</a>';
			}

			return implode( '', $display );
		}

		public function popupBackdrop( $settings, $popup_id ) {
			$display = array();
			if( isset( $settings['featured_image'] ) ) {
				$display[] = '<div data-popup-container="#cjaddons-popup-' . $popup_id . '" class="cjaddons-close-popup cj-modal-background" style="background-size: cover; background-image: url('.$settings['featured_image'].')"></div>';
			}
			if( isset( $settings['selected_value'] ) && $settings['selected_value'] == 'yes' ) {
				$backdrop = $settings['items']['yes'];
				$opacity = $backdrop['opacity'];
				$opacity_percent = $backdrop['opacity'] / 100;
				$backdrop_style = array(
					'background-color' => $backdrop['background-color'],
					'-ms-filter' => "'progid:DXImageTransform.Microsoft.Alpha(Opacity=" . $opacity . ")'",
					'filter' => 'alpha(opacity=' . $opacity . ')',
					'-moz-opacity' => $opacity_percent,
					'-khtml-opacity' => $opacity_percent,
					'opacity' => $opacity_percent,
				);
				$backdrop_style_string = '';
				foreach( $backdrop_style as $key => $value ) {
					$backdrop_style_string .= $key . ':' . $value . ';';
				}
				$display[] = '<div data-popup-container="#cjaddons-popup-' . $popup_id . '" class="cjaddons-close-popup cj-modal-background" style="' . $backdrop_style_string . '"></div>';
			}

			return implode( '', $display );
		}

	}

	cjaddons_unlimited_popups_display::getInstance();
}