<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
?>

<div class="academy-widget-enroll__add-to-cart academy-widget-enroll__add-to-cart--surecart">
	<?php foreach ( $prices as $price ) : ?>
		<a class="academy-btn academy-btn--bg-purple"
			href="
				<?php
				echo esc_url(
					add_query_arg(
						[
							'line_items' => [
								[
									'price_id' => $price->id,
									'quantity' => 1,
								],
							],
						],
						\SureCart::pages()->url( 'checkout' )
					)
				);
				?>
		">
			<sc-format-number type="currency" currency="<?php echo esc_attr( $price->currency ); ?>" value="<?php echo (int) $price->amount; ?>">
				<?php esc_html_e( 'Add to Cart', 'academy-pro' ); ?>
			</sc-format-number>
			&nbsp;
			<sc-format-interval value="<?php echo (int) $price->recurring_interval_count; ?>" interval="<?php echo esc_attr( $price->recurring_interval ); ?>"></sc-format-interval>
			<?php
			if ( ! empty( $price->name ) ) {
				echo esc_html( '(' . $price->name . ')' );
			}
			?>
		</a>
	<?php endforeach; ?>
</div>


