<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

?>


<?php
if ( $is_enable_academy_login && ! is_user_logged_in() ) :
	?>
	<div class="academy-widget-enroll__continue">
		<button type="button" class="academy-btn academy-btn--bg-purple academy-btn-popup-login">
			<?php esc_html_e( 'Get Membership', 'academy-pro' ); ?>
		</button>
	</div>
<?php elseif ( ! $is_level_reached && ! $is_inactive_membership ) :
	?>
	<div class="academy-widget-enroll__get-membership academy-widget-enroll__get-membership--rcp">
		<a class="academy-btn academy-btn--bg-purple" href="<?php echo esc_url( rcp_get_registration_page_url() ); ?>">
			<?php esc_html_e( 'Get Membership', 'academy-pro' ); ?>
		</a>
	</div>
<?php elseif ( $is_inactive_membership || $is_level_reached ) :
	?>
	<div id="academy_course_enroll_form" class="academy-widget-enroll__enroll-form">
		<button type="button" disabled class="academy-btn academy-btn--bg-red">
		<?php esc_html_e( 'User limit reached or Inactive for this membership level.', 'academy-pro' ); ?>
	</div>
	<?php
	endif;
?>
