<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>

<div class="academy-table academy-table--booking">
	<div class="academy-table__container">
		<div class="academy-table__table academy-table--has-slider">
			<div class="academy-table__head">
				<div class="academy-table__head-row">
					<div class="academy-table__row-cell academy-table__header-row-cell"><?php esc_html_e( 'Title', 'academy-pro' ); ?></div>
					<div class="academy-table__row-cell academy-table__header-row-cell"><?php esc_html_e( 'Schedule date', 'academy-pro' ); ?></div>
					<div class="academy-table__row-cell academy-table__header-row-cell"><?php esc_html_e( 'Duration', 'academy-pro' ); ?></div>
					<div class="academy-table__row-cell academy-table__header-row-cell"><?php esc_html_e( 'Payment', 'academy-pro' ); ?></div>
					<div class="academy-table__row-cell academy-table__header-row-cell"><?php esc_html_e( 'Details', 'academy-pro' ); ?></div>
				</div>
			</div>
			<div class="academy-table__body">
				<?php if ( ! empty( $my_booked ) ) : ?>
				<?php  // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
					foreach ( $my_booked as $booked ) : ?>
						<?php if ( ! empty( $booked->parent['post_title'] ) ) : ?>
					<div class="academy-table__body-row">

					<div class="academy-table__row-cell">
						<div class=""><?php echo esc_html( $booked->parent['post_title'] ); ?></div>
					</div>

					<div class="academy-table__row-cell">
							<?php echo esc_html( $booked->parent['meta']['_academy_booking_schedule_time']['date'] ); ?>
							<?php echo esc_html( $booked->parent['meta']['_academy_booking_schedule_time']['start_time'] ); ?>
					</div>
					<div class="academy-table__row-cell">
							<?php echo esc_html( $booked->parent['meta']['_academy_booking_duration'] ); ?>
					</div>
					<div class="academy-table__row-cell">
							<?php echo esc_html( $booked->parent['meta']['_academy_booking_type'] ); ?>
					</div>
					<div class="academy-table__row-cell">
							<?php echo esc_html( 'Booked Time: ' ); ?>
							<?php echo esc_html( $booked->meta['_academy_booked_schedule_time'] ); ?>
					</div>	
			</div>
			<?php endif; ?>
				<?php endforeach; ?>
			<?php else : ?>
				<div class="academy-oops academy-oops__message">
					<div class="academy-oops__icon">
						<img src="<?php // phpcs:ignore PluginCheck.CodeAnalysis.ImageFunctions.NonEnqueuedImage
						echo esc_url( ACADEMY_ASSETS_URI . 'images/NoDataAvailable.svg' ); ?>" alt="oops">
					</div>
					<h3 class="academy-oops__heading"><?php esc_html_e( 'No data Available!!', 'academy-pro' ); ?></h3>
					<h3 class="academy-oops__text"><?php esc_html_e( 'Sorry you have no tutor booked schedule.', 'academy-pro' ); ?></h3>
				</div>
			<?php endif; ?>
		</div>
	</div>
</div>
