<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<div class="academy-table academy-table--booking">
	<div class="academy-table__container">
		<div class="academy-table__table academy-table--has-slider">
			<div class="academy-table__head">
				<div class="academy-table__head-row">
					<div class="academy-table__row-cell academy-table__header-row-cell"><?php esc_html_e( 'Device', 'academy-pro' ); ?></div>
					<div class="academy-table__row-cell academy-table__header-row-cell"><?php esc_html_e( 'Browser', 'academy-pro' ); ?></div>
					<div class="academy-table__row-cell academy-table__header-row-cell"><?php esc_html_e( 'Platform', 'academy-pro' ); ?></div>
					<div class="academy-table__row-cell academy-table__header-row-cell"><?php esc_html_e( 'Time', 'academy-pro' ); ?></div>
					<div class="academy-table__row-cell academy-table__header-row-cell"><?php esc_html_e( 'Location', 'academy-pro' ); ?></div>
					<div class="academy-table__row-cell academy-table__header-row-cell"><?php esc_html_e( 'Action', 'academy-pro' ); ?></div>
				</div>
			</div>
			<div class="academy-table__body">
				<?php if ( ! empty( $login_info ) ) : ?>
					<?php  // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
					foreach ( $login_info as $info ) :
						$meta_value = json_decode( $info->meta_value ); ?>
					<div class="academy-table__body-row">

					<div class="academy-table__row-cell">
						<div class=""><?php echo esc_html( $meta_value->device ); ?></div>
					</div>					
					<div class="academy-table__row-cell">
						<div class=""><?php echo esc_html( $meta_value->browser ); ?></div>
					</div>

					<div class="academy-table__row-cell">
						<?php echo esc_html( $meta_value->platform ); ?>
					</div>
					<div class="academy-table__row-cell">
						<?php
						$datetime = gmdate( 'H:i:s F Y', (int) $meta_value->time );
						echo esc_html( $datetime ); ?>
					</div>
					<div class="academy-table__row-cell">
							<?php
							$city = $meta_value->location->city ?? '';
							$country = $meta_value->location->country ?? '';
							$location = trim( $city . ' ' . $country );
							$location = $location ? $location : __( 'Unknown', 'academy-pro' );
							echo esc_html( $location ); ?>
					</div>
					<div class="academy-table__row-cell">
							<button class="academy-btn academy-btn--preset-red academy-btn--xs user-device-reset" data-reset="<?php echo esc_attr( $info->meta_key ); ?>">
								<?php esc_html_e( 'Remove', 'academy-pro' ); ?>
							</button>
					</div>
			</div>
				<?php endforeach; ?>
			<?php else : ?>
				<div class="academy-oops academy-oops__message">
					<div class="academy-oops__icon">
						<img src="<?php // phpcs:ignore PluginCheck.CodeAnalysis.ImageFunctions.NonEnqueuedImage
						echo esc_url( ACADEMY_ASSETS_URI . 'images/NoDataAvailable.svg' ); ?>" alt="oops">
					</div>
					<h3 class="academy-oops__heading"><?php esc_html_e( 'No data Available!!', 'academy-pro' ); ?></h3>
					<h3 class="academy-oops__text"><?php esc_html_e( 'Sorry you have no device login session.', 'academy-pro' ); ?></h3>
				</div>
			<?php endif; ?>
		</div>
	</div>
</div>
