<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$prerequisite = $data ?? [];

?>

<div class="academy-lessons-content--topic-error">
	<div>
		<div class="academy-render-topic-error-data">
			<span class="academy-icon academy-icon--information"></span>
			<span class="academy-render-topic-error-message">
				<?php echo esc_html( $message ); ?>
			</span>
		</div>
		<ul class="academy-prerequisite-item-list">
			<?php foreach ( $prerequisite as $prerequisites ) : ?>
			<li class="academy-prerequisite-item">
				<button class="academy-btn--lesson" type="button">
					<i class="<?php echo esc_attr( \Academy\Helper::get_topic_icon_class_name( $prerequisites['type'] ) ); ?>" aria-hidden="true"></i>
					<span class="academy-btn--label"><?php echo esc_html( $prerequisites['label'] ); ?></span>
				</button>
			</li>
			<?php endforeach; ?>
		</ul>
	</div>
</div>
