<div class="academy-assignment-content__wrapper">
	<div class="academy-assignment-content__body academy-assignment-content__wrapper">
		<div class="academy-assignment-content__submission">
			<form action="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>" method="post" enctype="multipart/form-data">
				<?php wp_nonce_field( 'academy_nonce', 'security' ); ?>
				<input type="hidden" value="academy_pro_submit_assignment" name="action"/>
				<input type="hidden" value="<?php echo esc_attr( $assignment->ID ); ?>" name="assignment_id"/>
				<input type="hidden" value="<?php echo esc_attr( $course_id ); ?>" name="course_id"/>
				<input type="hidden" value="<?php echo esc_attr( $assignment->submitted_assignment->comment_ID ); ?>" name="assignment_comment_id">
				<h5 class="academy-assignment-content__details-title">
					<?php echo esc_html__( 'Assignment ReSubmission', 'academy-pro' ); ?>
				</h5>
				<p><?php echo esc_html__( 'Assignment Answer Form', 'academy-pro' ); ?></p>
				<div class="academy-editor-wrapper">
					<div class="form-group">
						<div class="form-info">
							<label for="assignment_answer_2">
								<?php echo esc_html__( 'Write Your Answer', 'academy-pro' ); ?>
							</label>
						</div>
						<div class="form-body">
							<textarea id="assignment_answer_2" name="assignment_ans" cols="55"></textarea>
						</div>
					</div>
				</div>
				<div class="academy-attachment">
					<div class="academy-component-upload-attachment">
						<div class="academy-entry-right">
							<p>
								<strong>
									<?php esc_html_e( 'Uploaded File: ', 'academy-pro' ); ?>
								</strong>
								<?php
								$extension = pathinfo( $assignment->attachment['url'], PATHINFO_EXTENSION );
								echo esc_html( get_the_title( $assignment->submitted_assignment->meta['academy_pro_assignment_attachment'] ) . '.' . $extension ); ?>
							</p>
							<p>
								<strong>
									<?php echo esc_html__( 'Size : ', 'academy-pro' ); ?>
								</strong>
								<?php echo esc_html__( '700 x 430 pixels', 'academy-pro' ); ?>
							</p>
							<input type="file" name="attachment" class="academy-btn academy-btn--sm academy-btn--preset-light-purple">
						</div>
					</div>
				</div>
				<button type="submit" name="submit_assignment" class="academy-btn academy-btn--md academy-btn--preset-purple">
					<span class="academy-btn--label">
						<?php echo esc_html__( 'Submit Assignment', 'academy-pro' ); ?>
					</span>
				</button>
			</form>
		</div>
	</div>
</div>
