<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$assignment = \AcademyProAssignments\Helper::render_assignment_for_php_rendering( $course_id, $assignment_id );
$submitted_assignment = $assignment->submitted_assignment ?? '';
$assignment_status = $submitted_assignment->comment_approved ?? '';
$submission_time = $assignment->settings['submission_time'];
$remaining_time = 0;
if ( 'submitting' === $assignment_status && $submission_time > 0 ) {
	$remaining_time = \AcademyProAssignments\Helper::get_the_remaining_time_of_an_assignment_in_php_render( $submitted_assignment->comment_date_gmt, $submission_time, $assignment );
}
$total_attempt = get_option( 'academy_pro_assignment_' . ( $submitted_assignment->comment_ID ?? 0 ) . '_submission_attempt', 0 );

?>

<div class="academy-assignment-content__header">
	<div class="academy-assignment-header__header-item">
		<p class="academy-assignment-header__label">
			<?php echo esc_html__( 'Duration : ', 'academy-pro' ); ?>
		</p>
		<p class="academy-assignment-header__data">
			<?php
				$duration = esc_html( $assignment->settings['submission_time'] . ' ' . AcademyProAssignments\Helper::get_date_time_translations( $assignment->settings['submission_time_unit'] ) );
			if ( 0 === intval( $assignment->settings['submission_time'] ) ) {
				$duration = esc_html__( 'No Time Limit', 'academy-pro' );
			}
			echo esc_attr( $duration ); ?>
		</p>
	</div>
	<div class="academy-assignment-header__header-item">
		<p class="academy-assignment-header__label">
			<?php echo esc_html__( 'Total Attempted : ', 'academy-pro' ); ?>
		</p>
		<p class="academy-assignment-header__data">
			<?php echo esc_html( $total_attempt ); ?>
		</p>
	</div>
	<?php if ( ! empty( $remaining_time ) && 1 !== $remaining_time->invert ) : ?>
		<div class="academy-assignment-header__header-item">
			<p class="academy-assignment-header__label"><?php echo esc_html__( 'Deadline : ', 'academy-pro' ); ?> </p>
			<p class="academy-assignment-header__data">
				<span class="academy-timer">
					<div class="academy-countdown__time">
						<div class="academy-countdown__details">
							<span class="academy-time__value"><?php echo esc_html( $remaining_time->days ); ?></span>
							<span class="academy-time__unit"><?php echo esc_html__( ' days ', 'academy-pro' ); ?></span>
						</div>
						<div class="academy-countdown__details">
							<span class="academy-time__value"><?php echo esc_html( $remaining_time->h ); ?></span>
							<span class="academy-time__unit"><?php echo esc_html__( ' hours ', 'academy-pro' ); ?></span>
						</div>
						<div class="academy-countdown__details">
							<span class="academy-time__value"><?php echo esc_html( $remaining_time->i ); ?></span>
							<span class="academy-time__unit"><?php echo esc_html__( ' minutes ', 'academy-pro' ); ?></span>
						</div>
						<div class="academy-countdown__details">
							<span class="academy-time__value"><?php echo esc_html( $remaining_time->s ); ?></span>
							<span class="academy-time__unit"><?php echo esc_html__( ' seconds ', 'academy-pro' ); ?></span>
						</div>
					</div>
				</span>
			</p>
		</div>
	<?php endif; ?>
	<?php if ( ! empty( $remaining_time ) && 1 === $remaining_time->invert ) : ?>
		<div class="academy-assignment-header__header-item">
			<p class="academy-assignment-header__label">
				<?php echo esc_html__( 'Deadline:', 'academy-pro' ); ?>
			</p>
			<p class="academy-assignment-header__data">
				<span class="academy-assignment-countdown-expired">
					<?php echo esc_html__( 'Expired', 'academy-pro' ); ?>
				</span>
			</p>
		</div>
	<?php endif; ?>
	<div class="academy-assignment-header__header-item">
		<p class="academy-assignment-header__label">
			<?php echo esc_html__( 'Total Marks : ', 'academy-pro' ); ?>
		</p>
		<p class="academy-assignment-header__data">
			<?php echo esc_html( $assignment->settings['total_points'] ); ?>
		</p>
	</div>
	<div class="academy-assignment-header__header-item">
		<p class="academy-assignment-header__label">
			<?php echo esc_html__( 'Passing Marks : ', 'academy-pro' ); ?>
		</p>
		<p class="academy-assignment-header__data">
			<?php echo esc_html( $assignment->settings['minimum_passing_points'] ); ?>
		</p>
	</div>
</div>
