<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$assignment_status = $submitted_assignment->comment_approved ?? '';
$attachment = $submitted_assignment->meta['academy_pro_assignment_attachment'];
$attachment_url = $attachment ? wp_get_attachment_url( $attachment ) : '';
$attachment_name = $attachment ? get_the_title( $attachment ) : '';
$instructor_feedback = $submitted_assignment->meta['academy_pro_assignment_evaluate_feedback'];
?>
<div class="academy-submitted-assignment__wrapper">
	<div class="academy-submitted-assignment__top">
		<div class="academy-submitted-assignment__top-left">
			<div class="academy-submitted-assignment__instructor-feedback">
				<h3 class="academy-submitted-assignment__title">
					<?php esc_html_e( 'Instructor Feedback', 'academy-pro' ); ?>
				</h3>
				<p class="academy-submitted-assignment__instructor-comment">
					<?php echo esc_attr( $instructor_feedback ); ?>
				</p>
				</div>
			<div class="academy-submitted-assignment__top-title">
				<h3 class="academy-submitted-assignment__title">
					<?php esc_html_e( 'Your Assignment', 'academy-pro' ); ?>
				</h3>
				<?php if ( 'submitted' === $assignment_status ) : ?>
					<a href="<?php echo esc_url( add_query_arg( 'update', '1', remove_query_arg( 'update' ) ) ); ?>">
						<button class="academy-btn academy-btn--md academy-btn--preset-purple" type="button">
							<span class="academy-btn--label">
								<?php esc_html_e( 'Edit', 'academy-pro' ); ?>
							</span>
						</button>
					</a>
				<?php elseif ( $submitted_assignment->has_permission_submitted ) : ?>
					<a href="<?php echo esc_url( add_query_arg( array( 'resubmit' => '1' ), $_SERVER['REQUEST_URI'] ) );// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotValidated, WordPress.Security.ValidatedSanitizedInput.MissingUnslash, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized ?>">
						<button class="academy-btn academy-btn--md academy-btn--preset-purple" type="button">
							<span class="academy-btn--label">
								<?php echo esc_html__( 'Resubmit', 'academy-pro' ); ?>
							</span>
						</button>
					</a>
				<?php endif ?>
			</div>
			<p class="academy-submitted-assignment__content">
				<?php echo esc_html( $submitted_assignment->comment_content ?? '' ); ?>
			</p>
		</div>
	</div>
	<?php if ( ! empty( $attachment_url ) ) : ?>
		<a class="academy-download-attachment" href="<?php echo esc_url( $attachment_url ); ?>" download>
			<p class="academy-download-attachment__name">
				<?php echo esc_html( $attachment_name ); ?>
			</p>
			<!--- Download image goes here -->
		</a>
	<?php endif; ?>
</div>
