<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$assignment_status = $submitted_assignment->comment_approved ?? '';

?>

<div class="academy-quiz-table-wrapper">
	<div class="academy-list-wrap academy-dashboard__content">
		<div class="academy-table academy-table--lesson-assignment">
			<div class="academy-table__container">
				<div class="academy-table__table academy-table--has-slider">
					<div class="academy-table__head">
						<div class="academy-table__head-row">
							<div class="academy-table__row-cell academy-table__header-row-cell">
								<?php echo esc_html__( 'Date', 'academy-pro' ); ?>
							</div>
							<div class="academy-table__row-cell academy-table__header-row-cell">
								<?php echo esc_html__( 'Total Marks', 'academy-pro' ); ?>
							</div>
							<div class="academy-table__row-cell academy-table__header-row-cell">
								<?php echo esc_html__( 'Pass Marks', 'academy-pro' ); ?>
							</div>
							<div class="academy-table__row-cell academy-table__header-row-cell">
								<?php echo esc_html__( 'Earned Marks', 'academy-pro' ); ?>
							</div>
							<div class="academy-table__row-cell academy-table__header-row-cell">
								<?php echo esc_html__( 'Results', 'academy-pro' ); ?>
							</div>
						</div>
					</div>
					<div class="academy-table__body">
						<div class="academy-table__body-row">
							<div class="academy-table__row-cell">
								<?php $submit_date = new DateTime( $submitted_assignment->comment_date );
								echo esc_html( $submit_date->format( 'F jS, Y h:i:s A' ) ) ?>
							</div>
							<div class="academy-table__row-cell">
								<?php echo esc_html( $submitted_assignment->academy_assignment_settings['total_points'] ); ?>
							</div>
							<div class="academy-table__row-cell">
								<?php echo esc_html( $submitted_assignment->academy_assignment_settings['minimum_passing_points'] ); ?>
							</div>
							<div class="academy-table__row-cell">
								<?php echo esc_html( $submitted_assignment->meta['academy_pro_assignment_evaluate_point'] ); ?>
							</div>
							<div class="academy-table__row-cell">
								<span class="academy-<?php echo esc_attr( $assignment_status ); ?>">
									<?php echo esc_html( $assignment_status ); ?>
								</span>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
