<?php
/**
 * The Template for displaying all single courses
 *
 * This template can be overridden by copying it to yourtheme/academy/single-course.php.
 *
 * the readme will list any important changes.
 *
 * @version     1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

	academy_get_header( 'bundle' );

		/**
		 * @hook - academy_pro/templates/course_bundle/before_main_content
		 */
		do_action( 'academy_pro/templates/course_bundle/before_main_content', 'single-bundle.php' );
?>
		<div class="academy-single-bundle">
			<div class="academy-container">
				<div class="academy-row">
					<?php while ( have_posts() ) : ?>
						<?php the_post(); ?>

						<?php \AcademyPro\Helper::get_template_part( 'course-bundle/content', 'single-bundle' ); ?>
					<?php endwhile; // end of the loop. ?>

					<?php
						/**
						 * @hook - academy/templates/single_course_sidebar
						 *
						 * @hooked academy_single_course_sidebar  - 10
						 */
						do_action( 'academy_pro/templates/course_bundle/single_bundle_sidebar' );
					?>
				</div>
			</div>
		</div>
	<?php
		/**
		 * @hook - academy/templates/after_main_content
		 */
		do_action( 'academy_pro/templates/course_bundle/after_main_content', 'single-bundle.php' );
	?>

<?php
	academy_get_footer( 'bundle' );
