<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
?>

<?php if ( ! $enrolled ) : ?>
	<div class="academy-widget-enroll__head">
		<?php
		if ( $price ) {
			echo '<div class="academy-course-price">' . wp_kses_post( $price ) . '</div>';
		} else {
			echo '<div class="academy-course-type">' . esc_html__( 'Paid', 'academy-pro' ) . '</div>';
		}

		do_action( 'academy_pro/templates/course_bundle/after_bundle_price', $regular_price, $sale_price );
		?>
	</div>
<?php else : ?>
	<div class="academy-widget-enroll__enrolled-info">
		<?php
			// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
			echo sprintf(
				// translators: %s: Enrollment date
				esc_html__( 'You have been enrolled on %s', 'academy-pro' ),
				wp_kses_post(
					'<span>' . date_i18n(
						get_option( 'date_format' ),
						strtotime( $enrolled->post_date )
					) . '</span>'
				)
			);
		?>
	</div>
<?php endif; ?>
