<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
?>

<div class="academy-widget-enroll__content">
	<ul class="academy-widget-enroll__content-lists">
		<?php if ( $duration ) : ?>
		<li>
			<span class="label">
				<span class="academy-icon academy-icon--clock"></span>
			<?php esc_html_e( 'Duration', 'academy-pro' ); ?>
			</span>
			<span class="data"><?php echo esc_html( $duration ); ?></span>
		</li>
		<?php endif; ?>
		<?php if ( $total_lessons ) : ?>
		<li>
			<span class="label">
				<i class="academy-icon academy-icon--lesson"></i>
			<?php esc_html_e( 'Lessons', 'academy-pro' ); ?>
			</span>
			<span class="data"><?php echo esc_html( $total_lessons ); ?></span>
		</li>
		<?php endif; ?>
		<?php if ( $total_enrolled && $total_enroll_count_status ) : ?>
		<li>
			<span class="label">
				<i class="academy-icon academy-icon--group-profile"></i>
			<?php esc_html_e( 'Enrolled', 'academy-pro' ); ?>
			</span>
			<span class="data"><?php echo esc_html( $total_enrolled ); ?></span>
		</li>
		<?php endif; ?>
		<?php if ( $max_students ) : ?>
		<li>
			<span class="label">
				<span class="academy-icon academy-icon--group-profile"></span>
			<?php esc_html_e( 'Available Seats', 'academy-pro' ); ?>
			</span>
			<span class="data"><?php echo esc_html( $max_students - $total_enrolled ); ?></span>
		</li>
		<?php endif; ?>

		<?php if ( $last_update ) : ?>
		<li>
			<span class="label">
				<i class="academy-icon academy-icon--calender"></i>
			<?php esc_html_e( 'Last Update', 'academy-pro' ); ?>
			</span>
			<span class="data"><?php echo esc_html( $last_update ); ?></span>
		</li>
		<?php endif; ?>
	</ul>
</div>
