<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
?>
<div class="academy-single-bundle__course-items academy-single-bundle__course-items--list">
	<h2 class="academy-single-bundle__content-item--list-title"><?php esc_html_e( 'Courses in the Bundle', 'academy-pro' ); ?></h2>
	<?php
		$course_ids = (array) get_post_meta( get_the_ID(), 'academy_course_bundle_courses_ids', true );
		$course_ids = wp_list_pluck( $course_ids, 'value' );
	if ( $course_ids ) :
		$course_args = array(
			'post_type'         => 'academy_courses',
			'post_status'       => 'publish',
			'post__in'          => $course_ids,
			'posts_per_page'    => -1,
		);

		$courses = new \WP_Query( $course_args );
		if ( $courses->have_posts() ) :
			while ( $courses->have_posts() ) :
				$courses->the_post(); ?>
					<div class="academy-course-bundle-single-course">
						<div class="academy-course-bundle-single-course__thumbnail">
							<a href="<?php echo esc_url( get_permalink( get_the_ID() ) ); ?>">
								<?php
								$thumbnail_url = get_the_post_thumbnail_url( get_the_ID(), 'thumbnail' );
								if ( ! $thumbnail_url ) {
									$thumbnail_url = ACADEMY_ASSETS_URI . '/images/thumbnail-placeholder.png';
								}
								?>
								<?php
								// phpcs:ignore PluginCheck.CodeAnalysis.ImageFunctions.NonEnqueuedImage ?>
								<img src="<?php echo esc_url( $thumbnail_url ); ?>" alt="<?php echo esc_attr( get_the_title() ); ?>">
							</a>
						</div>
						<div class="academy-course-bundle-single-course__content">
							<h5>
								<a href="<?php echo esc_url( get_permalink( get_the_ID() ) ); ?>">
								<?php echo esc_attr( the_title() ); ?>
								</a>
							</h5>
							<div class="author">
								<?php esc_html_e( 'By', 'academy-pro' ); ?> 
								<?php
								$author_id = absint( get_the_author_meta( 'ID' ) );
								if ( \Academy\Helper::get_addon_active_status( 'multi_instructor' ) ) {
									$instructors = \Academy\Helper::get_instructors_by_course_id( get_the_ID() );
								} else {
									$instructors = \Academy\Helper::get_instructor_by_author_id( $author_id );
								}

								$show_instructor_public_profile = Academy\Helper::get_settings( 'is_show_public_profile' );
								?>
								<?php foreach ( $instructors as $instructor ) : ?>
									<?php if ( $show_instructor_public_profile ) : ?>
									<a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID', $instructor->ID ) ) ); ?>">
										<?php echo esc_attr( $instructor->display_name ); ?>
									</a>&nbsp;
									<?php else : ?>
									<span>
										<?php echo esc_attr( $instructor->display_name ); ?>
									</span>&nbsp;
									<?php endif; ?>
								<?php endforeach; ?>
							</div>
							<p><?php the_excerpt(); ?></p>
						</div>
					</div>
					<?php
				endwhile;
			wp_reset_postdata();
			endif;
		endif;
	?>
</div>
