<?php

// For older (pre-2.7.2) verions of google/apiclient
if (
    file_exists(__DIR__ . '/../apiclient/src/Google/Client.php')
    && !class_exists('AcademyPro_Google_Client', false)
) {
    require_once(__DIR__ . '/../apiclient/src/Google/Client.php');
    if (
        defined('AcademyPro_Google_Client::LIBVER')
        && version_compare(AcademyPro_Google_Client::LIBVER, '2.7.2', '<=')
    ) {
        $servicesClassMap = [
            'AcademyPro\\Google\\Client' => 'AcademyPro_Google_Client',
            'AcademyPro\\Google\\Service' => 'AcademyPro_Google_Service',
            'AcademyPro\\Google\\Service\\Resource' => 'AcademyPro_Google_Service_Resource',
            'AcademyPro\\Google\\Model' => 'AcademyPro_Google_Model',
            'AcademyPro\\Google\\Collection' => 'AcademyPro_Google_Collection',
        ];
        foreach ($servicesClassMap as $alias => $class) {
            class_alias($class, $alias);
        }
    }
}
spl_autoload_register(function ($class) {
    if (0 === strpos($class, 'Google_Service_')) {
        // Autoload the new class, which will also create an alias for the
        // old class by changing underscores to namespaces:
        //     Google_Service_Speech_Resource_Operations
        //      => AcademyPro\Google\Service\Speech\Resource\Operations
        $classExists = class_exists($newClass = str_replace('_', '\\', $class));
        if ($classExists) {
            return true;
        }
    }
}, true, true);
