<?php
namespace  AcademyPro\Shortcode;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class LoginRegister {
	public static function init() {
		$self = new self();
		if ( \Academy\Helper::get_settings( 'is_enabled_recaptcha', false ) ) {
			// recaptcha
			add_action( 'academy/templates/login_form_before_submit', [ $self, 'add_google_recaptcha_markup' ] );
			add_action( 'academy/templates/instructor_reg_form_before_submit', [ $self, 'add_google_recaptcha_markup' ] );
			add_action( 'academy/templates/student_reg_form_before_submit', [ $self, 'add_google_recaptcha_markup' ] );
			// verify captcha
			add_action( 'academy/shortcode/before_login_signon', array( $self, 'verify_recaptcha_registration' ) );
			add_action( 'academy/shortcode/before_student_registration', array( $self, 'verify_recaptcha_registration' ) );
			add_action( 'academy/shortcode/before_instructor_registration', array( $self, 'verify_recaptcha_registration' ) );
		}

	}
	public function add_google_recaptcha_markup() {
		$recaptcha_type = \Academy\Helper::get_settings( 'recaptcha_type', 'v2' );
		if ( 'v3' === $recaptcha_type ) {
			?>
			<div class="academy-form-group">
				<input type="hidden" id="g-recaptcha-response" name="g-recaptcha-response">
			</div>
			<?php
		} else {
			?>
			<div class="academy-form-group">
				<div class="g-recaptcha" data-sitekey="<?php echo esc_attr( \Academy\Helper::get_settings( 'recaptcha_v2_site_key', false ) ); ?>"></div>
			</div>
			<?php
		}
	}

	public function verify_recaptcha_registration( $user_data ) {
		$recaptcha_type   = \Academy\Helper::get_settings( 'recaptcha_type', 'v2' );
		$recaptcha_secret = '';
		if ( 'v2' === $recaptcha_type ) {
			$recaptcha_secret = \Academy\Helper::get_settings( 'recaptcha_v2_secret_key', '' );
		} else {
			$recaptcha_secret = \Academy\Helper::get_settings( 'recaptcha_v3_secret_key', '' );
		}
		// phpcs:ignore WordPress.Security.NonceVerification.Missing, WordPress.Security.ValidatedSanitizedInput.InputNotValidated, WordPress.Security.ValidatedSanitizedInput.MissingUnslash, WordPress.Security.ValidatedSanitizedInput.InputNotValidated, WordPress.Security.ValidatedSanitizedInput.MissingUnslash, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
		$verify               = $this->verify_recaptcha( sanitize_text_field( $_POST['g-recaptcha-response'] ), $_SERVER['REMOTE_ADDR'], $recaptcha_secret );
		if ( false === $verify ) {
			wp_send_json_error( [ __( 'Captcha is not matching, please try again.', 'academy-pro' ) ] );
		}
	}

	public function verify_recaptcha( $form_recaptcha_response, $server_remoteip, $recaptcha_secret_key ) {
		$google_url             = 'https://www.google.com/recaptcha/api/siteverify';
		$google_response        = add_query_arg(
			array(
				'secret'   => $recaptcha_secret_key,
				'response' => $form_recaptcha_response,
				'remoteip' => $server_remoteip,
			),
			$google_url
		);
		$google_response        = wp_remote_get( $google_response );
		$decode_google_response = json_decode( $google_response['body'] );
		return $decode_google_response->success;
	}


}
