<?php
namespace AcademyPro;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Migration {

	public static function init() {
		$self = new self();
		$self->run_migration();
	}

	public function run_migration() {
		$academy_pro_version = get_option( 'academy_pro_version' );
		if ( version_compare( $academy_pro_version, '2.5.1', '<' ) ) {
			add_option( 'academy_pro_run_email_migration', true );
		}

		if ( version_compare( $academy_pro_version, '2.9.1', '<' ) ) {
			add_option( 'academy_pro_run_email_migration_2_9_0', true );
		}

		if ( version_compare( $academy_pro_version, '2.7.1', '<' ) ) {
			add_option( 'academy_pro_run_email_migration_2_7_0', true );
		}

		$this->migrate_zoom_addon_data_to_meeting_addon();

		// Notification migrate
		$this->migrate_2_2_4( $academy_pro_version );

		// assignment migrate
		if ( ! get_option( 'academy_assignments_meta_update_2_8_0' ) ) {
			$this->migrate_2_8_0();
		}

		// Save Version Number
		if ( ACADEMY_PRO_VERSION !== $academy_pro_version ) {
			update_option( 'academy_pro_version', ACADEMY_PRO_VERSION );
		}
	}

	public function migrate_zoom_addon_data_to_meeting_addon() {
		if ( \Academy\Helper::get_addon_active_status( 'zoom' ) && ! get_option( 'academy_pro_has_migrate_zoom_addon_data' ) ) {
			$zooms = get_posts(array(
				'post_status' => 'publish',
				'post_type'   => 'academy_zoom'
			));
			if ( is_array( $zooms ) && ! empty( $zooms ) ) {
				foreach ( $zooms as $zoom ) {
					wp_update_post(
						array(
							'ID'        => $zoom->ID,
							'post_type' => 'academy_meeting'
						)
					);
					$courses = get_posts(array(
						'post_type' => 'academy_courses',
						'post_status' => 'publish'
					));
					foreach ( $courses as $course ) {
						$curriculums = get_post_meta( $course->ID, 'academy_course_curriculum', true );
						if ( is_array( $curriculums ) ) {
							foreach ( $curriculums as $key => $curriculum ) {
								foreach ( $curriculum['topics'] as $subkey => $topics ) {
									if ( 'zoom' === $topics['type'] && $zoom->ID === $topics['id'] ) {
										$curriculums[ $key ]['topics'][ $subkey ]['type'] = 'meeting';
									}

									if ( 'sub-curriculum' === $topics['type'] ) {
										foreach ( $topics['topics'] as $SubKey => $sub_curriculum ) {
											if ( 'zoom' === $sub_curriculum['type'] && $zoom->ID === $sub_curriculum['id'] ) {
												$curriculums[ $key ]['topics'][ $subkey ]['topics'][ $SubKey ]['type'] = 'meeting';
											}
										}
									}
								}
								update_post_meta( $course->ID, 'academy_course_curriculum', $curriculums );
							}
						}
					}//end foreach
					$zoom_request = get_post_meta( $zoom->ID, 'academy_zoom_request', true );
					$zoom_response = get_post_meta( $zoom->ID, 'academy_zoom_response', true );
					update_post_meta( $zoom->ID, 'academy_meeting_type', 'zoom' );
					update_post_meta( $zoom->ID, 'academy_meeting_request', $zoom_request );
					update_post_meta( $zoom->ID, 'academy_meeting_response', $zoom_response );
				}//end foreach
			}//end if
			add_option( 'academy_pro_has_migrate_zoom_addon_data', true );
		}//end if
	}

	public function migrate_2_2_4( $academy_pro_version ) {
		if ( ! \Academy\Helper::get_addon_active_status( 'notifications' ) ) {
			return;
		}
		if ( ! get_option( 'academy_pro_notifications_migrate_2_4' ) && version_compare( $academy_pro_version, '2.2.4', '>' ) ) {
			global $wpdb;
			$table_name = $wpdb->prefix . ACADEMY_PLUGIN_SLUG . '_notifications';
			// Check if the column exists
			// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching,  WordPress.DB.PreparedSQL.InterpolatedNotPrepared
			$column_exists = $wpdb->get_results( "SHOW COLUMNS FROM `$table_name` LIKE 'topic_id'" );

			if ( empty( $column_exists ) ) {
				// Add the new column
				// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.DirectDatabaseQuery.SchemaChange, WordPress.DB.PreparedSQL.InterpolatedNotPrepared
				$wpdb->query( "ALTER TABLE `$table_name` ADD `topic_id` BIGINT(20) UNSIGNED NULL AFTER `post_id`" );
			}
			add_option( 'academy_pro_notifications_migrate_2_4', true );
		}
	}

	public function migrate_2_8_0() {
		$assignments = get_posts([
			'post_status' => 'publish',
			'post_type' => 'academy_assignments',
			'numberposts' => -1
		]);
		if ( is_array( $assignments ) && ! empty( $assignments ) ) {
			foreach ( $assignments as $assignment ) {
				update_post_meta( $assignment->ID, 'academy_assignment_enable_resubmit', false );
				update_post_meta( $assignment->ID, 'academy_assignment_resubmit_limit', 0 );
			}
		}
		add_option( 'academy_assignments_meta_update_2_8_0', true );
	}
}
