<?php
namespace AcademyPro\Classes;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


class Duplicate {
	public function update_course_post_meta( $old_course_id, $new_course_id ) {
		$metadata = get_post_meta( $old_course_id );
		unset( $metadata['academy_course_curriculum'] );
		foreach ( $metadata as $key => $value ) {
			$value = is_array( $value ) ? ( isset( $value[0] ) ? $value[0] : '' ) : '';
			// phpcs:ignore WordPress.PHP.DiscouragedPHPFunctions.serialize_unserialize
			$value = is_serialized( $value ) ? unserialize( $value ) : $value;
			update_post_meta( $new_course_id, $key, $value );
		}
	}

	public function duplicate_course_curriculum( $old_course_id, $new_course_id ) {
		// duplicate course curriculum
		$curriculums = get_post_meta( $old_course_id, 'academy_course_curriculum', true );
		if ( is_array( $curriculums ) ) {
			$new_curriculum = array();
			foreach ( $curriculums as $curriculum ) {
				$new_topics = array();
				foreach ( $curriculum['topics'] as $topic ) {
					if ( is_array( $topic ) ) {
						switch ( $topic['type'] ) {
							case 'lesson':
								$lesson = \Academy\Helper::get_lesson( $topic['id'] );
								$new_lesson_id = $this->duplicate_lesson_insert( $lesson, 'lesson_duplicate' );
								if ( $new_lesson_id ) {
									$this->duplicate_lesson_meta_insert( $topic['id'], $new_lesson_id );
								}
								$new_topics[] = array(
									'id' => $new_lesson_id,
									'name' => $lesson->lesson_title,
									'type'  => 'lesson',
								);
								break;
							case 'quiz':
								$new_quiz_id = $this->duplicate_quiz( $topic['id'], 'quiz_duplicate' );
								$this->duplicate_quiz_meta( $topic['id'], $new_quiz_id );
								$questions = \AcademyQuizzes\Classes\Query::get_questions_by_quid_id( $topic['id'] );
								if ( $questions ) {
									$this->quiz_questions_answer_insert( $questions, $new_quiz_id );
								}
								$new_topics[] = array(
									'id' => $new_quiz_id,
									'name' => $topic['name'],
									'type'  => 'quiz',
								);
								break;
							case 'assignment':
								$new_topics[] = $this->duplicate_assignment_value( $topic['id'] );
								break;
							case 'zoom':
								$new_topics[] = $this->duplicate_zoom_value( $topic['id'] );
								break;
							case 'booking':
								$new_topics[] = $this->duplicate_booking_value( $topic['id'] );
								break;
						}//end switch
					}//end if
				}//end foreach
				$new_curriculum[] = array(
					'title' => (string) $curriculum['title'] ? $curriculum['title'] : 'Academy Topics',
					'content' => $curriculum['content'],
					'topics' => $new_topics,
				);
			}//end foreach
			if ( is_array( $new_curriculum ) ) {
				update_post_meta( $new_course_id, 'academy_course_curriculum', $new_curriculum );
			}
		}//end if
	}

	public function update_course_slug( $old_course_id, $new_duplicate_id ) {
		$original_post_slug = basename( get_the_permalink( $old_course_id ) );
		$duplicated_post_slug = wp_unique_post_slug( sanitize_title( $original_post_slug ), $new_duplicate_id, 'draft', 'academy_courses', null );
		wp_update_post(array(
			'ID'         => $new_duplicate_id,
			'post_name'  => $duplicated_post_slug,
		));
	}
	public function course_taxonomy_update( $old_id, $new_id, $taxonomy ) {
		if ( 'academy_courses_category' === $taxonomy || 'academy_courses_tag' === $taxonomy ) {
			$old_terms = get_the_terms( $old_id, $taxonomy );

			if ( is_array( $old_terms ) && ! empty( $old_terms ) ) {
				$term_ids = array();

				foreach ( $old_terms as $term ) {
					$term_ids[] = $term->term_id;
				}

				if ( count( $term_ids ) > 0 ) {
					wp_set_post_terms( $new_id, $term_ids, $taxonomy );
				}
			}
		}
	}

	public function duplicate_lesson_insert( $lesson, $type = '' ) {
		$arg = array(
			'lesson_author'   => get_current_user_id(),
			'lesson_title'    => $lesson->lesson_title . ' (copy)',
			'lesson_name'     => $lesson->lesson_name . '-copy',
			'lesson_content'  => $lesson->lesson_content,
			'lesson_excerpt'  => $lesson->lesson_excerpt,
			'lesson_status'   => 'draft',
			'comment_status'  => $lesson->comment_status,
			'comment_count'   => 0,
			'lesson_password' => $lesson->lesson_password,
		);
		if ( 'lesson_duplicate' === $type ) {
			$arg['lesson_title'] = $lesson->lesson_title;
		}
		$lesson_id = \Academy\Classes\Query::lesson_insert( $arg );
		return $lesson_id;
	}

	public function duplicate_lesson_meta_insert( $old_lesson_id, $new_lesson_id ) {
		// get lesson meta
		$lesson_meta_post = \Academy\Helper::get_lesson_meta_data( $old_lesson_id );
		\Academy\Classes\Query::lesson_meta_insert( $new_lesson_id, $lesson_meta_post );
	}

	public function duplicate_quiz( $quiz_id, $type = '' ) {
		$quiz_post = get_post( $quiz_id );
		$args = array(
			'post_author' => get_current_user_id(),
			'post_content' => $quiz_post->post_content,
			'post_title' => $quiz_post->post_title . ' (copy)',
			'post_status'  => 'draft',
			'post_excerpt' => $quiz_post->post_excerpt,
			'comment_status' => $quiz_post->comment_status,
			'ping_status' => $quiz_post->ping_status,
			'post_password' => $quiz_post->post_password,
			'post_name' => $quiz_post->post_name,
			'to_ping' => $quiz_post->to_ping,
			'pinged' => $quiz_post->pinged,
			'post_content_filtered' => $quiz_post->post_content_filtered,
			'post_parent' => $quiz_post->post_parent,
			'guid' => $quiz_post->guid,
			'menu_order' => $quiz_post->menu_order,
			'post_type' => $quiz_post->post_type,
			'post_mime_type' => $quiz_post->post_mime_type,
			'comment_count' => 0,
		);
		if ( 'quiz_duplicate' === $type ) {
			$args['post_title'] = $quiz_post->post_title;
		}
		return wp_insert_post( $args );
	}

	public function duplicate_quiz_meta( $quiz_id, $new_quiz_id ) {
		$old_quiz_meta = get_post_meta( $quiz_id );
		foreach ( $old_quiz_meta as $key => $value ) {
			$value = is_array( $value ) ? ( isset( $value[0] ) ? $value[0] : '' ) : '';
			$value = is_serialized( $value ) ? unserialize( $value ) : $value; //phpcs:ignore
			update_post_meta( $new_quiz_id, $key, $value );
		}
	}

	public function get_quiz_answers_by_question_id( $question_id, $question_type ) {
		global $wpdb;
		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching 
		return $wpdb->get_results(
			$wpdb->prepare(
				"SELECT answer_id, quiz_id, answer_title, is_correct, answer_content, image_id, view_format, answer_order  FROM {$wpdb->prefix}academy_quiz_answers WHERE question_id=%d AND question_type=%s",
				$question_id,
				$question_type
			),
			OBJECT
		);
	}

	public function duplicate_quiz_answer_insert( $quiz_id, $question_id, $answers, $question_type ) {
		foreach ( $answers as $answer ) {
			\AcademyQuizzes\Classes\Query::quiz_answer_insert(array(
				'quiz_id'            => $quiz_id,
				'question_id'        => $question_id,
				'question_type'      => $question_type,
				'answer_title'       => $answer->answer_title,
				'answer_content'     => $answer->answer_content,
				'is_correct'         => $answer->is_correct,
				'image_id'           => $answer->image_id,
				'view_format'        => $answer->view_format,
				'answer_order'       => $answer->answer_order,
			));
		}
	}

	public function quiz_questions_answer_insert( $questions, $new_quiz_id ) {
		foreach ( $questions as $question ) {
			$new_question_id = \AcademyQuizzes\Classes\Query::quiz_question_insert(array(
				'quiz_id'               => $new_quiz_id,
				'question_title'        => $question->question_title,
				'question_name'         => $question->question_name,
				'question_content'      => $question->question_content,
				'question_level'        => $question->question_level,
				'question_type'         => $question->question_type,
				'question_score'        => $question->question_score,
				'question_settings'     => $question->question_settings,
				'question_order'        => $question->question_order,
			));
			$answers = $this->get_quiz_answers_by_question_id( $question->question_id, $question->question_type );
			if ( $answers ) {
				$this->duplicate_quiz_answer_insert( $new_quiz_id, $new_question_id, $answers, $question->question_type );
			}
		}
	}

	public function duplicate_assignment_value( $assignment_id ) {
		$assignment_data = get_post( $assignment_id );
		$new_assignment_id = wp_insert_post( array(
			'post_author' => get_current_user_id(),
			'post_content' => $assignment_data->post_content,
			'post_title' => $assignment_data->post_title,
			'post_status'  => $assignment_data->post_status,
			'post_excerpt' => $assignment_data->post_excerpt,
			'comment_status' => $assignment_data->comment_status,
			'ping_status' => $assignment_data->ping_status,
			'post_password' => $assignment_data->post_password,
			'post_name' => $assignment_data->post_name,
			'to_ping' => $assignment_data->to_ping,
			'pinged' => $assignment_data->pinged,
			'post_content_filtered' => $assignment_data->post_content_filtered,
			'post_parent' => $assignment_data->post_parent,
			'guid' => $assignment_data->guid,
			'menu_order' => $assignment_data->menu_order,
			'post_type' => $assignment_data->post_type,
			'post_mime_type' => $assignment_data->post_mime_type,
			'comment_count' => 0,
		) );
		$old_attachment_meta = get_post_meta( $assignment_id );
		foreach ( $old_attachment_meta as $key => $value ) {
			$value = is_array( $value ) ? ( isset( $value[0] ) ? $value[0] : '' ) : '';
			$value = is_serialized( $value ) ? unserialize( $value ) : $value; //phpcs:ignore
			update_post_meta( $new_assignment_id, $key, $value );
		}
		return array(
			'id'    => $new_assignment_id,
			'name' => $assignment_data->post_title,
			'type'  => 'assignment',
		);
	}

	public function duplicate_zoom_value( $zoom_id ) {
		$zoom = get_post( $zoom_id );
		$new_zoom_id = wp_insert_post( array(
			'post_author' => get_current_user_id(),
			'post_content' => $zoom->post_content,
			'post_title' => $zoom->post_title,
			'post_status'  => $zoom->post_status,
			'post_excerpt' => $zoom->post_excerpt,
			'comment_status' => $zoom->comment_status,
			'ping_status' => $zoom->ping_status,
			'post_password' => $zoom->post_password,
			'post_name' => $zoom->post_name,
			'to_ping' => $zoom->to_ping,
			'pinged' => $zoom->pinged,
			'post_content_filtered' => $zoom->post_content_filtered,
			'post_parent' => $zoom->post_parent,
			'guid' => $zoom->guid,
			'menu_order' => $zoom->menu_order,
			'post_type' => $zoom->post_type,
			'post_mime_type' => $zoom->post_mime_type,
			'comment_count' => 0,
		) );
		$old_zoom_meta = get_post_meta( $zoom_id );
		foreach ( $old_zoom_meta as $key => $value ) {
			$value = is_array( $value ) ? ( isset( $value[0] ) ? $value[0] : '' ) : '';
			$value = is_serialized( $value ) ? unserialize( $value ) : $value; //phpcs:ignore
			update_post_meta( $new_zoom_id, $key, $value );
		}
		return array(
			'id' => $new_zoom_id,
			'name' => $zoom->post_title,
			'type'  => 'zoom',
		);
	}

	public function duplicate_booking_value( $booking_id ) {
		$booking = get_post( $booking_id );
		$new_booking_id = wp_insert_post( array(
			'post_author' => get_current_user_id(),
			'post_content' => $booking->post_content,
			'post_title' => $booking->post_title,
			'post_status'  => $booking->post_status,
			'post_excerpt' => $booking->post_excerpt,
			'comment_status' => $booking->comment_status,
			'ping_status' => $booking->ping_status,
			'post_password' => $booking->post_password,
			'post_name' => $booking->post_name,
			'to_ping' => $booking->to_ping,
			'pinged' => $booking->pinged,
			'post_content_filtered' => $booking->post_content_filtered,
			'post_parent' => $booking->post_parent,
			'guid' => $booking->guid,
			'menu_order' => $booking->menu_order,
			'post_type' => $booking->post_type,
			'post_mime_type' => $booking->post_mime_type,
			'comment_count' => 0,
		) );
		$old_booking_meta = get_post_meta( $booking_id );
		foreach ( $old_booking_meta as $key => $value ) {
			$value = is_array( $value ) ? ( isset( $value[0] ) ? $value[0] : '' ) : '';
			$value = is_serialized( $value ) ? unserialize( $value ) : $value; //phpcs:ignore
			update_post_meta( $new_booking_id, $key, $value );
		}
		return array(
			'id' => $new_booking_id,
			'name' => $booking->post_title,
			'type'  => 'booking',
		);
	}
}
