<?php
namespace AcademyPro;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Academy\Helper;
use \Academy\Classes\ScriptsBase;

class Assets {

	public static function init() {
		$self = new self();
		add_action( 'admin_enqueue_scripts', [ $self, 'backend_scripts' ] );
		add_action( 'wp_enqueue_scripts', [ $self, 'frontend_scripts' ] );
		add_action( 'wp_enqueue_scripts', [ $self, 'enqueue_recaptcha_script' ], 10 );
		add_filter( 'academy/assets/frontend_scripts_data', [ $self, 'localize_scripts_data' ] );
	}
	/**
	 * Enqueue Files on Start Plugin
	 *
	 * @param string $hook
	 * @function backend_scripts
	 */
	public function backend_scripts( $hook ) {
		if ( \Academy\Helper::plugin_page_hook_suffix( $hook ) ) {
			wp_enqueue_style( 'academy-pro-admin-style', ACADEMY_PRO_ASSETS_URI . 'build/backend.css', array( 'wp-components' ), filemtime( ACADEMY_PRO_ASSETS_DIR_PATH . 'build/backend.css' ), 'all' );
			// js
			$dependencies = include ACADEMY_PRO_ASSETS_DIR_PATH . sprintf( 'build/backend.%s.asset.php', ACADEMY_PRO_VERSION );
			wp_enqueue_script(
				'academy-pro-admin-scripts',
				ACADEMY_PRO_ASSETS_URI . sprintf( 'build/backend.%s.js', ACADEMY_PRO_VERSION ),
				array_merge( $dependencies['dependencies'] ?? [], [ 'academy-admin-scripts' ] ),
				$dependencies['version'],
				true
			);
			wp_set_script_translations( 'academy-pro-admin-scripts', 'academy-pro', ACADEMY_PRO_ROOT_DIR_PATH . 'languages' );
		}//end if
	}

	public function frontend_scripts() {
		$scriptBase = new ScriptsBase();
		if ( apply_filters( 'academy_pro/is_load_frontend_scripts', $scriptBase->is_frontend_dashboard_page() ) ) {
			if ( is_user_logged_in() ) {
				$dependencies = include ACADEMY_PRO_ASSETS_DIR_PATH . sprintf( 'build/frontend.%s.asset.php', ACADEMY_PRO_VERSION );
				wp_enqueue_script(
					'academy-pro-frontend-scripts',
					ACADEMY_PRO_ASSETS_URI . sprintf( 'build/frontend.%s.js', ACADEMY_PRO_VERSION ),
					array_merge( $dependencies['dependencies'] ?? [], [ 'academy-frontend-dashboard-scripts' ] ),
					$dependencies['version'],
					true
				);
				wp_set_script_translations( 'academy-pro-frontend-scripts', 'academy-pro', ACADEMY_PRO_ROOT_DIR_PATH . 'languages' );
			}
		}
	}

	public function enqueue_recaptcha_script() {
		global $post;
		if ( ! \Academy\Helper::get_settings( 'is_enabled_recaptcha', false ) || 'v3' !== \Academy\Helper::get_settings( 'recaptcha_type', 'v2' ) ) {
			return;
		}

		if (
			$post &&
			(
				is_singular( 'academy_courses' ) ||
				(int) \Academy\Helper::get_settings( 'frontend_instructor_reg_page' ) === $post->ID ||
				(int) \Academy\Helper::get_settings( 'frontend_student_reg_page' ) === $post->ID ||
				has_shortcode( $post->post_content, 'academy_dashboard' ) ||
				has_shortcode( $post->post_content, 'academy_instructor_registration_form' ) ||
				has_shortcode( $post->post_content, 'academy_student_registration_form' ) ||
				has_shortcode( $post->post_content, 'academy_login_form' )
			)
		) {
			wp_enqueue_script( 'google-recaptcha', 'https://www.google.com/recaptcha/api.js?render=' . \Academy\Helper::get_settings( 'recaptcha_v3_site_key', '' ), array(), ACADEMY_PRO_VERSION, false );
		}
	}
	public function localize_scripts_data( $data ) {
		// recaptcha
		$data['is_enabled_recaptcha'] = \Academy\Helper::get_settings( 'is_enabled_recaptcha', false );
		$data['is_enabled_group_plus'] = \Academy\Helper::get_addon_active_status( 'group-plus', true );
		if ( $data['is_enabled_recaptcha'] ) {
			$data['recaptcha_type'] = \Academy\Helper::get_settings( 'recaptcha_type', 'v2' );
			if ( 'v3' === $data['recaptcha_type'] ) {
				$data['recaptcha_v3_site_key'] = \Academy\Helper::get_settings( 'recaptcha_v3_site_key', '' );
			} else {
				$data['recaptcha_v2_site_key'] = \Academy\Helper::get_settings( 'recaptcha_v2_site_key', '' );
			}
		}
		return $data;
	}
}
