<?php
namespace AcademyPro\Admin;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Academy\Admin\Settings\Base as BaseSettings;
use Academy\Classes\Sanitizer;


class Settings {
	public static function init() {
		$self = new self();
		add_action( 'academy/admin/after_save_settings', array( $self, 'save_base_settings' ), 10, 3 );
		add_filter( 'academy/admin/settings/base_default_data', array( $self, 'settings_default_data' ) );
	}

	public function save_base_settings( $status, $settings_mode, $POST ) {
		$payload = Sanitizer::sanitize_payload([
			'is_expire_course_enrollment' => 'boolean',
			'auto_load_next_lesson' => 'boolean',
			'auto_complete_topic' => 'boolean',
			// recaptcha
			'is_enabled_recaptcha' => 'boolean',
			'recaptcha_type' => 'string',
			'recaptcha_v2_site_key' => 'string',
			'recaptcha_v2_secret_key' => 'string',
			'recaptcha_v3_site_key' => 'string',
			'recaptcha_v3_secret_key' => 'string',
			// device login restrictions
			'is_enable_device_login_restriction' => 'boolean',
			'device_login_restriction_limit' => 'integer'
		], $POST);

		$default = BaseSettings::get_default_data();

		$is_update = BaseSettings::save_settings( [
			'is_expire_course_enrollment' => $payload['is_expire_course_enrollment'] ?? $default['is_expire_course_enrollment'],
			'auto_load_next_lesson' => $payload['auto_load_next_lesson'] ?? $default['auto_load_next_lesson'],
			'auto_complete_topic' => $payload['auto_complete_topic'] ?? $default['auto_complete_topic'],
			// Recaptcha
			'is_enabled_recaptcha' => $payload['is_enabled_recaptcha'] ?? $default['is_enabled_recaptcha'],
			'recaptcha_type' => $payload['recaptcha_type'] ?? $default['recaptcha_type'],
			'recaptcha_v2_site_key' => $payload['recaptcha_v2_site_key'] ?? $default['recaptcha_v2_site_key'],
			'recaptcha_v2_secret_key' => $payload['recaptcha_v2_secret_key'] ?? $default['recaptcha_v2_secret_key'],
			'recaptcha_v3_site_key' => $payload['recaptcha_v3_site_key'] ?? $default['recaptcha_v3_site_key'],
			'recaptcha_v3_secret_key' => $payload['recaptcha_v3_secret_key'] ?? $default['recaptcha_v3_secret_key'],
			'is_enable_device_login_restriction' => $payload['is_enable_device_login_restriction'] ?? $default['is_enable_device_login_restriction'],
			'device_login_restriction_limit' => $payload['device_login_restriction_limit'] ?? $default['device_login_restriction_limit'],
		]);

		do_action( 'academy_pro/admin/after_save_settings', $is_update, 'base', $POST );
		return $is_update;
	}

	public function settings_default_data( $default_settings ) {
		$default_settings['is_expire_course_enrollment'] = false;
		$default_settings['auto_load_next_lesson'] = false;
		$default_settings['auto_complete_topic'] = false;
		// recaptcha
		$default_settings['is_enabled_recaptcha'] = false;
		$default_settings['recaptcha_type'] = 'v2';
		$default_settings['recaptcha_v2_site_key'] = '';
		$default_settings['recaptcha_v2_secret_key'] = '';
		$default_settings['recaptcha_v3_site_key'] = '';
		$default_settings['recaptcha_v3_secret_key'] = '';
		// device login
		$default_settings['is_enable_device_login_restriction'] = false;
		$default_settings['device_login_restriction_limit'] = 0;
		return $default_settings;
	}
}
