<?php
namespace AcademyPro;

use AcademyProStoreEngine\Storeengine;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


class Addons {
	public static function init() {
		$self = new self();
		// Load all addons
		$self->addons_loader();
	}

	private function addons_loader() {
		$Autoload = Autoload::get_instance();
		$addons = apply_filters('academy_pro/addons/loader_args', [
			'email' => 'Email',
			'assignments' => 'Assignments',
			'content-drip' => 'ContentDrip',
			'enrollment' => 'Enrollment',
			'woocommerce-subscriptions' => 'WoocommerceSubscriptions',
			'meeting' => 'Meeting',
			'advanced-analytics' => 'AdvancedAnalytics',
			'tutor-booking' => 'TutorBooking',
			'paid-memberships-pro' => 'PaidMembershipsPro',
			'course-prerequisites' => 'CoursePrerequisites',
			'course-bundle' => 'CourseBundle',
			'white-label' => 'WhiteLabel',
			'scorm' => 'Scorm',
			'social-login' => 'SocialLogin',
			'surecart' => 'Surecart',
			'suremembers' => 'Suremembers',
			'notifications' => 'Notifications',
			'grade-book' => 'GradeBook',
			'wishlist-member' => 'WishlistMember',
			'gamipress'  => 'Gamipress',
			'fluent-crm' => 'FluentCRM',
			'google-classroom' => 'GoogleClassroom',
			'mail-chimp' => 'MailChimp',
			'woocommerce' => 'Woocommerce',
			'easy-digital-downloads' => 'EasyDigitalDownloads',
			'certificates' => 'Certificates',
			'restrict-content-pro' => 'RestrictContentPro',
			'device-login-restrictions' => 'DeviceLoginRestrictions',
			'buddypress'      => 'Buddypress',
			'buddyboss' => 'Buddyboss',
			'calendar' => 'Calendar',
			'fluent-community' => 'FluentCommunity',
			'wpml' => 'Wpml',
			'group-plus' => 'GroupPlus',
			'sendfox' => 'Sendfox',
		]);
		foreach ( $addons as $addon_name => $addon_class_name ) {
			$addon_root_path = ACADEMY_PRO_ADDONS_DIR_PATH . $addon_name . '/';
			// Register the addon's root namespace and path.
			$addon_namespace = 'AcademyPro' . $addon_class_name;
			$Autoload->add_namespace_directory( $addon_namespace, $addon_root_path );
			// Initialize the addon's main class.
			$class = $addon_namespace . '\\' . $addon_class_name;
			$class::init();
		}

		$Autoload->add_namespace_directory( 'AcademyProStoreEngine', ACADEMY_PRO_ADDONS_DIR_PATH . 'storeengine/' );
		Storeengine::init();
	}
}
