<?php
namespace AcademyProWpml\Classes;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
class Settings {
	public function default_data( array $data ): array {
		$data['lesson_translation'] = false;
		return $data;
	}
	public function sanitize_payload( array $data ): array {
		$data['lesson_translation'] = 'boolean';
		return $data;
	}
	public function save( array $data, array $payload, array $default ): array {
		$data['lesson_translation'] = $payload['lesson_translation'] ?? $default['lesson_translation'] ?? false;
		return $data;
	}
	public static function init(): void {
		$ins = new static();
		add_filter( 'academy/admin/settings/base_default_data', [ $ins, 'default_data' ] );
		add_filter( 'academy/admin/settings/sanitize_payload', [ $ins, 'sanitize_payload' ] );
		add_filter( 'academy/admin/settings/save', [ $ins, 'save' ], 10, 3 );
	}
}
