<?php
namespace AcademyProWpml\Classes;

use Exception;
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
class KeepPluginPages extends Base {
	public function is_academy_page(): bool {
		return in_array( $this->page_id, $this->pages );
	}

	public function set_default( ?object $query ): void {
		try {
			$this->load_conf();
		} catch ( Exception $e ) {
			return;
		}
		if ( is_admin() || ! $query->is_main_query() || ! $this->is_academy_page() ) {
			return;
		}

		$this->sitepress->switch_lang( self::$default_lang );
		self::$lang_changed = true;
	}
	public function set_current( ?object $query ): void {
		try {
			$this->load_conf();
		} catch ( Exception $e ) {
			return;
		}

		if ( ! self::$lang_changed ) {
			return;
		}

		$this->sitepress->switch_lang( self::$current_lang );
	}

	public static function init(): void {
		$ins = new self();
		add_action( 'pre_get_posts', [ $ins, 'set_default' ] );
		add_action( 'wp', [ $ins, 'set_current' ] );
	}
}
