<?php
namespace AcademyProWpml\Classes;

use Exception;
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
abstract class Base {
	public static bool $lang_changed = false;
	public static string $default_lang;
	public static string $current_lang;
	public object $sitepress;
	public array $pages;
	public int $page_id;

	public function load_conf( bool $skip_lang_set = false, bool $skip_page_set = false ) {
		global $wp_query, $sitepress;
		if ( ! is_object( $sitepress ) ) {
			throw new Exception( esc_html__( 'WPML is not available.', 'academy-pro' ) );// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
		}
		$this->sitepress = $sitepress;
		if ( ! $skip_page_set ) {
			$this->pages = array_map(
				'absint',
				array_filter([
					$GLOBALS['academy_settings']->frontend_dashboard_page ?? null,
					$GLOBALS['academy_settings']->frontend_student_reg_page ?? null,
					$GLOBALS['academy_settings']->password_reset_page ?? null,
					$GLOBALS['academy_settings']->lessons_page ?? null,
					$GLOBALS['academy_settings']->course_page ?? null,
					$GLOBALS['academy_settings']->frontend_instructor_reg_page ?? null,
				])
			);

			if ( empty( $this->pages ) ) {
				throw new Exception( esc_html__( 'Page list is empty.', 'academy-pro' ) );// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
			}
			$this->page_id = $wp_query ? $wp_query->get_queried_object_id() : 0;
			if ( empty( $this->page_id ) && ! is_null( $wp_query ) && method_exists( $wp_query, 'get_queried_object_id' ) ) {
				throw new Exception( esc_html__( 'Page id is invalid.', 'academy-pro' ) );// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
			}
		}//end if
		if ( ! $skip_lang_set ) {
			self::$default_lang = apply_filters( 'wpml_default_language', null );
			self::$current_lang = apply_filters( 'wpml_current_language', null );
		}
	}
}
