<?php

namespace AcademyProWoocommerce\Ajax;

use Academy\Classes\AbstractAjaxHandler;
use Academy\Classes\Sanitizer;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Admin extends AbstractAjaxHandler {
	protected $namespace = 'academy_pro_woo';
	public function __construct() {
		$this->actions = [
			'get_product' => array(
				'callback' => array( $this, 'woo_get_product' ),
				'capability' => 'manage_academy_instructor',
			),
			'create_or_update_product' => array(
				'callback' => array( $this, 'woo_create_or_update_product' ),
				'capability' => 'manage_academy_instructor',
			)
		];
	}

	public function woo_get_product( $payload_data ) {
		$payload = Sanitizer::sanitize_payload([
			'productId' => 'integer',
		], $payload_data );

		$productId = isset( $payload['productId'] ) ? $payload['productId'] : 0;
		$product = new \WC_Product_Simple( $productId );

		$response = [
			'product_id' => $productId,
		];
		if ( $product->get_regular_price() ) {
			$response['regular_price'] = (float) $product->get_regular_price();
		}
		if ( $product->get_sale_price() ) {
			$response['sale_price'] = (float) $product->get_sale_price();
		}
		wp_send_json_success( $response );
	}

	public function woo_create_or_update_product( $payload_data ) {
		$payload = Sanitizer::sanitize_payload([
			'id'                => 'integer',
			'title'             => 'string',
			'slug'              => 'string',
			'payment_id'        => 'integer',
			'regular_price'     => 'string',
			'sale_price'        => 'string',
		], $payload_data );

		$course_id = (int) isset( $payload['id'] ) ? $payload['id'] : 0;
		$product_id = isset( $payload['payment_id'] ) ? $payload['payment_id'] : 0;
		$course_title = isset( $payload['title'] ) ? $payload['title'] : '';
		$course_slug = isset( $payload['slug'] ) ? $payload['slug'] : '';
		$regular_price = isset( $payload['regular_price'] ) ? $payload['regular_price'] : '';
		$sale_price = isset( $payload['sale_price'] ) ? $payload['sale_price'] : '';

		if ( 'undefined' === $course_id || 0 === $course_id ) {
			wp_send_json_error(
				esc_html__( 'Save Course Then Create Product', 'academy-pro' )
			);
		}
		$product_id = get_post_meta( $course_id, 'academy_course_product_id', true );

		// that's CRUD object
		$product = new \WC_Product_Simple( $product_id );
		$product->set_name( $course_title );
		$product->set_slug( $course_slug );
		$product->set_regular_price( $regular_price );
		if ( $sale_price ) {
			$product->set_sale_price( $sale_price );
		}
		$product_id = $product->save();

		if ( $product_id ) {
			update_post_meta( $product_id, '_academy_product', 'yes' );
		}
		if ( $course_id ) {
			update_post_meta( $course_id, 'academy_course_product_id', $product_id );
		}
		$response = [
			'product_id' => $product_id,
		];

		if ( $product->get_regular_price() ) {
			$response['regular_price'] = (float) $product->get_regular_price();
		}
		if ( $product->get_sale_price() ) {
			$response['sale_price'] = (float) $product->get_sale_price();
		}

		wp_send_json_success( $response );
	}
}
