<?php

namespace AcademyProWishlistMember;

class Init {
	public function __construct() {
		add_action( 'wp_ajax_wlm3_academylms_check_plugin', array( $this, 'check_plugin' ) );
	}

	public function check_plugin() {
		$data['status']  = true;
		$data['message'] = 'Academy LMS is activated';
		$data['courses'] = array();

		$the_posts       = new \WP_Query(
			array(
				'post_type' => 'academy_courses',
				'nopaging'  => true,
			)
		);

		$courses         = array();

		if ( count( $the_posts->posts ) ) {
			foreach ( $the_posts->posts as $c ) {
				$courses[ $c->ID ] = $c->post_title;
			}
			$data['courses'] = $courses;
		} else {
			$data['status']  = false;
			$data['message'] = 'You need to create academy lms course to proceed';
		}

		wp_die( wp_json_encode( $data ) );
	}
}

