<?php

namespace AcademyProWishlistMember;

class Helper {
	public static function is_wishlist_member_active() {
		$active_plugins = get_option( 'active_plugins', array() );
		return in_array( 'wishlist-member/wpm.php', $active_plugins, true ) || in_array( 'wishlist-member-x/wpm.php', $active_plugins, true );
	}

	public static function get_courses() {
		$the_posts = new \WP_Query(
			array(
				'post_type' => 'academy_courses',
				'nopaging'  => true,
			)
		);

		$courses = array();

		if ( count( $the_posts->posts ) ) {
			foreach ( $the_posts->posts as $key => $post ) {
				$courses[ $post->ID ] = array(
					'id'    => $post->ID,
					'title' => $post->post_title,
				);
			}
		}

		return $courses;
	}

	public static function get_config_for_wishlist() {
		return array(
			'id'       => 'academylms',
			'video_id' => '0', // add when tutorial is uploaded
			'link'     => 'https://academylms.net',
			'tutorial' => '', // add the tutorial link
			'name'     => 'Academy LMS',
			'pro'      => true,
		);
	}
}
