<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$courses = \AcademyProWishlistMember\Helper::get_courses();
$config = \AcademyProWishlistMember\Helper::get_config_for_wishlist();

foreach ( $courses as $course_id => $course ) :
	?>
	<div
		data-process="modal"
		id="academylms-course-<?php echo esc_attr( $course_id ); ?>-template"
		data-id="academylms-course-<?php echo esc_attr( $course_id ); ?>"
		data-label="academylms-course-<?php echo esc_attr( $course_id ); ?>"
		data-title="Editing <?php echo esc_attr( $config['name'] ); ?> Actions for <?php echo esc_attr( $course['title'] ); ?>"
		data-show-default-footer="1"
		data-classes="modal-lg modal-academylms-actions"
		style="display:none">
		<div class="body">
			<div class="row">
				<div class="col-md-12">
					<ul class="nav nav-tabs">
						<li class="active nav-item"><a class="nav-link" data-toggle="tab" href="#academylms-course-add-<?php echo esc_attr( $course_id ); ?>"><?php echo esc_html( 'When Enroll The Course' ); ?></a></li>
						<li class="nav-item"><a class="nav-link" data-toggle="tab" href="#academylms-course-complete-<?php echo esc_attr( $course_id ); ?>"><?php echo esc_html( 'When Course is Completed' ); ?></a></li>
					</ul>
				</div>
			</div>
			<div class="tab-content">
				<?php $c_actions = array( 'add', 'complete' ); ?>
				<?php foreach ( $c_actions as $c_action ) : ?>
					<div class="row tab-pane <?php echo esc_attr( 'add' === $c_action ? 'active in' : '' ); ?>" id="academylms-course-<?php echo esc_attr( $c_action ); ?>-<?php echo esc_attr( $course_id ); ?>">
						<div class="col-md-12">
							<div class="form-group">
								<label><?php esc_html_e( 'Add to Level', 'academy-pro' ); ?></label>
								<select class="wlm-select academylms-levels-select" multiple="multiple" data-placeholder="Select levels..." style="width:100%" name="academylms_settings[course][<?php echo esc_attr( $course_id ); ?>][<?php echo esc_attr( $c_action ); ?>][add_level][]"></select>
							</div>
						</div>
						<div class="col-md-12">
							<div class="form-group">
								<label><?php esc_html_e( 'Cancel from Level', 'academy-pro' ); ?></label>
								<select class="wlm-select academylms-levels-select" multiple="multiple" data-placeholder="Select levels..." style="width:100%" name="academylms_settings[course][<?php echo esc_attr( $course_id ); ?>][<?php echo esc_attr( $c_action ); ?>][cancel_level][]"></select>
							</div>
						</div>
						<div class="col-md-12">
							<div class="form-group">
								<label><?php esc_html_e( 'Remove from Level', 'academy-pro' ); ?></label>
								<select class="wlm-select academylms-levels-select" multiple="multiple" data-placeholder="Select levels..." style="width:100%" name="academylms_settings[course][<?php echo esc_attr( $course_id ); ?>][<?php echo esc_attr( $c_action ); ?>][remove_level][]"></select>
							</div>
						</div>
					</div>
				<?php endforeach; ?>
			</div>
		</div>
	</div>
	<?php
endforeach;
?>
