<?php

namespace AcademyProWishlistMember;

class Admin {

	public $the_posts;

	public $courses;

	public $all_tabs;

	public $active_tab;

	public $api_not_required;

	public function __construct() {
		$this->courses = Helper::get_courses();
		$this->set_tab_details();
		$this->render();
		$this->get_admin_init();
		$this->set_javascript();
	}

	public function check_plugin() {
		wp_send_json_success();
	}

	public function set_tab_details() {
		$this->active_tab = 'level';
		$this->api_not_required = [];
		$this->all_tabs = [
			'level' => 'Membership Level Actions',
			'courses' => 'Course Actions',
		];
	}

	public function render() {
		\AcademyPro\Helper::get_template('wishlist-member/body.php', [
			'all_tabs' => $this->all_tabs,
			'active_tab' => $this->active_tab,
			'api_not_required' => $this->api_not_required,
			'courses' => $this->courses,
		]);
	}

	public function get_admin_init() {
		require_once 'admin/init.php';
	}

	public function set_javascript() {
		wlm_print_script( plugin_dir_url( __FILE__ ) . 'assets/admin.js' );
	}
}

new Admin();
