<?php
namespace AcademyProTutorBooking\Admin;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Academy\Classes\AbstractAjaxHandler;
use Academy\Classes\Sanitizer;

class Woocommerce extends AbstractAjaxHandler {
	protected $namespace = 'academy_pro_woo';
	public function __construct() {
		$this->actions = array(
			'create_or_update_booking_product' => array(
				'callback' => array( $this, 'create_or_update_booking_product' ),
				'capability' => 'manage_academy_instructor',
			),
			'get_booking_products' => array(
				'callback' => array( $this, 'get_booking_products' ),
				'capablity' => 'manage_academy_instructor',
			)
		);
	}

	public function create_or_update_booking_product( $payload_data ) {
		$payload = Sanitizer::sanitize_payload([
			'id' => 'int',
			'payment_id' => 'int',
			'title' => 'string',
			'slug' => 'string',
			'regular_price' => 'string',
			'sale_price' => 'string',
		], $payload_data );

		$booking_id = isset( $payload['id'] ) ? $payload['id'] : 0;
		$product_id = isset( $payload['payment_id'] ) ? $payload['payment_id'] : 0;
		$course_title = isset( $payload['title'] ) ? $payload['title'] : '';
		$regular_price = isset( $payload['regular_price'] ) ? $payload['regular_price'] : '';
		$sale_price = isset( $payload['sale_price'] ) ? $payload['sale_price'] : '';

		// that's CRUD object
		$product_id = get_post_meta( $booking_id, '_academy_booking_product_id', true );
		$product = new \WC_Product_Simple( $product_id );
		$product->set_name( $course_title );
		$product->set_regular_price( $regular_price );
		if ( $sale_price ) {
			$product->set_sale_price( $sale_price );
		}
		$product_id = $product->save();

		if ( $product_id ) {
			update_post_meta( $product_id, '_booking_product', 'yes' );
		}

		if ( $booking_id ) {
			update_post_meta( $booking_id, '_academy_booking_product_id', $product_id );
		}
		$response = [
			'product_id' => $product_id,
		];
		if ( $product->get_regular_price() ) {
			$response['regular_price'] = (float) $product->get_regular_price();
		}
		if ( $product->get_sale_price() ) {
			$response['sale_price'] = (float) $product->get_sale_price();
		}
		wp_send_json_success( $response );
	}

	public function get_booking_products( $payload_data ) {
		global $wpdb;
		$post_type               = 'product';
		$paid_booking_product_ids = [];
		$payload                 = Sanitizer::sanitize_payload( [
			'postId'  => 'integer',
			'keyword' => 'string',
		], $payload_data );

		$postId  = isset( $payload['postId'] ) ? $payload['postId'] : 0;
		$keyword = isset( $payload['keyword'] ) ? $payload['keyword'] : '';

		if ( $postId ) {
			$args = array(
				'post_type' => $post_type,
				'p'         => $postId,
			);
		} else {
			$args = array(
				'post_type'      => $post_type,
				'posts_per_page' => 10,
			);
			if ( ! empty( $keyword ) ) {
				$args['s'] = $keyword;
			}

			// fetch all paid course product id
			// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
			$paid_booking_product_ids = $wpdb->get_results( $wpdb->prepare(
				"SELECT meta_value FROM {$wpdb->postmeta} postmeta  WHERE postmeta.meta_key = 'academy_booking_product_id' AND postmeta.meta_value != %d", 0
			), ARRAY_A );
			$paid_booking_product_ids = wp_list_pluck( $paid_booking_product_ids, 'meta_value', 'meta_value' );
		}//end if

		$results = array();
		$posts   = get_posts( $args );

		if ( is_array( $posts ) ) {
			foreach ( $posts as $post ) {
				if ( $postId !== (int) $post->ID && isset( $paid_booking_product_ids[ $post->ID ] ) ) {
					continue;
				}
				$results[] = array(
					'label' => $post->post_title,
					'value' => $post->ID,
				);
			}
		}

		wp_send_json_success( $results );
	}
}
